/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.jdbc;

import org.apache.flume.Channel;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.Transaction;
import org.apache.flume.channel.jdbc.JdbcChannelProvider;
import org.apache.flume.channel.jdbc.JdbcChannelProviderFactory;
import org.apache.flume.conf.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcChannel
implements Channel,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcChannel.class);
    private JdbcChannelProvider provider;
    private String name;

    public void put(Event event) throws ChannelException {
        this.getProvider().persistEvent(this.getName(), event);
    }

    public Event take() throws ChannelException {
        return this.getProvider().removeEvent(this.getName());
    }

    public Transaction getTransaction() {
        return this.getProvider().getTransaction();
    }

    public void shutdown() {
        JdbcChannelProviderFactory.releaseProvider(this.name);
        this.provider = null;
        this.name = null;
    }

    public String getName() {
        return this.name;
    }

    private JdbcChannelProvider getProvider() {
        return this.provider;
    }

    public void configure(Context context) {
        this.name = "jdbc";
        this.provider = JdbcChannelProviderFactory.getProvider(context, this.name);
        LOG.info("JDBC Channel initialized: " + this.name);
    }
}

