/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.jdbc.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import javax.sql.DataSource;
import org.apache.flume.Transaction;
import org.apache.flume.channel.jdbc.JdbcChannelException;
import org.apache.flume.channel.jdbc.impl.JdbcTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTransactionImpl
implements Transaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcTransactionImpl.class);
    private final DataSource dataSource;
    private Connection connection;
    private JdbcTransactionFactory txFactory;
    boolean active = true;
    int count = 0;
    boolean rollback = false;

    protected JdbcTransactionImpl(DataSource dataSource, JdbcTransactionFactory factory) {
        this.dataSource = dataSource;
        this.txFactory = factory;
    }

    public void begin() {
        if (!this.active) {
            throw new JdbcChannelException("Inactive transaction");
        }
        if (this.count == 0) {
            try {
                this.connection = this.dataSource.getConnection();
            }
            catch (SQLException ex) {
                throw new JdbcChannelException("Unable to lease connection", ex);
            }
            try {
                this.connection.clearWarnings();
            }
            catch (SQLException ex) {
                LOGGER.error("Error while clearing warnings: " + ex.getErrorCode(), (Throwable)ex);
            }
        }
        ++this.count;
        LOGGER.debug("Tx count-begin: " + this.count + ", rollback: " + this.rollback);
    }

    public void commit() {
        if (!this.active) {
            throw new JdbcChannelException("Inactive transaction");
        }
        if (this.rollback) {
            throw new JdbcChannelException("Cannot commit transaction marked for rollback");
        }
        LOGGER.debug("Tx count-commit: " + this.count + ", rollback: " + this.rollback);
    }

    public void rollback() {
        if (!this.active) {
            throw new JdbcChannelException("Inactive transaction");
        }
        LOGGER.warn("Marking transaction for rollback");
        this.rollback = true;
        LOGGER.debug("Tx count-rollback: " + this.count + ", rollback: " + this.rollback);
    }

    public void close() {
        if (!this.active) {
            throw new JdbcChannelException("Inactive transaction");
        }
        --this.count;
        LOGGER.debug("Tx count-close: " + this.count + ", rollback: " + this.rollback);
        if (this.count == 0) {
            this.active = false;
            try {
                if (this.rollback) {
                    LOGGER.info("Attempting transaction roll-back");
                    this.connection.rollback();
                } else {
                    LOGGER.info("Attempting transaction commit");
                    this.connection.commit();
                }
            }
            catch (SQLException ex) {
                throw new JdbcChannelException("Unable to finalize transaction", ex);
            }
            finally {
                if (this.connection != null) {
                    try {
                        SQLWarning warning = this.connection.getWarnings();
                        if (warning != null) {
                            StringBuilder sb = new StringBuilder("Connection warnigns: ");
                            boolean first = true;
                            while (warning != null) {
                                if (first) {
                                    first = false;
                                } else {
                                    sb.append("; ");
                                }
                                sb.append("[").append(warning.getErrorCode()).append("] ");
                                sb.append(warning.getMessage());
                            }
                            LOGGER.warn(sb.toString());
                        }
                    }
                    catch (SQLException ex) {
                        LOGGER.error("Error while retrieving warnigns: " + ex.getErrorCode(), (Throwable)ex);
                    }
                    try {
                        this.connection.close();
                    }
                    catch (SQLException ex) {
                        LOGGER.error("Unable to close connection: " + ex.getErrorCode(), (Throwable)ex);
                    }
                }
                this.txFactory.remove();
                this.connection = null;
                this.txFactory = null;
            }
        }
    }

    protected Connection getConnection() {
        if (!this.active) {
            throw new JdbcChannelException("Inactive transaction");
        }
        return this.connection;
    }
}

