/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.SinkRunner;
import org.apache.flume.SourceRunner;
import org.apache.flume.node.MaterializedConfiguration;

public class SimpleMaterializedConfiguration
implements MaterializedConfiguration {
    private final Map<String, Channel> channels = new HashMap<String, Channel>();
    private final Map<String, SourceRunner> sourceRunners = new HashMap<String, SourceRunner>();
    private final Map<String, SinkRunner> sinkRunners = new HashMap<String, SinkRunner>();

    public String toString() {
        return "{ sourceRunners:" + this.sourceRunners + " sinkRunners:" + this.sinkRunners + " channels:" + this.channels + " }";
    }

    @Override
    public void addSourceRunner(String name, SourceRunner sourceRunner) {
        this.sourceRunners.put(name, sourceRunner);
    }

    @Override
    public void addSinkRunner(String name, SinkRunner sinkRunner) {
        this.sinkRunners.put(name, sinkRunner);
    }

    @Override
    public void addChannel(String name, Channel channel) {
        this.channels.put(name, channel);
    }

    @Override
    public Map<String, Channel> getChannels() {
        return ImmutableMap.copyOf(this.channels);
    }

    @Override
    public Map<String, SourceRunner> getSourceRunners() {
        return ImmutableMap.copyOf(this.sourceRunners);
    }

    @Override
    public Map<String, SinkRunner> getSinkRunners() {
        return ImmutableMap.copyOf(this.sinkRunners);
    }
}

