package jsp;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.security.cert.Certificate;
import org.apache.geronimo.ca.helper.util.CAHelperUtils;
import org.apache.geronimo.util.CaUtils;
import org.apache.geronimo.util.CertificateUtil;
import org.apache.geronimo.management.geronimo.*;
import java.math.BigInteger;

public final class installPersonalCertificate_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.InstanceManager _jsp_instancemanager;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_instancemanager = org.apache.jasper.runtime.InstanceManagerFactory.getInstanceManager(getServletConfig());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html; charset=ISO-8859-1");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


    String csrId = request.getParameter("csrId");
    CertificateRequestStore certReqStore = CAHelperUtils.getCertificateRequestStore();
    BigInteger sNo = certReqStore.getSerialNumberForRequest(csrId);
    String base64Cert = null;
    String fpSHA1 = null;
    String fpMD5 = null;
    if(sNo != null) {
        CertificateStore certStore = CAHelperUtils.getCertificateStore();
        Certificate cert = certStore.getCertificate(sNo);
        request.setAttribute("cert", cert);
        base64Cert = CaUtils.base64Certificate(cert);
        fpSHA1 = CertificateUtil.generateFingerprint(cert, "SHA1");
        fpMD5 = CertificateUtil.generateFingerprint(cert, "MD5");
    }

      out.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">\n<title>Install Personal Certificate</title>\n</head>\n<body>\n<h2>Install Personal Certificate</h2>\n<p>This page enables you to download and install a personal certificate into your web browser.</p>\n\n");
if(sNo == null) {
      out.write("\nERROR: Either the CSR is yet to be fulfilled or the csrId ");
      out.print(csrId);
      out.write(" is invalid.\n");
} else {
      out.write("<SCRIPT LANGUAGE=\"VBScript\">\n<!--\nSub Install_Onclick\n    certificate = document.installForm.cert.value\n    On Error Resume Next\n    Dim Enroll\n\n    Set Enroll = CreateObject(\"CEnroll.CEnroll.2\")\n    if ( (Err.Number = 438) OR (Err.Number = 429) ) Then\n        Err.Clear\n        Set Enroll = CreateObject(\"CEnroll.CEnroll.1\")\n    End If\n    if Err.Number <> 0 then\n        MsgBox(\"Error in creating CEnroll object.  error:\" & Hex(err))\n    Else\n        Call Enroll.acceptPKCS7(certificate)\n        If err.Number <> 0 then\n            MsgBox(\"Certificate installation failed.  error: \"& Hex(err))\n        Else\n            MsgBox(\"Certificate installed sucessfully\")\n        End if\n    End If\nEnd sub\n-->\n</SCRIPT>\n\nTo install your certificate into Internet Explorer, click on the <i>Install Certificate</i> button below.\nFor other web browsers, click on <a href=\"DownloadCertificateServlet?csrId=");
      out.print(csrId);
      out.write("\">this link</a>.\n<form>\n    <input type=\"button\" value=\"Install Certificate\" onClick=\"Install_Onclick()\"/>\n</form>\n\n<br><b>Base64 encoded Certificate Text</b>\n<br>\n<form name=\"installForm\">\n    <textarea name=\"cert\" rows=\"10\" cols=\"80\" READONLY>");
      out.print(base64Cert);
      out.write("</textarea>\n</form>\n\n    <table border=\"0\">\n        <tr>\n            <th colspan=\"2\" align=\"left\">Certificate Details</th>\n        </tr>\n        <tr>\n            <th align=\"right\">Finger Prints</th>\n            <td>SHA1 &nbsp; ");
      out.print(fpSHA1);
      out.write("<br>MD5 &nbsp; ");
      out.print(fpMD5);
      out.write("</td>\n        </tr>\n        <tr>\n            <th align=\"right\">Version:</th>\n            <td>");
      out.write((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${cert.version}", java.lang.String.class, (PageContext)_jspx_page_context, null, false));
      out.write("</td>\n        </tr>\n        <tr>\n            <th align=\"right\">Subject:</th>\n            <td>");
      out.write((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${cert.subjectDN.name}", java.lang.String.class, (PageContext)_jspx_page_context, null, false));
      out.write("</td>\n        </tr>\n        <tr>\n            <th align=\"right\">Issuer:</th>\n            <td>");
      out.write((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${cert.issuerDN.name}", java.lang.String.class, (PageContext)_jspx_page_context, null, false));
      out.write("</td>\n        </tr>\n        <tr>\n            <th align=\"right\">Serial Number:</th>\n            <td>");
      out.write((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${cert.serialNumber}", java.lang.String.class, (PageContext)_jspx_page_context, null, false));
      out.write("</td>\n        </tr>\n        <tr>\n            <th align=\"right\">Valid From:</th>\n            <td>");
      out.write((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${cert.notBefore}", java.lang.String.class, (PageContext)_jspx_page_context, null, false));
      out.write("</td>\n        </tr>\n        <tr>\n            <th align=\"right\">Valid To:</th>\n            <td>");
      out.write((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${cert.notAfter}", java.lang.String.class, (PageContext)_jspx_page_context, null, false));
      out.write("</td>\n        </tr>\n        <tr>\n            <th align=\"right\">Signature Alg:</th>\n            <td>");
      out.write((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${cert.sigAlgName}", java.lang.String.class, (PageContext)_jspx_page_context, null, false));
      out.write("</td>\n        </tr>\n        <tr>\n            <th align=\"right\">Public Key Alg:</th>\n            <td>");
      out.write((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${cert.publicKey.algorithm}", java.lang.String.class, (PageContext)_jspx_page_context, null, false));
      out.write("</td>\n        </tr>\n        <tr>\n            <th align=\"right\" valign=\"top\">cert.toString()</th>\n            <td><pre>");
      out.write((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${cert}", java.lang.String.class, (PageContext)_jspx_page_context, null, false));
      out.write("</pre></td>\n        </tr>\n    </table>\n");
}
      out.write("<br><a href=\"");
      out.print(request.getContextPath());
      out.write("\">Back to CA Helper home</a>\n\n</body>\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
