/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint.namespace;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.geronimo.blueprint.ComponentDefinitionRegistry;
import org.apache.geronimo.blueprint.ComponentNameAlreadyInUseException;
import org.apache.geronimo.blueprint.reflect.EnvironmentMetadataImpl;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDefinitionRegistryImpl
implements ComponentDefinitionRegistry {
    private final Map<String, ComponentMetadata> components = Collections.synchronizedMap(new LinkedHashMap());
    private final List<Target> typeConverters = new CopyOnWriteArrayList<Target>();

    @Override
    public boolean containsComponentDefinition(String name) {
        return this.components.containsKey(name);
    }

    @Override
    public ComponentMetadata getComponentDefinition(String name) {
        return this.components.get(name);
    }

    @Override
    public Set<String> getComponentDefinitionNames() {
        return Collections.unmodifiableSet(this.components.keySet());
    }

    @Override
    public void registerComponentDefinition(ComponentMetadata component) {
        String id = component.getId();
        if (id == null) {
            throw new IllegalArgumentException("Component must have a valid id");
        }
        if (!id.startsWith("blueprint") || !(component instanceof EnvironmentMetadataImpl)) {
            // empty if block
        }
        if (this.components.containsKey(id)) {
            throw new ComponentNameAlreadyInUseException(id);
        }
        this.components.put(id, component);
    }

    @Override
    public void removeComponentDefinition(String name) {
        this.components.remove(name);
    }

    @Override
    public void registerTypeConverter(Target component) {
        this.typeConverters.add(component);
        if (component instanceof ComponentMetadata) {
            this.registerComponentDefinition((ComponentMetadata)((Object)component));
        }
    }

    @Override
    public List<Target> getTypeConverters() {
        return this.typeConverters;
    }
}

