/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.geronimo.blueprint.mutable.MutableServiceMetadata;
import org.apache.geronimo.blueprint.reflect.ComponentMetadataImpl;
import org.apache.geronimo.blueprint.reflect.MapEntryImpl;
import org.apache.geronimo.blueprint.reflect.MetadataUtil;
import org.apache.geronimo.blueprint.reflect.RegistrationListenerImpl;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMetadataImpl
extends ComponentMetadataImpl
implements MutableServiceMetadata {
    private Target serviceComponent;
    private List<String> interfaceNames;
    private int autoExport;
    private List<MapEntry> serviceProperties;
    private int ranking;
    private Collection<RegistrationListener> registrationListeners;

    public ServiceMetadataImpl() {
    }

    public ServiceMetadataImpl(ServiceMetadata source) {
        super(source);
        this.serviceComponent = MetadataUtil.cloneTarget(source.getServiceComponent());
        this.interfaceNames = new ArrayList<String>(source.getInterfaces());
        this.autoExport = source.getAutoExport();
        for (MapEntry serviceProperty : source.getServiceProperties()) {
            this.addServiceProperty(new MapEntryImpl(serviceProperty));
        }
        this.ranking = source.getRanking();
        for (RegistrationListener listener : source.getRegistrationListeners()) {
            this.addRegistrationListener(new RegistrationListenerImpl(listener));
        }
    }

    @Override
    public Target getServiceComponent() {
        return this.serviceComponent;
    }

    @Override
    public void setServiceComponent(Target exportedComponent) {
        this.serviceComponent = exportedComponent;
    }

    @Override
    public List<String> getInterfaces() {
        if (this.interfaceNames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.interfaceNames);
    }

    public void setInterfaceNames(List<String> interfaceNames) {
        this.interfaceNames = interfaceNames != null ? new ArrayList<String>(interfaceNames) : null;
    }

    @Override
    public void addInterface(String interfaceName) {
        if (this.interfaceNames == null) {
            this.interfaceNames = new ArrayList<String>();
        }
        this.interfaceNames.add(interfaceName);
    }

    @Override
    public void removeInterface(String interfaceName) {
        if (this.interfaceNames != null) {
            this.interfaceNames.remove(interfaceName);
        }
    }

    @Override
    public int getAutoExport() {
        return this.autoExport;
    }

    @Override
    public void setAutoExport(int autoExport) {
        this.autoExport = autoExport;
    }

    @Override
    public List<MapEntry> getServiceProperties() {
        if (this.serviceProperties == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.serviceProperties);
    }

    public void setServiceProperties(List<MapEntry> serviceProperties) {
        this.serviceProperties = serviceProperties != null ? new ArrayList<MapEntry>(serviceProperties) : null;
    }

    @Override
    public void addServiceProperty(MapEntry serviceProperty) {
        if (this.serviceProperties == null) {
            this.serviceProperties = new ArrayList<MapEntry>();
        }
        this.serviceProperties.add(serviceProperty);
    }

    @Override
    public MapEntry addServiceProperty(NonNullMetadata key, Metadata value) {
        MapEntryImpl serviceProperty = new MapEntryImpl(key, value);
        this.addServiceProperty(serviceProperty);
        return serviceProperty;
    }

    @Override
    public void removeServiceProperty(MapEntry serviceProperty) {
        if (this.serviceProperties != null) {
            this.serviceProperties.remove(serviceProperty);
        }
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public void setRanking(int ranking) {
        this.ranking = ranking;
    }

    @Override
    public Collection<RegistrationListener> getRegistrationListeners() {
        if (this.registrationListeners == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this.registrationListeners);
    }

    public void setRegistrationListeners(Collection<RegistrationListener> registrationListeners) {
        this.registrationListeners = registrationListeners;
    }

    @Override
    public void addRegistrationListener(RegistrationListener registrationListenerMetadata) {
        if (this.registrationListeners == null) {
            this.registrationListeners = new ArrayList<RegistrationListener>();
        }
        this.registrationListeners.add(registrationListenerMetadata);
    }

    @Override
    public RegistrationListener addRegistrationListener(Target listenerComponent, String registrationMethodName, String unregistrationMethodName) {
        RegistrationListenerImpl listener = new RegistrationListenerImpl(listenerComponent, registrationMethodName, unregistrationMethodName);
        this.addRegistrationListener(listener);
        return listener;
    }

    @Override
    public void removeRegistrationListener(RegistrationListener listener) {
        if (this.registrationListeners != null) {
            this.registrationListeners.remove(listener);
        }
    }

    public String toString() {
        return "ServiceMetadata[id='" + this.id + '\'' + ", activation=" + this.activation + ", dependsOn=" + this.dependsOn + ", exportedComponent=" + this.serviceComponent + ", interfaces=" + this.interfaceNames + ", autoExportMode=" + this.autoExport + ", serviceProperties=" + this.serviceProperties + ", ranking=" + this.ranking + ", registrationListeners=" + this.registrationListeners + ']';
    }
}

