/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.converters;

import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import javax.annotation.Priority;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=1)
@Vetoed
public class LocalTimeConverter
implements Converter<LocalTime> {
    public static final LocalTimeConverter INSTANCE = new LocalTimeConverter();

    public LocalTime convert(String value) {
        if (value != null) {
            try {
                return LocalTime.parse(value);
            }
            catch (DateTimeParseException dtpe) {
                throw new IllegalArgumentException(dtpe);
            }
        }
        return null;
    }
}

