/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.cdi;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.inject.Provider;
import org.apache.geronimo.config.DefaultConfigProvider;
import org.apache.geronimo.config.cdi.ConfigInjectionBean;
import org.apache.geronimo.config.cdi.ProxyBean;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigExtension
implements Extension {
    private Config config;
    private static final Predicate<InjectionPoint> NOT_PROVIDERS = ip -> ip.getType() instanceof Class || ip.getType() instanceof ParameterizedType && ((ParameterizedType)ip.getType()).getRawType() != Provider.class;
    private static final Map<Type, Type> REPLACED_TYPES = new HashMap<Type, Type>();
    private Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();
    private Set<Class<?>> proxies = new HashSet();
    private List<Class<?>> validProxies;
    private List<ProxyBean<?>> proxyBeans;
    private boolean foundConfig;

    public void findProxies(@Observes ProcessAnnotatedType<?> pat) {
        Class javaClass = pat.getAnnotatedType().getJavaClass();
        if (javaClass.isInterface() && Stream.of(javaClass.getMethods()).anyMatch(m -> m.isAnnotationPresent(ConfigProperty.class))) {
            this.proxies.add(javaClass);
        }
    }

    public void collectConfigProducer(@Observes ProcessInjectionPoint<?, ?> pip) {
        ConfigProperty configProperty = (ConfigProperty)pip.getInjectionPoint().getAnnotated().getAnnotation(ConfigProperty.class);
        if (configProperty != null) {
            this.injectionPoints.add(pip.getInjectionPoint());
        }
    }

    void onConfig(@Observes ProcessAnnotatedType<Config> configProcessBean) {
        this.foundConfig = true;
    }

    public void registerConfigProducer(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        Set types = this.injectionPoints.stream().filter(NOT_PROVIDERS).map(ip -> REPLACED_TYPES.getOrDefault(ip.getType(), ip.getType())).collect(Collectors.toSet());
        Set providerTypes = this.injectionPoints.stream().filter(NOT_PROVIDERS.negate()).map(ip -> ((ParameterizedType)ip.getType()).getActualTypeArguments()[0]).collect(Collectors.toSet());
        types.addAll(providerTypes);
        types.stream().map(type -> new ConfigInjectionBean(bm, (Type)type)).forEach(arg_0 -> ((AfterBeanDiscovery)abd).addBean(arg_0));
        this.validProxies = this.proxies.stream().filter(this::isValidProxy).collect(Collectors.toList());
        if (this.validProxies.size() == this.proxies.size()) {
            this.proxyBeans = this.validProxies.stream().map(ProxyBean::new).collect(Collectors.toList());
            this.proxyBeans.forEach(arg_0 -> ((AfterBeanDiscovery)abd).addBean(arg_0));
        }
        if (!this.foundConfig) {
            abd.addBean(new ConfigInjectionBean(bm, (Type)((Object)Config.class)));
        }
    }

    public void validate(@Observes AfterDeploymentValidation add) {
        ArrayList<String> deploymentProblems = new ArrayList<String>();
        this.config = ConfigProvider.getConfig();
        this.proxyBeans.forEach(b -> b.init(this.config));
        this.proxyBeans.clear();
        for (InjectionPoint injectionPoint : this.injectionPoints) {
            Type type = injectionPoint.getType();
            type = REPLACED_TYPES.getOrDefault(type, type);
            ConfigProperty configProperty = (ConfigProperty)injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
            if (!(type instanceof Class)) continue;
            String key = ConfigInjectionBean.getConfigKey(injectionPoint, configProperty);
            if (!ConfigExtension.isDefaultUnset(configProperty.defaultValue()) || this.config.getOptionalValue(key, (Class)type).isPresent()) continue;
            deploymentProblems.add("No Config Value exists for " + key);
        }
        if (!deploymentProblems.isEmpty()) {
            add.addDeploymentProblem((Throwable)new DeploymentException("Error while validating Configuration\n" + String.join((CharSequence)"\n", deploymentProblems)));
        }
        if (this.validProxies.size() != this.proxies.size()) {
            this.proxies.stream().filter(p -> !this.validProxies.contains(p)).forEach(p -> add.addDeploymentProblem((Throwable)new DeploymentException("Invalid proxy: " + p + ". All method should have @ConfigProperty.")));
        }
        this.proxies.clear();
    }

    public void shutdown(@Observes BeforeShutdown bsd) {
        DefaultConfigProvider.instance().releaseConfig(this.config);
    }

    private boolean isValidProxy(Class<?> api) {
        return Stream.of(api.getMethods()).allMatch(m -> m.isAnnotationPresent(ConfigProperty.class) || Object.class == m.getDeclaringClass());
    }

    static boolean isDefaultUnset(String defaultValue) {
        return defaultValue.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue");
    }

    static {
        REPLACED_TYPES.put(Double.TYPE, (Type)((Object)Double.class));
        REPLACED_TYPES.put(Integer.TYPE, (Type)((Object)Integer.class));
        REPLACED_TYPES.put(Float.TYPE, (Type)((Object)Float.class));
        REPLACED_TYPES.put(Long.TYPE, (Type)((Object)Long.class));
        REPLACED_TYPES.put(Boolean.TYPE, (Type)((Object)Boolean.class));
    }
}

