/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.samples.daytrader.ejb3;

import java.util.Date;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.geronimo.samples.daytrader.util.Log;
import org.apache.geronimo.samples.daytrader.util.MDBStats;
import org.apache.geronimo.samples.daytrader.util.TimerStat;

@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="TradeStreamerTopic"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="NonDurable")})
public class DTStreamer3MDB
implements MessageListener {
    private MDBStats mdbStats;
    private int statInterval = 100;
    @Resource
    public MessageDrivenContext mdc;

    public DTStreamer3MDB() {
        if (Log.doTrace()) {
            Log.trace((String)"DTStreamer3MDB:DTStreamer3MDB()");
        }
        if (this.statInterval <= 0) {
            this.statInterval = 100;
        }
        this.mdbStats = MDBStats.getInstance();
    }

    public void onMessage(Message message) {
        try {
            String command;
            if (Log.doTrace()) {
                Log.trace((String)("DTStreamer3MDB:onMessage -- received message -->" + ((TextMessage)message).getText() + "command-->" + message.getStringProperty("command") + "<--"));
            }
            if ((command = message.getStringProperty("command")) == null) {
                Log.debug((String)("DTStreamer3MDB:onMessage -- received message with null command. Message-->" + message));
                return;
            }
            if (command.equalsIgnoreCase("updateQuote")) {
                long receiveTime;
                long publishTime;
                TimerStat currentStats;
                if (Log.doTrace()) {
                    Log.trace((String)("DTStreamer3MDB:onMessage -- received message -->" + ((TextMessage)message).getText() + "\n\t symbol = " + message.getStringProperty("symbol") + "\n\t current price =" + message.getStringProperty("price") + "\n\t old price =" + message.getStringProperty("oldPrice")));
                }
                if ((currentStats = this.mdbStats.addTiming("DTStreamer3MDB:udpateQuote", publishTime = message.getLongProperty("publishTime"), receiveTime = System.currentTimeMillis())).getCount() % this.statInterval == 0) {
                    Log.log((String)(new Date() + "\nDTStreamer3MDB: 100 Trade stock prices updated:  " + "\nCurrent Statistics\n\tTotal update Quote Price message count = " + currentStats.getCount() + "\n\tTime to receive stock update alerts messages (in seconds):" + "\n\t\tmin: " + currentStats.getMinSecs() + "\n\t\tmax: " + currentStats.getMaxSecs() + "\n\t\tavg: " + currentStats.getAvgSecs() + "\n\n\n\tThe current price update is:\n\t" + ((TextMessage)message).getText()));
                }
            } else if (command.equalsIgnoreCase("ping")) {
                long receiveTime;
                long publishTime;
                TimerStat currentStats;
                if (Log.doTrace()) {
                    Log.trace((String)("DTStreamer3MDB:onMessage  received ping command -- message: " + ((TextMessage)message).getText()));
                }
                if ((currentStats = this.mdbStats.addTiming("DTStreamer3MDB:ping", publishTime = message.getLongProperty("publishTime"), receiveTime = System.currentTimeMillis())).getCount() % this.statInterval == 0) {
                    Log.log((String)(new Date() + "\nDTStreamer3MDB: received 100 ping messages. " + "\nCurrent Ping Message Statistics\n\tTotal ping message count = " + currentStats.getCount() + "\n\tTime to receive messages (in seconds):" + "\n\t\tmin: " + currentStats.getMinSecs() + "\n\t\tmax: " + currentStats.getMaxSecs() + "\n\t\tavg: " + currentStats.getAvgSecs() + "\n\n\n\tThe current message is:\n\t" + ((TextMessage)message).getText()));
                }
            } else {
                Log.error((String)("DTStreamer3MDB:onMessage - unknown message request command-->" + command + "<-- message=" + ((TextMessage)message).getText()));
            }
        }
        catch (Throwable t) {
            Log.error((String)"DTStreamer3MDB: Exception", (Throwable)t);
        }
    }
}

