/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.samples.daytrader.ejb3;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.transaction.RollbackException;
import org.apache.geronimo.samples.daytrader.beans.AccountDataBean;
import org.apache.geronimo.samples.daytrader.beans.AccountProfileDataBean;
import org.apache.geronimo.samples.daytrader.beans.HoldingDataBean;
import org.apache.geronimo.samples.daytrader.beans.OrderDataBean;
import org.apache.geronimo.samples.daytrader.beans.QuoteDataBean;
import org.apache.geronimo.samples.daytrader.core.FinancialUtils;
import org.apache.geronimo.samples.daytrader.core.MarketSummaryDataBean;
import org.apache.geronimo.samples.daytrader.core.RunStatsDataBean;
import org.apache.geronimo.samples.daytrader.core.direct.TradeJEEDirect;
import org.apache.geronimo.samples.daytrader.ejb3.TradeSLSBLocal;
import org.apache.geronimo.samples.daytrader.ejb3.TradeSLSBRemote;
import org.apache.geronimo.samples.daytrader.util.Log;
import org.apache.geronimo.samples.daytrader.util.TradeConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class TradeSLSBBean
implements TradeSLSBRemote,
TradeSLSBLocal {
    @Resource(name="jms/QueueConnectionFactory")
    private QueueConnectionFactory queueConnectionFactory;
    @Resource(name="jms/TopicConnectionFactory")
    private TopicConnectionFactory topicConnectionFactory;
    @Resource(name="jms/TradeStreamerTopic")
    private Topic tradeStreamerTopic;
    @Resource(name="jms/TradeBrokerQueue")
    private Queue tradeBrokerQueue;
    @PersistenceContext
    private EntityManager entityManager;

    public TradeSLSBBean() {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:ejbCreate  -- JNDI lookups of EJB and JMS resources");
        }
    }

    public MarketSummaryDataBean getMarketSummary() {
        MarketSummaryDataBean marketSummaryData;
        try {
            if (Log.doTrace()) {
                Log.trace((String)"TradeSLSBBean:getMarketSummary -- getting market summary");
            }
            Query query = this.entityManager.createNamedQuery("quoteejb.quotesByChange");
            List quotes = query.getResultList();
            QuoteDataBean[] quoteArray = quotes.toArray(new QuoteDataBean[quotes.size()]);
            ArrayList<QuoteDataBean> topGainers = new ArrayList<QuoteDataBean>(5);
            ArrayList<QuoteDataBean> topLosers = new ArrayList<QuoteDataBean>(5);
            BigDecimal TSIA = FinancialUtils.ZERO;
            BigDecimal openTSIA = FinancialUtils.ZERO;
            double totalVolume = 0.0;
            if (quoteArray.length > 5) {
                int i;
                for (i = 0; i < 5; ++i) {
                    topGainers.add(quoteArray[i]);
                }
                for (i = quoteArray.length - 1; i >= quoteArray.length - 5; --i) {
                    topLosers.add(quoteArray[i]);
                }
                for (QuoteDataBean quote : quoteArray) {
                    BigDecimal price = quote.getPrice();
                    BigDecimal open = quote.getOpen();
                    double volume = quote.getVolume();
                    TSIA = TSIA.add(price);
                    openTSIA = openTSIA.add(open);
                    totalVolume += volume;
                }
                TSIA = TSIA.divide(new BigDecimal(quoteArray.length), 4);
                openTSIA = openTSIA.divide(new BigDecimal(quoteArray.length), 4);
            }
            marketSummaryData = new MarketSummaryDataBean(TSIA, openTSIA, totalVolume, topGainers, topLosers);
        }
        catch (Exception e) {
            Log.error((String)"TradeSLSBBean:getMarketSummary", (Throwable)e);
            throw new EJBException("TradeSLSBBean:getMarketSummary -- error ", e);
        }
        return marketSummaryData;
    }

    public OrderDataBean buy(String userID, String symbol, double quantity, int orderProcessingMode) {
        OrderDataBean order;
        try {
            if (Log.doTrace()) {
                Log.trace((String)"TradeSLSBBean:buy", (Object)userID, (Object)symbol, (Object)quantity, (Object)orderProcessingMode);
            }
            AccountProfileDataBean profile = (AccountProfileDataBean)this.entityManager.find(AccountProfileDataBean.class, (Object)userID);
            AccountDataBean account = profile.getAccount();
            QuoteDataBean quote = (QuoteDataBean)this.entityManager.find(QuoteDataBean.class, (Object)symbol);
            HoldingDataBean holding = null;
            order = this.createOrder(account, quote, holding, "buy", quantity);
            BigDecimal price = quote.getPrice();
            BigDecimal orderFee = order.getOrderFee();
            BigDecimal balance = account.getBalance();
            BigDecimal total = new BigDecimal(quantity).multiply(price).add(orderFee);
            account.setBalance(balance.subtract(total));
            if (orderProcessingMode == 0) {
                this.completeOrder(order.getOrderID(), false);
            } else if (orderProcessingMode == 1) {
                this.queueOrder(order.getOrderID(), true);
            }
        }
        catch (Exception e) {
            Log.error((String)("TradeSLSBBean:buy(" + userID + "," + symbol + "," + quantity + ") --> failed"), (Throwable)e);
            throw new EJBException(e);
        }
        return order;
    }

    public OrderDataBean sell(String userID, Integer holdingID, int orderProcessingMode) {
        OrderDataBean order;
        try {
            if (Log.doTrace()) {
                Log.trace((String)"TradeSLSBBean:sell", (Object)userID, (Object)holdingID, (Object)orderProcessingMode);
            }
            AccountProfileDataBean profile = (AccountProfileDataBean)this.entityManager.find(AccountProfileDataBean.class, (Object)userID);
            AccountDataBean account = profile.getAccount();
            HoldingDataBean holding = (HoldingDataBean)this.entityManager.find(HoldingDataBean.class, (Object)holdingID);
            if (holding == null) {
                Log.error((String)("TradeSLSBBean:sell User " + userID + " attempted to sell holding " + holdingID + " which has already been sold"));
                OrderDataBean orderData = new OrderDataBean();
                orderData.setOrderStatus("cancelled");
                this.entityManager.persist((Object)orderData);
                return orderData;
            }
            QuoteDataBean quote = holding.getQuote();
            double quantity = holding.getQuantity();
            order = this.createOrder(account, quote, holding, "sell", quantity);
            holding.setPurchaseDate((Date)new Timestamp(0L));
            BigDecimal price = quote.getPrice();
            BigDecimal orderFee = order.getOrderFee();
            BigDecimal balance = account.getBalance();
            BigDecimal total = new BigDecimal(quantity).multiply(price).subtract(orderFee);
            account.setBalance(balance.add(total));
            if (orderProcessingMode == 0) {
                this.completeOrder(order.getOrderID(), false);
            } else if (orderProcessingMode == 1) {
                this.queueOrder(order.getOrderID(), true);
            }
        }
        catch (Exception e) {
            Log.error((String)("TradeSLSBBean:sell(" + userID + "," + holdingID + ") --> failed"), (Throwable)e);
            throw new EJBException("TradeSLSBBean:sell(" + userID + "," + holdingID + ")", e);
        }
        return order;
    }

    public void queueOrder(Integer orderID, boolean twoPhase) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:queueOrder", (Object)orderID);
        }
        Connection conn = null;
        Session sess = null;
        try {
            conn = this.queueConnectionFactory.createConnection();
            sess = conn.createSession(false, 1);
            MessageProducer msgProducer = sess.createProducer((Destination)this.tradeBrokerQueue);
            TextMessage message = sess.createTextMessage();
            message.setStringProperty("command", "neworder");
            message.setIntProperty("orderID", orderID.intValue());
            message.setBooleanProperty("twoPhase", twoPhase);
            message.setText("neworder: orderID=" + orderID + " runtimeMode=EJB twoPhase=" + twoPhase);
            message.setLongProperty("publishTime", System.currentTimeMillis());
            if (Log.doTrace()) {
                Log.trace((String)("TradeSLSBBean:queueOrder Sending message: " + message.getText()));
            }
            msgProducer.send((Message)message);
        }
        catch (JMSException e) {
            throw new EJBException(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (sess != null) {
                    sess.close();
                }
            }
            catch (JMSException e) {
                throw new EJBException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    public OrderDataBean completeOrder(Integer orderID, boolean twoPhase) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:completeOrder", (Object)(orderID + " twoPhase=" + twoPhase));
        }
        OrderDataBean order = (OrderDataBean)this.entityManager.find(OrderDataBean.class, (Object)orderID);
        order.getQuote();
        if (order == null) {
            Log.error((String)("TradeSLSBBean:completeOrder -- Unable to find Order " + orderID + " FBPK returned " + order));
            return null;
        }
        if (order.isCompleted()) {
            throw new EJBException("Error: attempt to complete Order that is already completed\n" + order);
        }
        AccountDataBean account = order.getAccount();
        QuoteDataBean quote = order.getQuote();
        HoldingDataBean holding = order.getHolding();
        BigDecimal price = order.getPrice();
        double quantity = order.getQuantity();
        String userID = account.getProfile().getUserID();
        if (Log.doTrace()) {
            Log.trace((String)("TradeSLSBBeanInternal:completeOrder--> Completing Order " + order.getOrderID() + "\n\t Order info: " + order + "\n\t Account info: " + account + "\n\t Quote info: " + quote + "\n\t Holding info: " + holding));
        }
        if (order.isBuy()) {
            HoldingDataBean newHolding = this.createHolding(account, quote, quantity, price);
            order.setHolding(newHolding);
        }
        if (order.isSell()) {
            if (holding == null) {
                Log.error((String)("TradeSLSBBean:completeOrder -- Unable to sell order " + order.getOrderID() + " holding already sold"));
                order.cancel();
                return order;
            }
            this.entityManager.remove((Object)holding);
            order.setHolding(null);
        }
        order.setOrderStatus("closed");
        order.setCompletionDate((Date)new Timestamp(System.currentTimeMillis()));
        if (Log.doTrace()) {
            Log.trace((String)("TradeSLSBBean:completeOrder--> Completed Order " + order.getOrderID() + "\n\t Order info: " + order + "\n\t Account info: " + account + "\n\t Quote info: " + quote + "\n\t Holding info: " + holding));
        }
        return order;
    }

    public void cancelOrder(Integer orderID, boolean twoPhase) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:cancelOrder", (Object)(orderID + " twoPhase=" + twoPhase));
        }
        OrderDataBean order = (OrderDataBean)this.entityManager.find(OrderDataBean.class, (Object)orderID);
        order.cancel();
    }

    public void orderCompleted(String userID, Integer orderID) {
        throw new UnsupportedOperationException("TradeSLSBBean:orderCompleted method not supported");
    }

    public Collection<OrderDataBean> getOrders(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:getOrders", (Object)userID);
        }
        AccountProfileDataBean profile = (AccountProfileDataBean)this.entityManager.find(AccountProfileDataBean.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        return account.getOrders();
    }

    public Collection<OrderDataBean> getClosedOrders(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:getClosedOrders", (Object)userID);
        }
        try {
            Query query = this.entityManager.createNamedQuery("orderejb.closedOrders");
            query.setParameter("userID", (Object)userID);
            List results = query.getResultList();
            for (OrderDataBean thisOrder : results) {
                thisOrder.getQuote();
            }
            if (TradeConfig.jpaLayer == 0) {
                Query updateStatus = this.entityManager.createNamedQuery("orderejb.completeClosedOrders");
                updateStatus.setParameter("userID", (Object)userID);
                updateStatus.executeUpdate();
            }
            if (TradeConfig.jpaLayer == 1) {
                Query findaccountid = this.entityManager.createNativeQuery("select a.ACCOUNTID, a.LOGINCOUNT, a.LOGOUTCOUNT, a.LASTLOGIN, a.CREATIONDATE, a.BALANCE, a.OPENBALANCE, a.PROFILE_USERID from accountejb a where a.profile_userid = ?", AccountDataBean.class);
                findaccountid.setParameter(1, (Object)userID);
                AccountDataBean account = (AccountDataBean)findaccountid.getSingleResult();
                Integer accountid = account.getAccountID();
                Query updateStatus = this.entityManager.createNativeQuery("UPDATE orderejb o SET o.orderStatus = 'completed' WHERE o.orderStatus = 'closed' AND o.ACCOUNT_ACCOUNTID  = ?");
                updateStatus.setParameter(1, (Object)accountid);
                updateStatus.executeUpdate();
            }
            return results;
        }
        catch (Exception e) {
            Log.error((String)"TradeSLSBBean.getClosedOrders", (Throwable)e);
            throw new EJBException("TradeSLSBBean.getClosedOrders - error", e);
        }
    }

    public QuoteDataBean createQuote(String symbol, String companyName, BigDecimal price) {
        try {
            QuoteDataBean quote = new QuoteDataBean(symbol, companyName, 0.0, price, price, price, price, 0.0);
            this.entityManager.persist((Object)quote);
            if (Log.doTrace()) {
                Log.trace((String)("TradeSLSBBean:createQuote-->" + quote));
            }
            return quote;
        }
        catch (Exception e) {
            Log.error((String)"TradeSLSBBean:createQuote -- exception creating Quote", (Throwable)e);
            throw new EJBException(e);
        }
    }

    public QuoteDataBean getQuote(String symbol) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:getQuote", (Object)symbol);
        }
        return (QuoteDataBean)this.entityManager.find(QuoteDataBean.class, (Object)symbol);
    }

    public Collection<QuoteDataBean> getAllQuotes() {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:getAllQuotes");
        }
        Query query = this.entityManager.createNamedQuery("quoteejb.allQuotes");
        return query.getResultList();
    }

    public QuoteDataBean updateQuotePriceVolume(String symbol, BigDecimal changeFactor, double sharesTraded) {
        if (!TradeConfig.getUpdateQuotePrices()) {
            return new QuoteDataBean();
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:updateQuote", (Object)symbol, (Object)changeFactor);
        }
        QuoteDataBean quote = new QuoteDataBean();
        if (TradeConfig.jpaLayer == 1) {
            quote = (QuoteDataBean)this.entityManager.find(QuoteDataBean.class, (Object)symbol);
        }
        if (TradeConfig.jpaLayer == 0) {
            Query q = this.entityManager.createNamedQuery("quoteejb.quoteForUpdate");
            q.setParameter(1, (Object)symbol);
            quote = (QuoteDataBean)q.getSingleResult();
        }
        BigDecimal oldPrice = quote.getPrice();
        if (quote.getPrice().equals(TradeConfig.PENNY_STOCK_PRICE)) {
            changeFactor = TradeConfig.PENNY_STOCK_RECOVERY_MIRACLE_MULTIPLIER;
        }
        BigDecimal newPrice = changeFactor.multiply(oldPrice).setScale(2, 4);
        quote.setPrice(newPrice);
        quote.setVolume(quote.getVolume() + sharesTraded);
        this.entityManager.merge((Object)quote);
        this.publishQuotePriceChange(quote, oldPrice, changeFactor, sharesTraded);
        return quote;
    }

    public Collection<HoldingDataBean> getHoldings(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:getHoldings", (Object)userID);
        }
        Query query = this.entityManager.createNamedQuery("holdingejb.holdingsByUserID");
        query.setParameter("userID", (Object)userID);
        List holdings = query.getResultList();
        Iterator itr = holdings.iterator();
        while (itr.hasNext()) {
            ((HoldingDataBean)itr.next()).getQuote();
        }
        return holdings;
    }

    public HoldingDataBean getHolding(Integer holdingID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:getHolding", (Object)holdingID);
        }
        return (HoldingDataBean)this.entityManager.find(HoldingDataBean.class, (Object)holdingID);
    }

    public AccountDataBean getAccountData(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:getAccountData", (Object)userID);
        }
        AccountProfileDataBean profile = (AccountProfileDataBean)this.entityManager.find(AccountProfileDataBean.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        account.getProfile();
        account.setProfileID(profile.getUserID());
        return account;
    }

    public AccountProfileDataBean getAccountProfileData(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:getProfileData", (Object)userID);
        }
        return (AccountProfileDataBean)this.entityManager.find(AccountProfileDataBean.class, (Object)userID);
    }

    public AccountProfileDataBean updateAccountProfile(AccountProfileDataBean profileData) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:updateAccountProfileData", (Object)profileData);
        }
        AccountProfileDataBean temp = (AccountProfileDataBean)this.entityManager.find(AccountProfileDataBean.class, (Object)profileData.getUserID());
        temp.setAddress(profileData.getAddress());
        temp.setPassword(profileData.getPassword());
        temp.setFullName(profileData.getFullName());
        temp.setCreditCard(profileData.getCreditCard());
        temp.setEmail(profileData.getEmail());
        this.entityManager.merge((Object)temp);
        return temp;
    }

    public AccountDataBean login(String userID, String password) throws RollbackException {
        AccountProfileDataBean profile = (AccountProfileDataBean)this.entityManager.find(AccountProfileDataBean.class, (Object)userID);
        if (profile == null) {
            throw new EJBException("No such user: " + userID);
        }
        this.entityManager.merge((Object)profile);
        AccountDataBean account = profile.getAccount();
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:login", (Object)userID, (Object)password);
        }
        account.login(password);
        if (Log.doTrace()) {
            Log.trace((String)("TradeSLSBBean:login(" + userID + "," + password + ") success" + account));
        }
        return account;
    }

    public void logout(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:logout", (Object)userID);
        }
        AccountProfileDataBean profile = (AccountProfileDataBean)this.entityManager.find(AccountProfileDataBean.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        account.logout();
        if (Log.doTrace()) {
            Log.trace((String)("TradeSLSBBean:logout(" + userID + ") success"));
        }
    }

    public AccountDataBean register(String userID, String password, String fullname, String address, String email, String creditcard, BigDecimal openBalance) {
        AccountDataBean account = null;
        AccountProfileDataBean profile = null;
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:register", (Object)userID, (Object)password, (Object)fullname, (Object)address, (Object)email, (Object)creditcard, (Object)openBalance);
        }
        if ((profile = (AccountProfileDataBean)this.entityManager.find(AccountProfileDataBean.class, (Object)userID)) != null) {
            Log.error((String)("Failed to register new Account - AccountProfile with userID(" + userID + ") already exists"));
            return null;
        }
        profile = new AccountProfileDataBean(userID, password, fullname, address, email, creditcard);
        account = new AccountDataBean(0, 0, null, (Date)new Timestamp(System.currentTimeMillis()), openBalance, openBalance, userID);
        profile.setAccount(account);
        account.setProfile(profile);
        this.entityManager.persist((Object)profile);
        this.entityManager.persist((Object)account);
        return account;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public RunStatsDataBean resetTrade(boolean deleteAll) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:resetTrade", (Object)deleteAll);
        }
        return new TradeJEEDirect(false).resetTrade(deleteAll);
    }

    private void publishQuotePriceChange(QuoteDataBean quote, BigDecimal oldPrice, BigDecimal changeFactor, double sharesTraded) {
        if (!TradeConfig.getPublishQuotePriceChange()) {
            return;
        }
        if (Log.doTrace()) {
            Log.trace((String)("TradeSLSBBean:publishQuotePricePublishing -- quoteData = " + quote));
        }
        Connection conn = null;
        Session sess = null;
        try {
            conn = this.topicConnectionFactory.createConnection();
            sess = conn.createSession(false, 1);
            MessageProducer msgProducer = sess.createProducer((Destination)this.tradeStreamerTopic);
            TextMessage message = sess.createTextMessage();
            String command = "updateQuote";
            message.setStringProperty("command", command);
            message.setStringProperty("symbol", quote.getSymbol());
            message.setStringProperty("company", quote.getCompanyName());
            message.setStringProperty("price", quote.getPrice().toString());
            message.setStringProperty("oldPrice", oldPrice.toString());
            message.setStringProperty("open", quote.getOpen().toString());
            message.setStringProperty("low", quote.getLow().toString());
            message.setStringProperty("high", quote.getHigh().toString());
            message.setDoubleProperty("volume", quote.getVolume());
            message.setStringProperty("changeFactor", changeFactor.toString());
            message.setDoubleProperty("sharesTraded", sharesTraded);
            message.setLongProperty("publishTime", System.currentTimeMillis());
            message.setText("Update Stock price for " + quote.getSymbol() + " old price = " + oldPrice + " new price = " + quote.getPrice());
            msgProducer.send((Message)message);
        }
        catch (Exception e) {
            throw new EJBException(e.getMessage(), e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (sess != null) {
                    sess.close();
                }
            }
            catch (JMSException e) {
                throw new EJBException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private OrderDataBean createOrder(AccountDataBean account, QuoteDataBean quote, HoldingDataBean holding, String orderType, double quantity) {
        OrderDataBean order;
        if (Log.doTrace()) {
            Log.trace((String)("TradeSLSBBean:createOrder(orderID= account=" + (account == null ? null : account.getAccountID()) + " quote=" + (quote == null ? null : quote.getSymbol()) + " orderType=" + orderType + " quantity=" + quantity));
        }
        try {
            order = new OrderDataBean(orderType, "open", (Date)new Timestamp(System.currentTimeMillis()), null, quantity, quote.getPrice().setScale(2, 4), TradeConfig.getOrderFee((String)orderType), account, quote, holding);
            this.entityManager.persist((Object)order);
        }
        catch (Exception e) {
            Log.error((String)"TradeSLSBBean:createOrder -- failed to create Order", (Throwable)e);
            throw new EJBException("TradeSLSBBean:createOrder -- failed to create Order", e);
        }
        return order;
    }

    private HoldingDataBean createHolding(AccountDataBean account, QuoteDataBean quote, double quantity, BigDecimal purchasePrice) throws Exception {
        HoldingDataBean newHolding = new HoldingDataBean(quantity, purchasePrice, (Date)new Timestamp(System.currentTimeMillis()), account, quote);
        this.entityManager.persist((Object)newHolding);
        return newHolding;
    }

    @Override
    public double investmentReturn(double investment, double NetValue) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"TradeSLSBBean:investmentReturn");
        }
        double diff = NetValue - investment;
        double ir = diff / investment;
        return ir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuoteDataBean pingTwoPhase(String symbol) throws Exception {
        try {
            if (Log.doTrace()) {
                Log.trace((String)"TradeSLSBBean:pingTwoPhase", (Object)symbol);
            }
            QuoteDataBean quoteData = null;
            Connection conn = null;
            Session sess = null;
            try {
                quoteData = (QuoteDataBean)this.entityManager.find(QuoteDataBean.class, (Object)symbol);
                conn = this.queueConnectionFactory.createConnection();
                sess = conn.createSession(false, 1);
                MessageProducer msgProducer = sess.createProducer((Destination)this.tradeBrokerQueue);
                TextMessage message = sess.createTextMessage();
                String command = "ping";
                message.setStringProperty("command", command);
                message.setLongProperty("publishTime", System.currentTimeMillis());
                message.setText("Ping message for queue java:comp/env/jms/TradeBrokerQueue sent from TradeSLSBBean:pingTwoPhase at " + new Date());
                msgProducer.send((Message)message);
            }
            catch (Exception e) {
                Log.error((String)"TradeSLSBBean:pingTwoPhase -- exception caught", (Throwable)e);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
                if (sess != null) {
                    sess.close();
                }
            }
            return quoteData;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    @PostConstruct
    public void postConstruct() {
        Log.trace((String)"POST CONSTRUCT");
        Log.trace((String)("updateQuotePrices: " + TradeConfig.getUpdateQuotePrices()));
        Log.trace((String)("publishQuotePriceChange: " + TradeConfig.getPublishQuotePriceChange()));
    }

    class quotePriceComparator
    implements Comparator {
        quotePriceComparator() {
        }

        public int compare(Object quote1, Object quote2) {
            double change1 = ((QuoteDataBean)quote1).getChange();
            double change2 = ((QuoteDataBean)quote2).getChange();
            return new Double(change2).compareTo(change1);
        }
    }
}

