/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.extensions.config.docker;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geronimo.microprofile.extensions.config.docker.BaseConfigSource;
import org.apache.geronimo.microprofile.extensions.config.docker.InternalConfig;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class DockerSecretConfigSource
extends BaseConfigSource
implements ConfigSource {
    public DockerSecretConfigSource() {
        this(InternalConfig.get(DockerSecretConfigSource.class.getName() + ".base", "/run/secrets"), Integer.parseInt(InternalConfig.get(DockerSecretConfigSource.class.getName() + ".ordinal", "100")));
    }

    public DockerSecretConfigSource(String base, int ordinal) {
        super(() -> DockerSecretConfigSource.reload(base), ordinal);
    }

    public String getName() {
        return "docker-secrets";
    }

    private static Map<String, String> reload(String base) {
        Path from = Paths.get(base, new String[0]);
        if (!Files.exists(from, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        try {
            return Files.list(from).collect(Collectors.toMap(it -> it.getFileName().toString(), it -> {
                try {
                    return new String(Files.readAllBytes(it), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

