/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group;

import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class ChannelInterceptorBase
implements ChannelInterceptor {
    private static final Log log = LogFactory.getLog(ChannelInterceptorBase.class);
    private ChannelInterceptor next;
    private ChannelInterceptor previous;
    protected int optionFlag = 0;

    public boolean okToProcess(int messageFlags) {
        if (this.optionFlag == 0) {
            return true;
        }
        return (this.optionFlag & messageFlags) == this.optionFlag;
    }

    public final void setNext(ChannelInterceptor next) {
        this.next = next;
    }

    public final ChannelInterceptor getNext() {
        return this.next;
    }

    public final void setPrevious(ChannelInterceptor previous) {
        this.previous = previous;
    }

    public void setOptionFlag(int optionFlag) {
        this.optionFlag = optionFlag;
    }

    public final ChannelInterceptor getPrevious() {
        return this.previous;
    }

    public int getOptionFlag() {
        return this.optionFlag;
    }

    public void sendMessage(Member[] destination, ChannelMessage msg, InterceptorPayload payload) throws ChannelException {
        if (this.getNext() != null) {
            this.getNext().sendMessage(destination, msg, payload);
        }
    }

    public void messageReceived(ChannelMessage msg) {
        if (this.getPrevious() != null) {
            this.getPrevious().messageReceived(msg);
        }
    }

    public boolean accept(ChannelMessage msg) {
        return true;
    }

    public void memberAdded(Member member) {
        if (this.getPrevious() != null) {
            this.getPrevious().memberAdded(member);
        }
    }

    public void memberDisappeared(Member member) {
        if (this.getPrevious() != null) {
            this.getPrevious().memberDisappeared(member);
        }
    }

    public void heartbeat() {
        if (this.getNext() != null) {
            this.getNext().heartbeat();
        }
    }

    public boolean hasMembers() {
        if (this.getNext() != null) {
            return this.getNext().hasMembers();
        }
        return false;
    }

    public Member[] getMembers() {
        if (this.getNext() != null) {
            return this.getNext().getMembers();
        }
        return null;
    }

    public Member getMember(Member mbr) {
        if (this.getNext() != null) {
            return this.getNext().getMember(mbr);
        }
        return null;
    }

    public Member getLocalMember(boolean incAlive) {
        if (this.getNext() != null) {
            return this.getNext().getLocalMember(incAlive);
        }
        return null;
    }

    public void start(int svc) throws ChannelException {
        if (this.getNext() != null) {
            this.getNext().start(svc);
        }
    }

    public void stop(int svc) throws ChannelException {
        if (this.getNext() != null) {
            this.getNext().stop(svc);
        }
    }

    public void fireInterceptorEvent(ChannelInterceptor.InterceptorEvent event) {
    }
}

