/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


package org.apache.geronimo.crypto;

import java.io.Serializable;

/**
 * Interface for objects to register with EncryptionManager.
 *
 * @version $Rev: 617735 $ $Date: 2008-02-02 09:20:02 +0800 (Sat, 02 Feb 2008) $
 */
public interface Encryption {
    /**
     * encrypt the source according to some scheme and return the result as a String.
     * @param source object to encrypt
     * @return encrypted object representing the source.
     */
    String encrypt(Serializable source);

    /**
     * decrypt the source according to some scheme and return the original object.
     * @param source the string representing the encrypted object
     * @return (a copy of) the original object.                                                    
     */
    Serializable decrypt(String source);
}
