/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class KeystoreUtil {
    public static final Set<String> keystoreTypes;
    public static final Set<String> emptyKeystoreTypes;
    public static final Set<String> certKeystoreTypes;
    public static final String defaultType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        HashSet<String> ignoreKeystores = new HashSet<String>();
        ignoreKeystores.add("windows-my");
        ignoreKeystores.add("windows-root");
        TreeSet<String> tempKeystoreTypes = new TreeSet<String>();
        TreeSet<String> tempEmptyKeystoreTypes = new TreeSet<String>();
        TreeSet<String> tempCertKeystoreTypes = new TreeSet<String>();
        String tempDefaultType = null;
        Provider[] providers = Security.getProviders();
        char[] password = "emptypassword".toCharArray();
        String sampleCertText = "-----BEGIN CERTIFICATE-----\nMIIBpzCCAVECBgEV+CystzANBgkqhkiG9w0BAQQFADBcMQswCQYDVQQDEwJNZTEQMA4GA1UECxMH\nTXkgVW5pdDEPMA0GA1UEChMGTXkgT3JnMRAwDgYDVQQHEwdNeSBDaXR5MQswCQYDVQQIEwJBUDEL\nMAkGA1UEBhMCSU4wHhcNMDcxMDMxMjIyNjU4WhcNMTcxMDI4MjIyNjU4WjBcMQswCQYDVQQDEwJN\nZTEQMA4GA1UECxMHTXkgVW5pdDEPMA0GA1UEChMGTXkgT3JnMRAwDgYDVQQHEwdNeSBDaXR5MQsw\nCQYDVQQIEwJBUDELMAkGA1UEBhMCSU4wXDANBgkqhkiG9w0BAQEFAANLADBIAkEAlN7IscUYq5U9\nd1TYVJaj5RQJLg39Gz9R9hB0hhOULSHOxeE0utTJvgBQcf+f39FgbGIdriJniyoubtCXGfSpxwID\nAQABMA0GCSqGSIb3DQEBBAUAA0EACQN6ScbxzAjrrQ3Ciy8I7/qsgpQo4Nuhfo5cAU4rvcKnujs6\nuGHAJrHMF/ROGl6kPZvFeoGXk5qjyKs8Kx5MJA==\n-----END CERTIFICATE-----";
        Certificate sampleCert = null;
        try {
            CertificateFactory certFac = CertificateFactory.getInstance("X.509");
            sampleCert = certFac.generateCertificate(new ByteArrayInputStream(sampleCertText.getBytes()));
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        for (Provider provider : providers) {
            for (Provider.Service service : provider.getServices()) {
                String type = service.getAlgorithm();
                if (!service.getType().equals("KeyStore") || ignoreKeystores.contains(type.toLowerCase())) continue;
                tempKeystoreTypes.add(type);
                if (type.equalsIgnoreCase(KeyStore.getDefaultType())) {
                    tempDefaultType = type;
                }
                ByteArrayOutputStream baos = null;
                KeyStore ks = null;
                try {
                    ks = KeyStore.getInstance(type);
                    ks.load(null);
                    baos = new ByteArrayOutputStream();
                    ks.store(baos, password);
                    tempEmptyKeystoreTypes.add(type);
                }
                catch (Throwable ignored) {
                }
                finally {
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
                try {
                    ks.setCertificateEntry("samplecert", sampleCert);
                    tempCertKeystoreTypes.add(type);
                }
                catch (Throwable ignored) {}
            }
        }
        keystoreTypes = Collections.unmodifiableSortedSet(tempKeystoreTypes);
        emptyKeystoreTypes = Collections.unmodifiableSortedSet(tempEmptyKeystoreTypes);
        certKeystoreTypes = Collections.unmodifiableSortedSet(tempCertKeystoreTypes);
        defaultType = tempDefaultType;
    }
}

