/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.configuration.AttributesXmlUtil;
import org.apache.geronimo.system.configuration.ConfigurationOverride;
import org.apache.geronimo.system.configuration.GBeanOverride;
import org.apache.geronimo.system.configuration.InvalidAttributeException;
import org.apache.geronimo.system.configuration.LocalPluginAttributeStore;
import org.apache.geronimo.system.configuration.ServerOverride;
import org.apache.geronimo.system.configuration.condition.JexlExpressionParser;
import org.apache.geronimo.system.configuration.condition.ParserUtils;
import org.apache.geronimo.system.plugin.model.AttributesType;
import org.apache.geronimo.system.plugin.model.GbeanType;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalAttributeManager
implements LocalPluginAttributeStore,
PersistentConfigurationList,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog(LocalAttributeManager.class);
    private static final String CONFIG_FILE_PROPERTY = "org.apache.geronimo.config.file";
    private static final String SUBSTITUTIONS_FILE_PROPERTY = "org.apache.geronimo.config.substitutions.file";
    private static final String SUBSTITUTION_PREFIX_PREFIX = "org.apache.geronimo.config.substitution.prefix";
    private static final String BACKUP_EXTENSION = ".bak";
    private static final String TEMP_EXTENSION = ".working";
    private static final int SAVE_BUFFER_MS = 5000;
    private final ServerInfo serverInfo;
    private final String configFile;
    private final boolean readOnly;
    private final JexlExpressionParser expressionParser;
    private File attributeFile;
    private File backupFile;
    private File tempFile;
    private ServerOverride serverOverride;
    private Timer timer;
    private TimerTask currentTask;
    private boolean kernelFullyStarted;
    private String prefix;
    private File configSubstitutionsFile;
    private Properties localConfigSubstitutions;
    private String resolvedPropertiesFile;
    public static final GBeanInfo GBEAN_INFO;

    public LocalAttributeManager(String configFile, String configSubstitutionsFileName, String configSubstitutionsPrefix, boolean readOnly, ServerInfo serverInfo) {
        this.configFile = System.getProperty(CONFIG_FILE_PROPERTY, configFile);
        this.resolvedPropertiesFile = System.getProperty(SUBSTITUTIONS_FILE_PROPERTY, configSubstitutionsFileName);
        this.configSubstitutionsFile = this.resolvedPropertiesFile == null ? null : serverInfo.resolveServer(this.resolvedPropertiesFile);
        this.localConfigSubstitutions = LocalAttributeManager.loadConfigSubstitutions(this.configSubstitutionsFile);
        this.prefix = System.getProperty(SUBSTITUTION_PREFIX_PREFIX, configSubstitutionsPrefix);
        Map<String, Object> configSubstitutions = LocalAttributeManager.loadAllConfigSubstitutions(this.localConfigSubstitutions, this.prefix);
        this.expressionParser = new JexlExpressionParser(configSubstitutions);
        this.readOnly = readOnly;
        this.serverInfo = serverInfo;
        this.serverOverride = new ServerOverride();
        log.debug((Object)("setting configSubstitutionsFile to " + this.configSubstitutionsFile + "."));
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public String getConfigFile() {
        return this.configFile;
    }

    @Override
    public String getConfigSubstitutionsFile() {
        return this.resolvedPropertiesFile;
    }

    @Override
    public String getConfigSubstitutionsPrefix() {
        return this.prefix;
    }

    public synchronized Collection applyOverrides(Artifact configName, Collection<GBeanData> untypedGbeanDatas, ClassLoader classLoader) throws InvalidConfigException {
        ArrayList<GBeanData> gbeanDatas = new ArrayList<GBeanData>(untypedGbeanDatas);
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configName);
        if (configuration == null) {
            return gbeanDatas;
        }
        HashMap<Object, GBeanData> datasByName = new HashMap<Object, GBeanData>();
        for (GBeanData gBeanData : gbeanDatas) {
            datasByName.put(gBeanData.getAbstractName(), gBeanData);
            datasByName.put(gBeanData.getAbstractName().getName().get("name"), gBeanData);
        }
        for (Object object : configuration.getGBeans().entrySet()) {
            Map.Entry entry = (Map.Entry)object;
            Object name = entry.getKey();
            GBeanOverride gbean = (GBeanOverride)entry.getValue();
            if (datasByName.containsKey(name) || !gbean.isLoad()) continue;
            if (gbean.getGBeanInfo() == null || !(name instanceof AbstractName)) {
                String sep = "";
                StringBuffer message = new StringBuffer("New GBeans must be specified with ");
                if (gbean.getGBeanInfo() == null) {
                    message.append("a GBeanInfo ");
                    sep = "and ";
                }
                if (!(name instanceof AbstractName)) {
                    message.append(sep).append("a full AbstractName ");
                }
                message.append("configuration=").append(configName);
                message.append(" gbeanName=").append(name);
                throw new InvalidConfigException(message.toString());
            }
            GBeanInfo gbeanInfo = GBeanInfo.getGBeanInfo((String)gbean.getGBeanInfo(), (ClassLoader)classLoader);
            AbstractName abstractName = (AbstractName)name;
            GBeanData gBeanData = new GBeanData(abstractName, gbeanInfo);
            gbeanDatas.add(gBeanData);
        }
        Iterator iterator = gbeanDatas.iterator();
        while (iterator.hasNext()) {
            GBeanData gBeanData = (GBeanData)iterator.next();
            boolean load = this.setAttributes(gBeanData, configuration, configName, classLoader);
            if (load) continue;
            iterator.remove();
        }
        return gbeanDatas;
    }

    private synchronized boolean setAttributes(GBeanData data, ConfigurationOverride configuration, Artifact configName, ClassLoader classLoader) throws InvalidConfigException {
        AbstractName gbeanName = data.getAbstractName();
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null) {
            gbean = configuration.getGBean((String)gbeanName.getName().get("name"));
        }
        if (gbean == null) {
            return true;
        }
        return gbean.applyOverrides(data, configName, gbeanName, classLoader);
    }

    @Override
    public void setModuleGBeans(Artifact moduleName, List<GbeanType> gbeans, boolean load, String condition) throws InvalidGBeanException {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(moduleName, true);
        if (gbeans != null) {
            for (GbeanType gbean : gbeans) {
                GBeanOverride override = new GBeanOverride(gbean, this.expressionParser);
                configuration.addGBean(override);
            }
        }
        configuration.setLoad(load);
        configuration.setCondition(condition);
        log.info((Object)("Added gbeans for module: " + moduleName + " load: " + load));
        this.attributeChanged();
    }

    @Override
    public void addConfigSubstitutions(Properties properties) {
        this.localConfigSubstitutions.putAll((Map<?, ?>)properties);
        Map<String, Object> configSubstutions = LocalAttributeManager.loadAllConfigSubstitutions(this.localConfigSubstitutions, this.prefix);
        LocalAttributeManager.storeConfigSubstitutions(this.configSubstitutionsFile, this.localConfigSubstitutions);
        this.expressionParser.setVariables(configSubstutions);
    }

    public synchronized void setValue(Artifact configurationName, AbstractName gbeanName, GAttributeInfo attribute, Object value, ClassLoader classLoader) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null && (gbean = configuration.getGBean((String)gbeanName.getName().get("name"))) == null) {
            gbean = new GBeanOverride(gbeanName, true, this.expressionParser);
            configuration.addGBean(gbeanName, gbean);
        }
        try {
            gbean.setAttribute(attribute.getName(), value, attribute.getType(), classLoader);
            this.attributeChanged();
        }
        catch (InvalidAttributeException e) {
            log.error((Object)e.getMessage());
        }
    }

    public synchronized void setReferencePatterns(Artifact configurationName, AbstractName gbeanName, GReferenceInfo reference, ReferencePatterns patterns) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null && (gbean = configuration.getGBean((String)gbeanName.getName().get("name"))) == null) {
            gbean = new GBeanOverride(gbeanName, true, this.expressionParser);
            configuration.addGBean(gbeanName, gbean);
        }
        gbean.setReferencePatterns(reference.getName(), patterns);
        this.attributeChanged();
    }

    public synchronized void setShouldLoad(Artifact configurationName, AbstractName gbeanName, boolean load) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null) {
            gbean = configuration.getGBean((String)gbeanName.getName().get("name"));
        }
        if (gbean == null) {
            gbean = new GBeanOverride(gbeanName, load, this.expressionParser);
            configuration.addGBean(gbeanName, gbean);
        } else {
            gbean.setLoad(load);
        }
        this.attributeChanged();
    }

    public void addGBean(Artifact configurationName, GBeanData gbeanData, ClassLoader classLoader) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName);
        if (configuration == null) {
            log.debug((Object)("Can not add GBean; Configuration not found " + configurationName));
            return;
        }
        try {
            GBeanOverride gbean = new GBeanOverride(gbeanData, this.expressionParser, classLoader);
            configuration.addGBean(gbean);
            this.attributeChanged();
        }
        catch (InvalidAttributeException e) {
            log.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() throws IOException {
        this.ensureParentDirectory();
        if (!this.attributeFile.exists()) {
            return;
        }
        BufferedReader input = new BufferedReader(new FileReader(this.attributeFile));
        try {
            this.serverOverride = LocalAttributeManager.read(input, this.expressionParser);
        }
        catch (SAXException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        catch (InvalidGBeanException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        catch (JAXBException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        catch (XMLStreamException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        finally {
            ((Reader)input).close();
        }
    }

    static ServerOverride read(Reader input, JexlExpressionParser expressionParser) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException, InvalidGBeanException {
        AttributesType attributes = AttributesXmlUtil.loadAttributes(input);
        return new ServerOverride(attributes, expressionParser);
    }

    public synchronized void save() throws IOException {
        if (this.readOnly) {
            return;
        }
        this.ensureParentDirectory();
        if (!this.tempFile.exists() && !this.tempFile.createNewFile()) {
            throw new IOException("Unable to create manageable attribute working file for save " + this.tempFile.getAbsolutePath());
        }
        if (!this.tempFile.canWrite()) {
            throw new IOException("Unable to write to manageable attribute working file for save " + this.tempFile.getAbsolutePath());
        }
        LocalAttributeManager.saveXmlToFile(this.tempFile, this.serverOverride);
        if (this.backupFile.exists() && !this.backupFile.delete()) {
            throw new IOException("Unable to delete old backup file in order to back up current manageable attribute working file for save");
        }
        if (this.attributeFile.exists() && !this.attributeFile.renameTo(this.backupFile)) {
            throw new IOException("Unable to rename " + this.attributeFile.getAbsolutePath() + " to " + this.backupFile.getAbsolutePath() + " in order to back up manageable attribute save file");
        }
        if (!this.tempFile.renameTo(this.attributeFile)) {
            throw new IOException("EXTREMELY CRITICAL!  Unable to move manageable attributes working file to proper file name!  Configuration will revert to defaults unless this is manually corrected!  (could not rename " + this.tempFile.getAbsolutePath() + " to " + this.attributeFile.getAbsolutePath() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXmlToFile(File file, ServerOverride serverOverride) {
        try {
            FileWriter fileOut = new FileWriter(file);
            try {
                BufferedWriter writer = new BufferedWriter(fileOut);
                LocalAttributeManager.write(serverOverride, writer);
            }
            catch (JAXBException e) {
                log.error((Object)"Unable to write config.xml", (Throwable)e);
            }
            catch (XMLStreamException e) {
                log.error((Object)"Unable to write config.xml", (Throwable)e);
            }
            finally {
                ((Writer)fileOut).close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Unable to write config.xml", (Throwable)e);
        }
    }

    static void write(ServerOverride serverOverride, Writer writer) throws XMLStreamException, JAXBException, IOException {
        AttributesType attributes = serverOverride.writeXml();
        AttributesXmlUtil.writeAttributes(attributes, writer);
        writer.flush();
    }

    public synchronized boolean isKernelFullyStarted() {
        return this.kernelFullyStarted;
    }

    public synchronized void setKernelFullyStarted(boolean kernelFullyStarted) {
        this.kernelFullyStarted = kernelFullyStarted;
    }

    public synchronized List<Artifact> restore() throws IOException {
        ArrayList<Artifact> configs = new ArrayList<Artifact>();
        for (Map.Entry<Artifact, ConfigurationOverride> entry : this.serverOverride.getConfigurations().entrySet()) {
            ConfigurationOverride configuration = entry.getValue();
            if (!configuration.isLoad()) continue;
            Artifact configID = entry.getKey();
            configs.add(configID);
        }
        return configs;
    }

    public void startConfiguration(Artifact configurationName) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, false);
        if (configuration == null) {
            return;
        }
        configuration.setLoad(true);
        this.attributeChanged();
    }

    public synchronized void addConfiguration(Artifact configurationName) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, false);
        if (configuration == null) {
            configuration = this.serverOverride.getConfiguration(configurationName, true);
            configuration.setLoad(false);
            this.attributeChanged();
        }
    }

    public synchronized void removeConfiguration(Artifact configName) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configName);
        if (configuration == null) {
            return;
        }
        this.serverOverride.removeConfiguration(configName);
        this.attributeChanged();
    }

    public Artifact[] getListedConfigurations(Artifact query) {
        return this.serverOverride.queryConfigurations(query);
    }

    public void stopConfiguration(Artifact configName) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configName);
        if (configuration == null) {
            return;
        }
        configuration.setLoad(false);
        this.attributeChanged();
    }

    public void migrateConfiguration(Artifact oldName, Artifact newName, Configuration configuration) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configInfo = this.serverOverride.getConfiguration(oldName);
        if (configInfo == null) {
            throw new IllegalArgumentException("Trying to migrate unknown configuration: " + oldName);
        }
        this.serverOverride.removeConfiguration(oldName);
        configInfo = new ConfigurationOverride(configInfo, newName);
        this.serverOverride.addConfiguration(configInfo);
        this.attributeChanged();
    }

    public boolean hasGBeanAttributes(Artifact configName) {
        ConfigurationOverride configInfo = this.serverOverride.getConfiguration(configName);
        return configInfo != null && !configInfo.getGBeans().isEmpty();
    }

    public synchronized void doStart() throws Exception {
        this.load();
        if (!this.readOnly) {
            this.timer = new Timer(true);
        }
        log.debug((Object)("Started LocalAttributeManager with data on " + this.serverOverride.getConfigurations().size() + " configurations"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStop() throws Exception {
        boolean doSave = false;
        LocalAttributeManager localAttributeManager = this;
        synchronized (localAttributeManager) {
            if (this.timer != null) {
                this.timer.cancel();
                if (this.currentTask != null) {
                    this.currentTask.cancel();
                    doSave = true;
                }
            }
        }
        if (doSave) {
            this.save();
        }
        log.debug((Object)("Stopped LocalAttributeManager with data on " + this.serverOverride.getConfigurations().size() + " configurations"));
        this.serverOverride = new ServerOverride();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doFail() {
        LocalAttributeManager localAttributeManager = this;
        synchronized (localAttributeManager) {
            if (this.timer != null) {
                this.timer.cancel();
                if (this.currentTask != null) {
                    this.currentTask.cancel();
                }
            }
        }
        this.serverOverride = new ServerOverride();
    }

    private synchronized void ensureParentDirectory() throws IOException {
        File parent;
        if (this.attributeFile == null) {
            this.attributeFile = this.serverInfo.resolveServer(this.configFile);
            this.tempFile = new File(this.attributeFile.getAbsolutePath() + TEMP_EXTENSION);
            this.backupFile = new File(this.attributeFile.getAbsolutePath() + BACKUP_EXTENSION);
        }
        if (!(parent = this.attributeFile.getParentFile()).isDirectory() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory for list:" + parent);
        }
        if (!parent.canRead()) {
            throw new IOException("Unable to read manageable attribute files in directory " + parent.getAbsolutePath());
        }
        if (!this.readOnly && !parent.canWrite()) {
            throw new IOException("Unable to write manageable attribute files to directory " + parent.getAbsolutePath());
        }
    }

    private synchronized void attributeChanged() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        if (this.timer != null) {
            this.currentTask = new TimerTask(){

                public void run() {
                    try {
                        LocalAttributeManager.this.save();
                    }
                    catch (IOException e) {
                        log.error((Object)"IOException occurred while saving attributes", (Throwable)e);
                    }
                    catch (Throwable t) {
                        log.error((Object)"Error occurred during execution of attributeChanged TimerTask", t);
                    }
                }
            };
            this.timer.schedule(this.currentTask, 5000L);
        }
    }

    private static Map<String, Object> loadAllConfigSubstitutions(Properties configSubstitutions, String prefix) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        LocalAttributeManager.addGeronimoSubstitutions(vars, System.getProperties(), prefix);
        LocalAttributeManager.addGeronimoSubstitutions(vars, System.getenv(), prefix);
        if (configSubstitutions != null) {
            LocalAttributeManager.addGeronimoSubstitutions(vars, configSubstitutions, "");
        }
        ParserUtils.addDefaultVariables(vars);
        return vars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadConfigSubstitutions(File configSubstitutionsFile) {
        Properties properties = new Properties();
        if (configSubstitutionsFile != null) {
            try {
                FileInputStream in = new FileInputStream(configSubstitutionsFile);
                try {
                    properties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                log.error((Object)("Caught exception " + e + " trying to open properties file " + configSubstitutionsFile.getAbsolutePath()));
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeConfigSubstitutions(File configSubstitutionsFile, Properties properties) {
        if (configSubstitutionsFile != null) {
            try {
                FileOutputStream out = new FileOutputStream(configSubstitutionsFile);
                try {
                    properties.store(out, null);
                }
                finally {
                    out.close();
                }
            }
            catch (Exception e) {
                log.error((Object)("Caught exception " + e + " trying to open properties file " + configSubstitutionsFile.getAbsolutePath()));
            }
        }
    }

    private static void addGeronimoSubstitutions(Map<String, Object> vars, Map props, String prefix) {
        if (prefix != null) {
            int start = prefix.length();
            for (Map.Entry o : props.entrySet()) {
                String key;
                Map.Entry entry = o;
                if (!((String)entry.getKey()).startsWith(prefix) || vars.containsKey(key = ((String)entry.getKey()).substring(start))) continue;
                vars.put(key, (String)entry.getValue());
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(LocalAttributeManager.class, (String)"AttributeStore");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addAttribute("configFile", String.class, true);
        infoFactory.addAttribute("readOnly", Boolean.TYPE, true);
        infoFactory.addAttribute("substitutionsFile", String.class, true);
        infoFactory.addAttribute("substitutionPrefix", String.class, true);
        infoFactory.addInterface(ManageableAttributeStore.class);
        infoFactory.addInterface(PersistentConfigurationList.class);
        infoFactory.setConstructor(new String[]{"configFile", "substitutionsFile", "substitutionPrefix", "readOnly", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

