/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration.condition;

import java.util.Map;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlExprResolver;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.jexl.resolver.FlatResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JexlExpressionParser {
    private static final Log log = LogFactory.getLog(JexlExpressionParser.class);
    protected JexlContext context;
    private FlatResolver resolver = new FlatResolver(true);

    public JexlExpressionParser(Map vars) {
        if (vars == null) {
            throw new IllegalArgumentException("vars");
        }
        this.context = JexlHelper.createContext();
        this.context.setVars(vars);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Using variables: " + this.context.getVars()));
        }
    }

    public JexlExpressionParser() {
        this(System.getProperties());
    }

    public Map getVariables() {
        return this.context.getVars();
    }

    public Object getVariable(Object name) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        return this.getVariables().get(name);
    }

    public Object setVariable(Object name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        return this.getVariables().put(name, value);
    }

    public Object unsetVariable(Object name) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        return this.getVariables().remove(name);
    }

    public void addVariables(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("map");
        }
        this.getVariables().putAll(map);
    }

    public void setVariables(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("map");
        }
        this.context.setVars(map);
    }

    protected Expression createExpression(String expression) throws Exception {
        Expression expr = ExpressionFactory.createExpression((String)expression);
        expr.addPreResolver((JexlExprResolver)this.resolver);
        return expr;
    }

    public Object evaluate(String expression) throws Exception {
        if (expression == null) {
            throw new IllegalArgumentException("expression");
        }
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Evaluating expression: " + expression));
        }
        Expression expr = this.createExpression(expression);
        Object obj = expr.evaluate(this.context);
        if (trace) {
            log.trace((Object)("Result: " + obj));
        }
        return obj;
    }

    public String parse(String input) {
        int prefixLoc;
        if (input == null) {
            throw new IllegalArgumentException("input");
        }
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Parsing input: " + input));
        }
        StringBuffer buff = new StringBuffer();
        int cur = 0;
        while (cur < input.length() && (prefixLoc = input.indexOf("${", cur)) >= 0) {
            int suffixLoc = this.findBlockEnd(prefixLoc + 2, input);
            if (suffixLoc < 0) {
                throw new RuntimeException("Missing '}': " + input);
            }
            String expr = input.substring(prefixLoc + 2, suffixLoc);
            buff.append(input.substring(cur, prefixLoc));
            try {
                buff.append(this.evaluate(expr));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to evaluate: " + expr, e);
            }
            cur = suffixLoc + 1;
        }
        buff.append(input.substring(cur));
        if (trace) {
            log.trace((Object)("Parsed result: " + buff));
        }
        return buff.toString();
    }

    private int findBlockEnd(int pos, String input) {
        int nested = 0;
        while (pos < input.length()) {
            char ch = input.charAt(pos);
            if (ch == '{') {
                ++nested;
            } else if (ch == '}') {
                if (nested == 0) {
                    return pos;
                }
                --nested;
            }
            ++pos;
        }
        return -1;
    }

    public String parse(String input, boolean trim) {
        String output = this.parse(input);
        if (trim && output != null) {
            output = output.trim();
        }
        return output;
    }
}

