/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.serverinfo;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DirectoryUtils {
    private static final Log log = LogFactory.getLog(DirectoryUtils.class);
    private static final File geronimoInstallDirectory;

    public static File getGeronimoInstallDirectory() {
        return geronimoInstallDirectory;
    }

    static {
        URL url = DirectoryUtils.class.getClassLoader().getResource("META-INF/startup-jar");
        File directory = null;
        if (url != null) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                url = jarConnection.getJarFileURL();
                URI baseURI = new URI(url.toString()).resolve("..");
                directory = new File(baseURI);
            }
            catch (Exception ignored) {
                log.error((Object)"Error while determining the installation directory of Apache Geronimo", (Throwable)ignored);
            }
        } else {
            log.error((Object)"Cound not determine the installation directory of Apache Geronimo, because the startup jar could not be found in the current class loader.");
        }
        geronimoInstallDirectory = directory;
    }
}

