/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;
import org.apache.geronimo.crypto.AbstractEncryption;
import org.apache.geronimo.crypto.Encryption;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class ConfiguredEncryption
extends AbstractEncryption
implements GBeanLifecycle {
    private final SecretKeySpec spec;
    public static final GBeanInfo GBEAN_INFO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfiguredEncryption(String path, ServerInfo serverInfo) throws IOException, ClassNotFoundException {
        block16: {
            if (path == null || "".equals(path)) {
                this.spec = null;
                return;
            }
            File location = serverInfo.resolve(path);
            if (location.exists()) {
                FileInputStream in = new FileInputStream(location);
                try {
                    ObjectInputStream oin = new ObjectInputStream(in);
                    try {
                        this.spec = (SecretKeySpec)oin.readObject();
                        break block16;
                    }
                    finally {
                        oin.close();
                    }
                }
                finally {
                    in.close();
                }
            }
            SecureRandom random = new SecureRandom();
            random.setSeed(System.currentTimeMillis());
            byte[] bytes = new byte[16];
            random.nextBytes(bytes);
            this.spec = new SecretKeySpec(bytes, "AES");
            File dir = location.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!dir.exists() || !dir.isDirectory()) {
                throw new IllegalStateException("Could not create directory for secret key spec: " + dir);
            }
            FileOutputStream out = new FileOutputStream(location);
            try {
                ObjectOutputStream oout = new ObjectOutputStream(out);
                try {
                    oout.writeObject(this.spec);
                    oout.flush();
                }
                finally {
                    oout.close();
                }
            }
            finally {
                out.close();
            }
        }
    }

    public void doStart() throws Exception {
        if (this.spec != null) {
            EncryptionManager.setEncryptionPrefix((String)"{Configured}", (Encryption)this);
        }
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }

    protected SecretKeySpec getSecretKeySpec() {
        return this.spec;
    }

    public String encrypt(String text) {
        return EncryptionManager.encrypt((Serializable)((Object)text));
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(ConfiguredEncryption.class, (String)"GBean");
        infoBuilder.addAttribute("path", String.class, true, true);
        infoBuilder.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoBuilder.setConstructor(new String[]{"path", "ServerInfo"});
        infoBuilder.addOperation("encrypt", new Class[]{String.class}, "java.lang.String");
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

