/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration.condition;

import java.util.HashMap;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.system.configuration.condition.ConditionParser;
import org.apache.geronimo.system.configuration.condition.ConditionParserException;
import org.apache.geronimo.system.configuration.condition.ParserUtils;

public class OgnlConditionParser
implements ConditionParser {
    private static final Log log = LogFactory.getLog(OgnlConditionParser.class);
    private final Map<String, Object> vars;

    public OgnlConditionParser(Map vars) {
        if (vars == null) {
            throw new IllegalArgumentException("vars");
        }
        this.vars = vars;
    }

    public OgnlConditionParser() {
        this.vars = new HashMap<String, Object>();
        ParserUtils.addDefaultVariables(this.vars);
    }

    public boolean evaluate(String expression) throws ConditionParserException {
        Object result;
        if (expression == null) {
            throw new IllegalArgumentException("Expression must not be null");
        }
        if (expression.trim().length() == 0) {
            log.debug((Object)"Expression is empty; skipping evaluation");
            return true;
        }
        try {
            result = this.doEvaluate(expression);
        }
        catch (Exception e) {
            throw new ConditionParserException("Failed to evaluate expression: " + expression, e);
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new ConditionParserException("Expression '" + expression + "' did not evaluate to a boolean value; found: " + result);
    }

    private Object doEvaluate(String expression) throws Exception {
        assert (expression != null);
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Evaluating expression: " + expression));
        }
        OgnlContext context = new OgnlContext(this.vars);
        Object expr = Ognl.parseExpression((String)expression);
        Object result = Ognl.getValue((Object)expr, (Object)context);
        if (debug) {
            log.debug((Object)("Result: " + result));
        }
        return result;
    }
}

