/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.properties;

import java.security.Provider;
import java.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JvmVendor {
    private static final Log log = LogFactory.getLog(JvmVendor.class);
    private static final String JVM_VENDOR_PROPERTY_NAME = "java.vm.vendor";
    private static final boolean sun;
    private static final boolean ibm;
    private static final boolean apache;
    private static final boolean ibmHybrid;

    private JvmVendor() {
    }

    public static String getFullName() {
        return System.getProperty(JVM_VENDOR_PROPERTY_NAME);
    }

    public static boolean isSun() {
        return sun;
    }

    public static boolean isIBM() {
        return ibm;
    }

    public static boolean isIBMHybrid() {
        return ibmHybrid;
    }

    public static boolean isApache() {
        return apache;
    }

    public static String getJvmInfo() {
        if (sun) {
            return new String("Sun JVM " + System.getProperty("java.version"));
        }
        if (apache) {
            return new String("Apache Harmony JVM " + System.getProperty("java.version"));
        }
        if (ibm) {
            return new String("IBM JVM " + System.getProperty("java.version"));
        }
        if (ibmHybrid) {
            return new String("IBM Hybrid JVM " + System.getProperty("java.version") + " on " + System.getProperty("os.name"));
        }
        return new String("Unknown JVM detected - " + JvmVendor.getFullName());
    }

    static {
        String fullVendorName = JvmVendor.getFullName();
        boolean bApache = fullVendorName.substring(0, 6).equalsIgnoreCase("Apache");
        boolean bIBM = fullVendorName.substring(0, 3).equalsIgnoreCase("IBM");
        boolean bSun = !bIBM && !bApache;
        boolean bHP = fullVendorName.substring(0, 6).equalsIgnoreCase("Hewlet");
        boolean bIBMHybrid = false;
        if (bSun && System.getProperty("os.name").equalsIgnoreCase("SunOS") || bHP && System.getProperty("os.name").equalsIgnoreCase("HP-UX")) {
            log.debug((Object)"Looking for the IBM Hybrid SDK Extensions");
            try {
                if (Security.getProvider("com.ibm.jsse2.IBMJSSEProvider2") == null) {
                    log.debug((Object)"Trying to load IBM JSSE2 Provider.");
                    Class<?> c = Class.forName("com.ibm.jsse2.IBMJSSEProvider2");
                    Provider p = (Provider)c.newInstance();
                    Security.addProvider(p);
                    log.debug((Object)"Loaded the IBM JSSE2 Provider");
                } else {
                    log.debug((Object)("Found the IBM JSSE2 Provider = " + Security.getProvider("com.ibm.jsse2.IBMJSSEProvider2")));
                }
                if (Security.getProvider("IBMCertPath") == null) {
                    log.debug((Object)"No IBMCertPath provider found.");
                    throw new RuntimeException("Could not find the IBMCertPath provider.");
                }
                log.debug((Object)("Found the IBMCertPath Provider = " + Security.getProvider("IBMCertPath")));
                if (Security.getProvider("IBMJCE") == null) {
                    log.debug((Object)"No IBMJCE provider found.");
                    throw new RuntimeException("Could not find the IBMJCE provider.");
                }
                log.debug((Object)("Found the IBMJCE Provider" + Security.getProvider("IBMJCE")));
                System.setProperty("java.protocol.handler.pkgs", "com.ibm.net.ssl.www2.protocol");
                bSun = false;
                bApache = false;
                bIBM = true;
                bIBMHybrid = true;
            }
            catch (ClassNotFoundException e) {
                log.debug((Object)("Caught Exception=" + e.toString()));
                log.debug((Object)"Could not load the IBM JSSE Provider.  Must be using the OS provider's Java.");
            }
            catch (Throwable t) {
                log.debug((Object)("Caught Throwable=" + t.toString()));
                log.debug((Object)"Assume we could not load the IBM JSSE Provider and that we are using the OS provider's Java.");
            }
        }
        apache = bApache;
        ibm = bIBM;
        ibmHybrid = bIBMHybrid;
        sun = bSun;
        log.info((Object)JvmVendor.getJvmInfo());
    }
}

