/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.logging.log4j;

import org.apache.commons.logging.Log;
import org.apache.geronimo.system.logging.log4j.XLevel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class CachingLog4jLog
implements Log {
    private final String FQCN = this.getClass().getName();
    private Logger logger;
    private boolean traceEnabled;
    private boolean debugEnabled;
    private boolean infoEnabled;

    public CachingLog4jLog(String name) {
        this.logger = Logger.getLogger((String)name);
        this.updateLevelInfo();
    }

    public CachingLog4jLog(Logger logger) {
        this.logger = logger;
        this.updateLevelInfo();
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void trace(Object message) {
        if (this.traceEnabled) {
            this.logger.log(this.FQCN, (Priority)XLevel.TRACE, message, null);
        }
    }

    public void trace(Object message, Throwable throwable) {
        if (this.traceEnabled) {
            this.logger.log(this.FQCN, (Priority)XLevel.TRACE, message, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void debug(Object message) {
        if (this.debugEnabled) {
            this.logger.log(this.FQCN, (Priority)Level.DEBUG, message, null);
        }
    }

    public void debug(Object message, Throwable throwable) {
        if (this.debugEnabled) {
            this.logger.log(this.FQCN, (Priority)Level.DEBUG, message, throwable);
        }
    }

    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public void info(Object message) {
        if (this.infoEnabled) {
            this.logger.log(this.FQCN, (Priority)Level.INFO, message, null);
        }
    }

    public void info(Object message, Throwable throwable) {
        if (this.infoEnabled) {
            this.logger.log(this.FQCN, (Priority)Level.INFO, message, throwable);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public void warn(Object message) {
        this.logger.log(this.FQCN, (Priority)Level.WARN, message, null);
    }

    public void warn(Object message, Throwable throwable) {
        this.logger.log(this.FQCN, (Priority)Level.WARN, message, throwable);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public void error(Object message) {
        this.logger.log(this.FQCN, (Priority)Level.ERROR, message, null);
    }

    public void error(Object message, Throwable throwable) {
        this.logger.log(this.FQCN, (Priority)Level.ERROR, message, throwable);
    }

    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor((Priority)Level.FATAL);
    }

    public void fatal(Object message) {
        this.logger.log(this.FQCN, (Priority)Level.FATAL, message, null);
    }

    public void fatal(Object message, Throwable throwable) {
        this.logger.log(this.FQCN, (Priority)Level.FATAL, message, throwable);
    }

    public void updateLevelInfo() {
        this.traceEnabled = this.logger.isEnabledFor((Priority)XLevel.TRACE);
        this.debugEnabled = this.logger.isDebugEnabled();
        this.infoEnabled = this.logger.isInfoEnabled();
    }
}

