/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.main.StartupMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SilentStartupMonitor
implements StartupMonitor {
    private static final Logger log = LoggerFactory.getLogger(SilentStartupMonitor.class);
    private Kernel kernel;

    public void systemStarting(long startTime) {
    }

    public void systemStarted(Kernel kernel) {
        this.kernel = kernel;
    }

    public void foundModules(Artifact[] modules) {
    }

    public void moduleLoading(Artifact module) {
    }

    public void moduleLoaded(Artifact module) {
    }

    public void moduleStarting(Artifact module) {
    }

    public void moduleStarted(Artifact module) {
    }

    public void startupFinished() {
        try {
            Set gbeans = this.kernel.listGBeans((AbstractNameQuery)null);
            for (AbstractName name : gbeans) {
                int state = this.kernel.getGBeanState(name);
                if (state == 1) continue;
                log.warn("Unable to start {} ({})", (Object)name, (Object)State.fromInt((int)state).getName());
            }
        }
        catch (GBeanNotFoundException gBeanNotFoundException) {
            // empty catch block
        }
        System.out.println("Geronimo startup complete");
    }

    public void serverStartFailed(Exception problem) {
        System.out.println("Geronimo startup failed:");
        problem.printStackTrace(System.out);
    }
}

