/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.serverinfo;

import java.io.File;
import java.net.URI;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.system.serverinfo.DirectoryUtils;
import org.apache.geronimo.system.serverinfo.ServerConstants;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class BasicServerInfo
implements ServerInfo {
    public static final String SERVER_NAME_SYS_PROP = "org.apache.geronimo.server.name";
    public static final String SERVER_DIR_SYS_PROP = "org.apache.geronimo.server.dir";
    public static final String HOME_DIR_SYS_PROP = "org.apache.geronimo.home.dir";
    private final String baseDirectory;
    private final File base;
    private final File baseServer;
    private final URI baseURI;
    private final URI baseServerURI;
    public static final GBeanInfo GBEAN_INFO;

    public BasicServerInfo() {
        this.baseDirectory = null;
        this.base = null;
        this.baseServer = null;
        this.baseURI = null;
        this.baseServerURI = null;
    }

    public BasicServerInfo(String defaultBaseDirectory) throws Exception {
        this(defaultBaseDirectory, true);
    }

    public BasicServerInfo(String defaultBaseDirectory, boolean useSystemProperties) throws Exception {
        this.baseDirectory = useSystemProperties ? System.getProperty(HOME_DIR_SYS_PROP, defaultBaseDirectory) : defaultBaseDirectory;
        ServerConstants.getVersion();
        if (this.baseDirectory == null || this.baseDirectory.length() == 0) {
            this.base = DirectoryUtils.getGeronimoInstallDirectory();
            if (this.base == null) {
                throw new IllegalArgumentException("Could not determine geronimo installation directory");
            }
        } else {
            this.base = new File(this.baseDirectory);
        }
        if (!this.base.isDirectory()) {
            throw new IllegalArgumentException("Base directory is not a directory: " + this.baseDirectory);
        }
        this.baseURI = this.base.toURI();
        this.baseServer = this.deriveBaseServer(useSystemProperties);
        this.baseServerURI = this.baseServer.toURI();
        if (useSystemProperties) {
            System.setProperty(HOME_DIR_SYS_PROP, this.base.getAbsolutePath());
            System.setProperty(SERVER_DIR_SYS_PROP, this.baseServer.getAbsolutePath());
        }
        String tmpDir = this.resolveServerPath(System.getProperty("java.io.tmpdir"));
        System.setProperty("java.io.tmpdir", tmpDir);
    }

    public BasicServerInfo(String baseDirectory, String serverName) {
        this.baseDirectory = baseDirectory;
        this.base = new File(baseDirectory);
        this.baseURI = this.base.toURI();
        this.baseServerURI = this.baseURI.resolve(serverName);
        this.baseServer = new File(this.baseServerURI);
    }

    public String resolvePath(String filename) {
        return this.resolve(filename).getAbsolutePath();
    }

    public String resolveServerPath(String filename) {
        return this.resolveServer(filename).getAbsolutePath();
    }

    public File resolve(String filename) {
        return this.resolveWithBase(this.base, filename);
    }

    public File resolveServer(String filename) {
        return this.resolveWithBase(this.baseServer, filename);
    }

    public URI resolve(URI uri) {
        return this.baseURI.resolve(uri);
    }

    public URI resolveServer(URI uri) {
        return this.baseServerURI.resolve(uri);
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public String getCurrentBaseDirectory() {
        return this.base.getAbsolutePath();
    }

    public String getVersion() {
        return ServerConstants.getVersion();
    }

    public String getBuildDate() {
        return ServerConstants.getBuildDate();
    }

    public String getBuildTime() {
        return ServerConstants.getBuildTime();
    }

    public String getCopyright() {
        return ServerConstants.getCopyright();
    }

    private File resolveWithBase(File baseDir, String filename) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(baseDir, filename);
    }

    private File deriveBaseServer(boolean useSystemProperties) {
        File baseServerDir;
        String baseServerDirPath = System.getProperty(SERVER_DIR_SYS_PROP);
        if (!useSystemProperties || null == baseServerDirPath) {
            String serverName = System.getProperty(SERVER_NAME_SYS_PROP);
            baseServerDir = !useSystemProperties || null == serverName ? this.base : new File(this.base, serverName);
        } else {
            baseServerDir = new File(baseServerDirPath);
            if (!baseServerDir.isAbsolute()) {
                baseServerDir = new File(this.base, baseServerDirPath);
            }
        }
        if (!baseServerDir.isDirectory()) {
            throw new IllegalArgumentException("Server directory is not a directory: " + baseServerDir);
        }
        return baseServerDir;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(BasicServerInfo.class);
        infoFactory.addAttribute("baseDirectory", String.class, true);
        infoFactory.addInterface(ServerInfo.class);
        infoFactory.setConstructor(new String[]{"baseDirectory"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

