/**
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.geronimo.system.repository;

import java.io.File;
import java.net.URI;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.apache.geronimo.system.serverinfo.ServerInfo;

/**
 * @version $Rev: 651684 $ $Date: 2008-04-25 12:11:52 -0700 (Fri, 25 Apr 2008) $
 */
public abstract class AbstractRepository extends org.apache.geronimo.kernel.repository.AbstractRepository {
    protected final Logger log = LoggerFactory.getLogger(getClass());

    public AbstractRepository(URI root, ServerInfo serverInfo, boolean resolveToServer) {
        super(new ServerInfoRootResolver(serverInfo, resolveToServer).resolve(root));
    }
    
    public AbstractRepository(File rootFile) {
        super(rootFile);
    }

}
