/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.main.StartupMonitor;
import org.apache.geronimo.system.main.StartupMonitorUtil;

public class LongStartupMonitor
implements StartupMonitor {
    private PrintStream out;
    private int numModules;
    private int numModulesDigits;
    private int moduleNum;
    private int longestModuleNameLength;
    private long started;
    private long moduleStarted;
    private Kernel kernel;

    @Override
    public synchronized void systemStarting(long startTime) {
        this.out = System.out;
        this.started = startTime;
    }

    @Override
    public synchronized void systemStarted(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public synchronized void foundModules(Artifact[] modules) {
        this.numModules = modules.length;
        this.numModulesDigits = Integer.toString(this.numModules).length();
        int len = 0;
        for (int i = 0; i < modules.length; ++i) {
            len = modules[i].toString().length();
            if (len <= this.longestModuleNameLength) continue;
            this.longestModuleNameLength = len;
        }
    }

    @Override
    public synchronized void moduleLoading(Artifact module) {
        StringBuffer buf = new StringBuffer("Module ");
        for (int configIndexDigits = Integer.toString(++this.moduleNum).length(); configIndexDigits < this.numModulesDigits; ++configIndexDigits) {
            buf.append(' ');
        }
        buf.append(this.moduleNum).append('/').append(this.numModules).append(' ');
        buf.append(module);
        for (int len = module.toString().length(); len < this.longestModuleNameLength; ++len) {
            buf.append(' ');
        }
        this.out.print(buf);
    }

    @Override
    public synchronized void moduleLoaded(Artifact module) {
    }

    @Override
    public synchronized void moduleStarting(Artifact module) {
        this.moduleStarted = System.currentTimeMillis();
    }

    @Override
    public synchronized void moduleStarted(Artifact module) {
        int index;
        long time = System.currentTimeMillis() - this.moduleStarted;
        StringBuffer buf = new StringBuffer();
        buf.append(" started in ");
        String formattedTime = LongStartupMonitor.getFormattedTime(time);
        if (formattedTime.startsWith("0.")) {
            formattedTime = " " + formattedTime.substring(1);
        }
        if ((index = formattedTime.indexOf(58)) == -1) {
            index = formattedTime.indexOf(46);
        }
        if (index == 1) {
            buf.append(' ');
        }
        buf.append(formattedTime);
        this.out.println(buf.toString());
    }

    @Override
    public synchronized void startupFinished() {
        long time = System.currentTimeMillis() - this.started;
        this.out.println("Startup completed in " + LongStartupMonitor.getFormattedTime(time) + " seconds");
        StartupMonitorUtil.wrapUp(this.out, this.kernel);
    }

    @Override
    public synchronized void serverStartFailed(Exception problem) {
        this.out.println("Server Startup failed");
        this.out.println();
        problem.printStackTrace(this.out);
    }

    private static String getFormattedTime(long time) {
        String pattern = "s.SSS's'";
        if (time / 60000L > 0L) {
            pattern = "m:s" + pattern;
            if (time / 3600000L > 0L) {
                pattern = "H:m" + pattern;
            }
        }
        SimpleDateFormat fmt = new SimpleDateFormat(pattern);
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return fmt.format(new Date(time));
    }
}

