/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.Main;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainBridge
implements org.apache.geronimo.main.Main,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(MainBridge.class);
    protected final Kernel kernel;
    protected final Bundle bundle;
    public static final GBeanInfo GBEAN_INFO;

    public MainBridge(Kernel kernel, Bundle bundle) {
        this.kernel = kernel;
        this.bundle = bundle;
    }

    public int execute(Object opaque) {
        Main main;
        try {
            this.loadPersistentConfigurations();
            main = this.getMain();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.shutdownKernel();
            return 1;
        }
        return main.execute(opaque);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPersistentConfigurations() throws Exception {
        ArrayList configs = new ArrayList();
        AbstractNameQuery query = new AbstractNameQuery(PersistentConfigurationList.class.getName());
        if (configs.isEmpty()) {
            Set configLists = this.kernel.listGBeans(query);
            for (AbstractName configListName : configLists) {
                configs.addAll((List)this.kernel.invoke(configListName, "restore"));
            }
        }
        ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
        try {
            for (Artifact config : configs) {
                configurationManager.loadConfiguration(config);
                configurationManager.startConfiguration(config);
            }
        }
        finally {
            ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
        }
    }

    protected Main getMain() throws Exception {
        return (Main)this.kernel.getGBean(Main.class);
    }

    protected void shutdownKernel() {
        try {
            this.kernel.shutdown();
        }
        catch (Exception e1) {
            System.err.println("Exception caught during kernel shutdown");
            e1.printStackTrace();
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public void doFail() {
    }

    public void doStart() throws Exception {
        this.bundle.getBundleContext().registerService(org.apache.geronimo.main.Main.class.getName(), (Object)this, new Hashtable());
    }

    public void doStop() throws Exception {
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(MainBridge.class, (String)"MainBridge");
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("bundle", Bundle.class, false);
        infoFactory.setConstructor(new String[]{"kernel", "bundle"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

