/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.OsgiService;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.AbstractRepository;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.system.plugin.model.DependencyType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.apache.geronimo.system.plugin.model.PluginXmlUtil;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.HeaderParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
@OsgiService
public class DependencyManager
implements SynchronousBundleListener,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(DependencyManager.class);
    private final BundleContext bundleContext;
    private final Collection<Repository> repositories;
    private RepositoryAdmin repositoryAdmin;
    private final ArtifactResolver artifactResolver;
    private final Map<Long, PluginArtifactType> pluginMap = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Long, Set<Long>> dependentBundleIdsMap = new ConcurrentHashMap<Long, Set<Long>>();
    private final Map<Long, Set<Long>> fullDependentBundleIdsMap = new ConcurrentHashMap<Long, Set<Long>>();
    private final Map<Long, Set<BundleDescription.ExportPackage>> bundleExportPackagesMap = new HashMap<Long, Set<BundleDescription.ExportPackage>>();
    private final Map<Artifact, Bundle> artifactBundleMap = new ConcurrentHashMap<Artifact, Bundle>();
    private final Map<Long, Artifact> bundleIdArtifactMap = new ConcurrentHashMap<Long, Artifact>();
    private ServiceReference respositoryAdminReference;

    public DependencyManager(@ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamReference(name="Repositories", namingType="Repository") Collection<Repository> repositories, @ParamReference(name="ArtifactResolver", namingType="ArtifactResolver") ArtifactResolver artifactResolver) {
        this.bundleContext = bundleContext;
        this.repositories = repositories;
        this.artifactResolver = artifactResolver;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        int eventType = bundleEvent.getType();
        if (eventType == 1 || eventType == 32) {
            this.installed(bundleEvent.getBundle());
        } else if (eventType == 128) {
            this.starting(bundleEvent.getBundle());
        } else if (eventType == 16) {
            this.uninstall(bundleEvent.getBundle());
        }
    }

    public Set<BundleDescription.ExportPackage> getExportedPackages(Bundle bundle) {
        return this.getExportedPackages(bundle.getBundleId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BundleDescription.ExportPackage> getExportedPackages(Long bundleId) {
        Map<Long, Set<BundleDescription.ExportPackage>> map = this.bundleExportPackagesMap;
        synchronized (map) {
            Set<BundleDescription.ExportPackage> exportPackages = this.bundleExportPackagesMap.get(bundleId);
            if (exportPackages == null) {
                exportPackages = this.getExportPackagesInternal(this.bundleContext.getBundle(bundleId.longValue()));
                this.bundleExportPackagesMap.put(bundleId, exportPackages);
            }
            return exportPackages;
        }
    }

    public List<Bundle> getDependentBundles(Bundle bundle) {
        Set<Long> dependentBundleIds = this.getDependentBundleIds(bundle);
        if (dependentBundleIds.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Bundle> dependentBundles = new ArrayList<Bundle>(dependentBundleIds.size());
        for (Long dependentBundleId : dependentBundleIds) {
            Bundle b = this.bundleContext.getBundle(dependentBundleId.longValue());
            if (b == null) continue;
            dependentBundles.add(b);
        }
        return dependentBundles;
    }

    public Set<Long> getDependentBundleIds(Bundle bundle) {
        Set<Long> dependentBundleIds = this.dependentBundleIdsMap.get(bundle.getBundleId());
        return dependentBundleIds == null ? Collections.emptySet() : new HashSet<Long>(dependentBundleIds);
    }

    public Set<Bundle> getFullDependentBundles(Bundle bundle) {
        return this.getFullDependentBundles(bundle.getBundleId());
    }

    public Set<Bundle> getFullDependentBundles(Long bundleId) {
        Set<Long> fullDependentBundleIds = this.getFullDependentBundleIds(bundleId);
        if (fullDependentBundleIds.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<Bundle> dependentBundles = new HashSet<Bundle>(fullDependentBundleIds.size());
        for (Long dependentBundleId : fullDependentBundleIds) {
            Bundle b = this.bundleContext.getBundle(dependentBundleId.longValue());
            if (b == null) continue;
            dependentBundles.add(b);
        }
        return dependentBundles;
    }

    public Set<Long> getFullDependentBundleIds(Bundle bundle) {
        return this.getFullDependentBundleIds(bundle.getBundleId());
    }

    public Set<Long> getFullDependentBundleIds(Long bundleId) {
        Set<Long> fullDependentBundleIds = this.fullDependentBundleIdsMap.get(bundleId);
        return fullDependentBundleIds == null ? Collections.emptySet() : new HashSet<Long>(fullDependentBundleIds);
    }

    public Bundle getBundle(Artifact artifact) {
        if (!artifact.isResolved()) {
            try {
                if (this.artifactResolver != null) {
                    artifact = this.artifactResolver.resolveInClassLoader(artifact);
                }
            }
            catch (MissingDependencyException missingDependencyException) {
                // empty catch block
            }
        }
        return this.artifactBundleMap.get(artifact);
    }

    public Artifact getArtifact(long bundleId) {
        return this.bundleIdArtifactMap.get(bundleId);
    }

    public Artifact toArtifact(String installationLocation) {
        if (installationLocation == null) {
            return null;
        }
        if (installationLocation.startsWith("mvn:")) {
            String[] artifactFragments = installationLocation.substring(4).split("[/]");
            if (artifactFragments.length < 2) {
                return null;
            }
            return new Artifact(artifactFragments[0], artifactFragments[1], artifactFragments.length > 2 ? artifactFragments[2] : "", artifactFragments.length > 3 && artifactFragments[3].length() > 0 ? artifactFragments[3] : "jar");
        }
        if (installationLocation.startsWith("reference:file://")) {
            installationLocation = installationLocation.substring("reference:file://".length());
            for (Repository repo : this.repositories) {
                String[] filePathFragments;
                File rootFile;
                if (!(repo instanceof AbstractRepository) || !installationLocation.startsWith((rootFile = ((AbstractRepository)repo).getRootFile()).getAbsolutePath())) continue;
                String artifactString = installationLocation.substring(rootFile.getAbsolutePath().length());
                if (artifactString.startsWith(File.separator)) {
                    artifactString = artifactString.substring(File.separator.length());
                }
                if ((filePathFragments = artifactString.split("[" + (File.separator.equals("\\") ? "\\\\" : File.separator) + "]")).length < 4) continue;
                StringBuilder groupId = new StringBuilder(filePathFragments[0]);
                for (int i = 1; i <= filePathFragments.length - 4; ++i) {
                    groupId.append(".").append(filePathFragments[i]);
                }
                return new Artifact(groupId.toString(), filePathFragments[filePathFragments.length - 3], filePathFragments[filePathFragments.length - 2], filePathFragments[filePathFragments.length - 1].substring(filePathFragments[filePathFragments.length - 1].lastIndexOf(46) + 1));
            }
        }
        return null;
    }

    public void updatePluginMetadata(Bundle bundle) {
        Long bundleId = bundle.getBundleId();
        this.dependentBundleIdsMap.remove(bundleId);
        this.fullDependentBundleIdsMap.remove(bundleId);
        this.pluginMap.remove(bundleId);
        PluginArtifactType pluginArtifactType = this.getCachedPluginMetadata(bundle);
        if (pluginArtifactType != null) {
            List<DependencyType> dependencies = pluginArtifactType.getDependency();
            HashSet<Long> dependentBundleIds = new HashSet<Long>();
            HashSet<Long> fullDependentBundleIds = new HashSet<Long>();
            try {
                for (DependencyType dependencyType : dependencies) {
                    Set<Long> parentDependentBundleIds;
                    Artifact artifact = dependencyType.toArtifact();
                    Bundle dependentBundle = this.getBundle(artifact);
                    if (dependentBundle == null) {
                        log.warn("Dependent artifact " + artifact + " could not be resolved, it will be ignored");
                        continue;
                    }
                    Long dependentBundleId = dependentBundle.getBundleId();
                    dependentBundleIds.add(dependentBundleId);
                    if (!fullDependentBundleIds.add(dependentBundleId) || (parentDependentBundleIds = this.fullDependentBundleIdsMap.get(dependentBundleId)) == null) continue;
                    fullDependentBundleIds.addAll(parentDependentBundleIds);
                }
                this.fullDependentBundleIdsMap.put(bundle.getBundleId(), fullDependentBundleIds);
                this.dependentBundleIdsMap.put(bundle.getBundleId(), dependentBundleIds);
            }
            catch (Exception e) {
                log.error("Could not update bundle dependecy", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePluginMetadata(BundleContext bundleContext, Bundle bundle) {
        ServiceReference serviceReference = null;
        try {
            serviceReference = bundleContext.getServiceReference(DependencyManager.class.getName());
            DependencyManager dependencyManager = null;
            if (serviceReference != null) {
                dependencyManager = (DependencyManager)bundleContext.getService(serviceReference);
                dependencyManager.updatePluginMetadata(bundle);
            }
        }
        finally {
            if (serviceReference != null) {
                bundleContext.ungetService(serviceReference);
            }
        }
    }

    private void addArtifactBundleEntry(Bundle bundle) {
        Artifact artifact = this.toArtifact(bundle.getLocation());
        if (artifact != null) {
            this.artifactBundleMap.put(artifact, bundle);
            this.bundleIdArtifactMap.put(bundle.getBundleId(), artifact);
        } else if (log.isDebugEnabled()) {
            log.debug("fail to resovle artifact from the bundle location " + bundle.getLocation());
        }
    }

    private void removeArtifactBundleEntry(Bundle bundle) {
        Artifact artifact = this.toArtifact(bundle.getLocation());
        if (artifact != null) {
            this.artifactBundleMap.remove(artifact);
            this.bundleIdArtifactMap.remove(bundle.getBundleId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<BundleDescription.ExportPackage> getExportPackagesInternal(Bundle bundle) {
        ServiceReference reference = null;
        try {
            PackageAdmin packageAdmin;
            ExportedPackage[] exportedPackages;
            reference = this.bundleContext.getServiceReference(PackageAdmin.class.getName());
            if (reference == null) {
                log.warn("No PackageAdmin service is found, fail to get export packages of " + bundle.getLocation());
                Set<BundleDescription.ExportPackage> set = Collections.emptySet();
                return set;
            }
            String exportPackageHeader = (String)bundle.getHeaders().get("Export-Package");
            HashMap<String, HeaderParser.HeaderElement> nameVersionExportPackageMap = new HashMap<String, HeaderParser.HeaderElement>();
            if (exportPackageHeader != null) {
                List headerElements = HeaderParser.parseHeader((String)exportPackageHeader);
                for (HeaderParser.HeaderElement headerElement : headerElements) {
                    String version = headerElement.getAttribute("version");
                    if (version == null) {
                        headerElement.addAttribute("version", "0.0.0");
                        nameVersionExportPackageMap.put(headerElement.getName() + "0.0.0", headerElement);
                        continue;
                    }
                    nameVersionExportPackageMap.put(headerElement.getName() + new Version(version).toString(), headerElement);
                }
            }
            if ((exportedPackages = (packageAdmin = (PackageAdmin)this.bundleContext.getService(reference)).getExportedPackages(bundle)) != null) {
                HashSet<BundleDescription.ExportPackage> exportPackageNames = new HashSet<BundleDescription.ExportPackage>();
                for (ExportedPackage exportedPackage : exportedPackages) {
                    HeaderParser.HeaderElement headerElement = (HeaderParser.HeaderElement)nameVersionExportPackageMap.get(exportedPackage.getName() + exportedPackage.getVersion());
                    if (headerElement == null) continue;
                    exportPackageNames.add(new BundleDescription.ExportPackage(headerElement.getName(), headerElement.getAttributes(), headerElement.getDirectives()));
                }
                HashSet<BundleDescription.ExportPackage> hashSet = exportPackageNames;
                return hashSet;
            }
            Set<BundleDescription.ExportPackage> set = Collections.emptySet();
            return set;
        }
        finally {
            if (reference != null) {
                this.bundleContext.ungetService(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginArtifactType getPluginMetadata(Bundle bundle) {
        InputStream in;
        PluginArtifactType pluginArtifactType;
        block9: {
            pluginArtifactType = null;
            in = null;
            try {
                File pluginMetadataFile;
                URL info = bundle.getEntry("META-INF/geronimo-plugin.xml");
                if (info != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("found geronimo-plugin.xml for bundle " + bundle);
                    }
                    in = info.openStream();
                } else if (bundle.getBundleContext() != null && (pluginMetadataFile = bundle.getBundleContext().getDataFile("geronimo-plugin.xml")).exists()) {
                    in = new FileInputStream(pluginMetadataFile);
                }
                if (in != null) {
                    PluginType pluginType = PluginXmlUtil.loadPluginMetadata(in);
                    pluginArtifactType = pluginType.getPluginArtifact().get(0);
                    break block9;
                }
                if (!log.isDebugEnabled()) break block9;
                log.debug("did not find geronimo-plugin.xml for bundle " + bundle);
            }
            catch (Throwable e) {
                try {
                    log.warn("Could not read geronimo metadata for bundle: " + bundle, e);
                }
                catch (Throwable throwable) {
                    IOUtils.close(in);
                    throw throwable;
                }
                IOUtils.close((Closeable)in);
            }
        }
        IOUtils.close((Closeable)in);
        return pluginArtifactType;
    }

    private void uninstall(Bundle bundle) {
        this.removeArtifactBundleEntry(bundle);
        this.dependentBundleIdsMap.remove(bundle.getBundleId());
        this.fullDependentBundleIdsMap.remove(bundle.getBundleId());
        this.pluginMap.remove(bundle.getBundleId());
    }

    private void installRepository(Bundle bundle) {
        if (this.repositoryAdmin != null) {
            URL info = bundle.getEntry("OSGI-INF/obr/repository.xml");
            if (info != null) {
                if (log.isDebugEnabled()) {
                    log.debug("found repository.xml for bundle " + bundle);
                }
                try {
                    this.repositoryAdmin.addRepository(info);
                }
                catch (Exception e) {
                    log.info("Error adding respository.xml for bundle " + bundle, (Throwable)e);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("did not find respository.xml for bundle " + bundle);
            }
        }
    }

    public PluginArtifactType getCachedPluginMetadata(Bundle bundle) {
        PluginArtifactType pluginArtifactType = this.pluginMap.get(bundle.getBundleId());
        if (pluginArtifactType == null && (pluginArtifactType = this.getPluginMetadata(bundle)) != null) {
            this.pluginMap.put(bundle.getBundleId(), pluginArtifactType);
        }
        return pluginArtifactType;
    }

    public void installed(Bundle bundle) {
        if (this.bundleIdArtifactMap.containsKey(bundle.getBundleId())) {
            return;
        }
        this.addArtifactBundleEntry(bundle);
        PluginArtifactType pluginArtifactType = this.getCachedPluginMetadata(bundle);
        if (pluginArtifactType == null) {
            return;
        }
        List<DependencyType> dependencies = pluginArtifactType.getDependency();
        HashSet<Long> dependentBundleIds = new HashSet<Long>();
        HashSet<Long> fullDependentBundleIds = new HashSet<Long>();
        try {
            for (DependencyType dependencyType : dependencies) {
                if (log.isDebugEnabled()) {
                    log.debug("Installing artifact: " + dependencyType);
                }
                Artifact artifact = dependencyType.toArtifact();
                if (this.artifactResolver != null) {
                    artifact = this.artifactResolver.resolveInClassLoader(artifact);
                }
                String location = this.locateBundle(artifact);
                try {
                    Set<Long> parentDependentBundleIds;
                    Bundle installedDependentBundle = this.bundleContext.installBundle(location);
                    long installedDependentBundleId = installedDependentBundle.getBundleId();
                    dependentBundleIds.add(installedDependentBundleId);
                    if (!fullDependentBundleIds.add(installedDependentBundleId) || (parentDependentBundleIds = this.fullDependentBundleIdsMap.get(installedDependentBundleId)) == null) continue;
                    fullDependentBundleIds.addAll(parentDependentBundleIds);
                }
                catch (BundleException e) {
                    log.warn("Could not install bundle for artifact: " + artifact, (Throwable)e);
                }
            }
            this.fullDependentBundleIdsMap.put(bundle.getBundleId(), fullDependentBundleIds);
            this.dependentBundleIdsMap.put(bundle.getBundleId(), dependentBundleIds);
        }
        catch (Exception e) {
            log.error("Could not install bundle dependency", (Throwable)e);
        }
    }

    private void starting(Bundle bundle) {
        PluginArtifactType pluginArtifactType = this.getCachedPluginMetadata(bundle);
        if (pluginArtifactType != null) {
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            List<DependencyType> dependencies = pluginArtifactType.getDependency();
            boolean dependencyHierarchyBuildingRequired = !this.dependentBundleIdsMap.containsKey(bundle.getBundleId());
            HashSet<Long> dependentBundleIds = null;
            HashSet<Long> fullDependentBundleIds = null;
            if (dependencyHierarchyBuildingRequired) {
                dependentBundleIds = new HashSet<Long>();
                fullDependentBundleIds = new HashSet<Long>();
            }
            try {
                for (DependencyType dependencyType : dependencies) {
                    if (log.isDebugEnabled()) {
                        log.debug("Starting artifact: " + dependencyType);
                    }
                    Artifact artifact = dependencyType.toArtifact();
                    if (this.artifactResolver != null) {
                        artifact = this.artifactResolver.resolveInClassLoader(artifact);
                    }
                    String location = this.locateBundle(artifact);
                    Bundle b = this.bundleContext.installBundle(location);
                    if (dependencyHierarchyBuildingRequired) {
                        Set<Long> parentDependentBundleIds;
                        long startingBundleId = b.getBundleId();
                        dependentBundleIds.add(startingBundleId);
                        if (fullDependentBundleIds.add(startingBundleId) && (parentDependentBundleIds = this.fullDependentBundleIdsMap.get(startingBundleId)) != null) {
                            fullDependentBundleIds.addAll(parentDependentBundleIds);
                        }
                    }
                    if (b.getState() == 32) continue;
                    bundles.add(b);
                }
                for (Bundle b : bundles) {
                    if (!BundleUtils.canStart((Bundle)b)) continue;
                    try {
                        b.start(1);
                    }
                    catch (BundleException e) {
                        log.warn("Could not start bundle: " + b, (Throwable)e);
                    }
                }
                if (dependencyHierarchyBuildingRequired) {
                    this.fullDependentBundleIdsMap.put(bundle.getBundleId(), fullDependentBundleIds);
                    this.dependentBundleIdsMap.put(bundle.getBundleId(), dependentBundleIds);
                }
            }
            catch (Exception e) {
                log.error("Could not install bundle dependecy", (Throwable)e);
            }
        }
    }

    private String locateBundle(Artifact configurationId) throws NoSuchConfigException, IOException, InvalidConfigException {
        if (System.getProperty("geronimo.build.car") == null) {
            return "mvn:" + configurationId.getGroupId() + "/" + configurationId.getArtifactId() + "/" + configurationId.getVersion() + ("jar".equals(configurationId.getType()) ? "" : "/" + configurationId.getType());
        }
        for (Repository repo : this.repositories) {
            if (!repo.contains(configurationId)) continue;
            return "reference:file://" + repo.getLocation(configurationId).getAbsolutePath();
        }
        throw new NoSuchConfigException(configurationId);
    }

    public void doStart() throws Exception {
        this.bundleContext.addBundleListener((BundleListener)this);
        this.respositoryAdminReference = this.bundleContext.getServiceReference(RepositoryAdmin.class.getName());
        this.repositoryAdmin = this.respositoryAdminReference == null ? null : (RepositoryAdmin)this.bundleContext.getService(this.respositoryAdminReference);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this.installed(bundle);
        }
        try {
            PluginArtifactType pluginArtifact = this.getCachedPluginMetadata(this.bundleContext.getBundle());
            if (pluginArtifact != null) {
                HashSet<Long> dependentBundleIds = new HashSet<Long>();
                for (DependencyType dependency : pluginArtifact.getDependency()) {
                    Bundle dependentBundle = this.getBundle(dependency.toArtifact());
                    if (dependentBundle == null) continue;
                    dependentBundleIds.add(dependentBundle.getBundleId());
                }
                long bundleId = this.bundleContext.getBundle().getBundleId();
                this.dependentBundleIdsMap.put(bundleId, dependentBundleIds);
                this.fullDependentBundleIdsMap.put(bundleId, dependentBundleIds);
            }
        }
        catch (Exception e) {
            log.error("Fail to read the dependency info from bundle " + this.bundleContext.getBundle().getLocation());
        }
    }

    public void doStop() throws Exception {
        if (this.respositoryAdminReference != null) {
            try {
                this.bundleContext.ungetService(this.respositoryAdminReference);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.pluginMap.clear();
        this.dependentBundleIdsMap.clear();
        this.fullDependentBundleIdsMap.clear();
        this.bundleExportPackagesMap.clear();
        this.artifactBundleMap.clear();
        this.bundleIdArtifactMap.clear();
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

