/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.serverinfo;

import java.io.File;
import java.net.URI;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.system.properties.JvmVendor;
import org.apache.geronimo.system.serverinfo.ServerConstants;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class BasicServerInfo
implements ServerInfo {
    private static final Logger LOG = LoggerFactory.getLogger(BasicServerInfo.class);
    public static final String SERVER_NAME_SYS_PROP = "org.apache.geronimo.server.name";
    public static final String SERVER_DIR_SYS_PROP = "org.apache.geronimo.server.dir";
    public static final String HOME_DIR_SYS_PROP = "org.apache.geronimo.home.dir";
    private final String baseDirectory;
    private final File base;
    private final File baseServer;
    private final URI baseURI;
    private final URI baseServerURI;

    public BasicServerInfo() {
        this.baseDirectory = null;
        this.base = null;
        this.baseServer = null;
        this.baseURI = null;
        this.baseServerURI = null;
    }

    public BasicServerInfo(String defaultBaseDirectory) throws Exception {
        this(defaultBaseDirectory, true, null);
    }

    public BasicServerInfo(String defaultBaseDirectory, boolean useSystemProperties) throws Exception {
        this(defaultBaseDirectory, useSystemProperties, null);
    }

    public BasicServerInfo(@ParamAttribute(name="baseDirectory") String defaultBaseDirectory, @ParamAttribute(name="useSystemProperties") boolean useSystemProperties, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) throws Exception {
        this.baseDirectory = useSystemProperties ? System.getProperty(HOME_DIR_SYS_PROP, defaultBaseDirectory) : defaultBaseDirectory;
        ServerConstants.getVersion();
        if (this.baseDirectory == null || this.baseDirectory.length() == 0) {
            String karafHome = System.getProperty("karaf.home");
            if (karafHome == null) {
                throw new IllegalStateException("NO karaf.home specified");
            }
            this.base = new File(karafHome);
        } else {
            this.base = new File(this.baseDirectory);
        }
        if (!this.base.isDirectory()) {
            throw new IllegalArgumentException("Base directory is not a directory: " + this.baseDirectory);
        }
        this.baseURI = this.base.toURI();
        this.baseServer = this.deriveBaseServer(useSystemProperties);
        this.baseServerURI = this.baseServer.toURI();
        if (useSystemProperties) {
            System.setProperty(HOME_DIR_SYS_PROP, this.base.getAbsolutePath());
            System.setProperty(SERVER_DIR_SYS_PROP, this.baseServer.getAbsolutePath());
        }
        String tmpDir = this.resolveServerPath(System.getProperty("java.io.tmpdir"));
        System.setProperty("java.io.tmpdir", tmpDir);
        this.logEnvInfo();
    }

    public BasicServerInfo(String baseDirectory, String serverName) {
        this.baseDirectory = baseDirectory;
        this.base = new File(baseDirectory);
        this.baseURI = this.base.toURI();
        this.baseServerURI = this.baseURI.resolve(serverName);
        this.baseServer = new File(this.baseServerURI);
        this.logEnvInfo();
    }

    @Override
    public String resolvePath(String filename) {
        return this.resolve(filename).getAbsolutePath();
    }

    @Override
    public String resolveServerPath(String filename) {
        return this.resolveServer(filename).getAbsolutePath();
    }

    @Override
    public File resolve(String filename) {
        return this.resolveWithBase(this.base, filename);
    }

    @Override
    public File resolveServer(String filename) {
        return this.resolveWithBase(this.baseServer, filename);
    }

    @Override
    public URI resolve(URI uri) {
        return this.baseURI.resolve(uri);
    }

    @Override
    public URI resolveServer(URI uri) {
        return this.baseServerURI.resolve(uri);
    }

    @Override
    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    @Override
    public String getCurrentBaseDirectory() {
        return this.base.getAbsolutePath();
    }

    @Override
    public String getVersion() {
        return ServerConstants.getVersion();
    }

    @Override
    public String getBuildDate() {
        return ServerConstants.getBuildDate();
    }

    @Override
    public String getBuildTime() {
        return ServerConstants.getBuildTime();
    }

    @Override
    public String getCopyright() {
        return ServerConstants.getCopyright();
    }

    private File resolveWithBase(File baseDir, String filename) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(baseDir, filename);
    }

    private File deriveBaseServer(boolean useSystemProperties) {
        File baseServerDir;
        String baseServerDirPath = System.getProperty(SERVER_DIR_SYS_PROP);
        if (!useSystemProperties || null == baseServerDirPath) {
            String serverName = System.getProperty(SERVER_NAME_SYS_PROP);
            baseServerDir = !useSystemProperties || null == serverName ? this.base : new File(this.base, serverName);
        } else {
            baseServerDir = new File(baseServerDirPath);
            if (!baseServerDir.isAbsolute()) {
                baseServerDir = new File(this.base, baseServerDirPath);
            }
        }
        if (!baseServerDir.isDirectory()) {
            throw new IllegalArgumentException("Server directory is not a directory: " + baseServerDir);
        }
        return baseServerDir;
    }

    private void logEnvInfo() {
        try {
            LOG.info("Runtime Information:");
            LOG.info("  Install directory = " + this.base);
            LOG.info("  Server directory  = " + this.baseServer);
            LOG.info("  JVM in use        = " + JvmVendor.getJvmInfo());
            LOG.info("Java Information:");
            LOG.info("  System property [java.runtime.name]     = " + System.getProperty("java.runtime.name"));
            LOG.info("  System property [java.runtime.version]  = " + System.getProperty("java.runtime.version"));
            LOG.info("  System property [os.name]               = " + System.getProperty("os.name"));
            LOG.info("  System property [os.version]            = " + System.getProperty("os.version"));
            LOG.info("  System property [sun.os.patch.level]    = " + System.getProperty("sun.os.patch.level"));
            LOG.info("  System property [os.arch]               = " + System.getProperty("os.arch"));
            LOG.info("  System property [java.class.version]    = " + System.getProperty("java.class.version"));
            LOG.info("  System property [locale]                = " + System.getProperty("user.language") + "_" + System.getProperty("user.country"));
            LOG.info("  System property [unicode.encoding]      = " + System.getProperty("sun.io.unicode.encoding"));
            LOG.info("  System property [file.encoding]         = " + System.getProperty("file.encoding"));
            LOG.info("  System property [java.vm.name]          = " + System.getProperty("java.vm.name"));
            LOG.info("  System property [java.vm.vendor]        = " + System.getProperty("java.vm.vendor"));
            LOG.info("  System property [java.vm.version]       = " + System.getProperty("java.vm.version"));
            LOG.info("  System property [java.vm.info]          = " + System.getProperty("java.vm.info"));
            LOG.info("  System property [java.home]             = " + System.getProperty("java.home"));
            LOG.info("  System property [java.classpath]        = " + System.getProperty("java.classpath"));
            LOG.info("  System property [java.library.path]     = " + System.getProperty("java.library.path"));
            LOG.info("  System property [java.endorsed.dirs]    = " + System.getProperty("java.endorsed.dirs"));
            LOG.info("  System property [java.ext.dirs]         = " + System.getProperty("java.ext.dirs"));
            LOG.info("  System property [sun.boot.class.path]   = " + System.getProperty("sun.boot.class.path"));
            LOG.info("----------------------------------------------");
        }
        catch (Exception e) {
            System.err.println("Exception caught during logging of Runtime Information.  Exception=" + e.toString());
        }
    }
}

