/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.configuration.ConfigurationOverride;
import org.apache.geronimo.system.configuration.condition.JexlExpressionParser;
import org.apache.geronimo.system.plugin.model.AttributesType;
import org.apache.geronimo.system.plugin.model.ModuleType;

class ServerOverride {
    private final Map<Artifact, ConfigurationOverride> configurations = new LinkedHashMap<Artifact, ConfigurationOverride>();
    private String comment;

    public ServerOverride() {
    }

    public ServerOverride(AttributesType attributes, JexlExpressionParser expressionParser) throws InvalidGBeanException {
        ConfigurationOverride module;
        for (ModuleType moduleType : attributes.getModule()) {
            module = new ConfigurationOverride(moduleType, expressionParser);
            this.addConfiguration(module);
        }
        for (ModuleType moduleType : attributes.getConfiguration()) {
            module = new ConfigurationOverride(moduleType, expressionParser);
            this.addConfiguration(module);
        }
        this.comment = attributes.getComment();
    }

    public ConfigurationOverride getConfiguration(Artifact configurationName) {
        return this.getConfiguration(configurationName, false);
    }

    public ConfigurationOverride getConfiguration(Artifact configurationName, boolean create) {
        ConfigurationOverride configuration = this.configurations.get(configurationName);
        if (create && configuration == null) {
            configuration = new ConfigurationOverride(configurationName, true);
            this.configurations.put(configurationName, configuration);
        }
        return configuration;
    }

    public void addConfiguration(ConfigurationOverride configuration) {
        this.configurations.put(configuration.getName(), configuration);
    }

    public void removeConfiguration(Artifact configurationName) {
        this.configurations.remove(configurationName);
    }

    public Map<Artifact, ConfigurationOverride> getConfigurations() {
        return this.configurations;
    }

    public Artifact[] queryConfigurations(Artifact query) {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        for (Artifact test : this.configurations.keySet()) {
            if (!query.matches(test)) continue;
            list.add(test);
        }
        return list.toArray(new Artifact[list.size()]);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public AttributesType writeXml() {
        AttributesType attributes = new AttributesType();
        if (this.comment != null) {
            attributes.setComment(this.comment);
        } else {
            StringBuilder cmnt = new StringBuilder();
            cmnt.append("\n");
            cmnt.append("==================================================================\n");
            cmnt.append("Warning - This XML file is regenerated by Geronimo whenever\n");
            cmnt.append("changes are made to Geronimo's configuration.\n");
            cmnt.append("\n");
            cmnt.append("If you want to include comments, create a single comment element\n");
            cmnt.append("element.  They are allowable at any level of the configuration.\n");
            cmnt.append("\n");
            cmnt.append("!!!! Do not edit this file while Geronimo is running !!!!\n");
            cmnt.append("==================================================================");
            attributes.setComment(cmnt.toString());
        }
        for (ConfigurationOverride module : this.configurations.values()) {
            ModuleType moduleType = module.writeXml();
            attributes.getModule().add(moduleType);
        }
        return attributes;
    }
}

