/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.system.jmx.MBeanServerNotFound;
import org.apache.geronimo.system.jmx.MBeanServerReference;
import org.osgi.framework.BundleContext;

@GBean
public class RealMBeanServerReference
implements MBeanServerReference,
GBeanLifecycle {
    private static final String GERONIMO_DEFAULT_DOMAIN = "geronimo";
    private BundleContext bundleContext;
    private MBeanServer mbeanServer;

    public RealMBeanServerReference(@ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamAttribute(name="usePlatformMBeanServer") boolean usePlatformMBeanServer, @ParamAttribute(name="mbeanServerId") String mbeanServerId) throws MBeanServerNotFound {
        this.bundleContext = bundleContext;
        if (usePlatformMBeanServer) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        } else {
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(mbeanServerId);
            if (servers.size() == 0) {
                this.mbeanServer = MBeanServerFactory.createMBeanServer(GERONIMO_DEFAULT_DOMAIN);
            } else {
                if (servers.size() > 1) {
                    throw new MBeanServerNotFound(servers.size() + " MBeanServers were found with the agent id " + mbeanServerId);
                }
                this.mbeanServer = servers.get(0);
            }
        }
    }

    public RealMBeanServerReference() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            if (!GERONIMO_DEFAULT_DOMAIN.equals(server.getDefaultDomain())) continue;
            this.mbeanServer = server;
            break;
        }
        if (this.mbeanServer == null) {
            this.mbeanServer = MBeanServerFactory.createMBeanServer(GERONIMO_DEFAULT_DOMAIN);
        }
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public void doFail() {
    }

    public void doStart() throws Exception {
        if (this.mbeanServer != null) {
            this.bundleContext.registerService(MBeanServer.class.getName(), (Object)this.mbeanServer, null);
        }
    }

    public void doStop() throws Exception {
    }
}

