/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration.condition;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlExpressionParser {
    private static final Logger log = LoggerFactory.getLogger(JexlExpressionParser.class);
    private final JexlEngine engine;
    private final JexlContext context;
    private final Map<String, Object> variables;

    public JexlExpressionParser(Map<String, Object> vars) {
        if (vars == null) {
            throw new IllegalArgumentException("vars");
        }
        this.engine = new JexlEngine();
        this.context = new MapContext(vars);
        this.variables = vars;
        log.trace("Using variables: {}", vars);
    }

    public JexlExpressionParser() {
        HashMap<String, Object> sysVars = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            sysVars.put((String)entry.getKey(), entry.getValue());
        }
        this.engine = new JexlEngine();
        this.context = new MapContext(sysVars);
        this.variables = sysVars;
        log.trace("Using variables: {}", sysVars);
    }

    public boolean hasVariable(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        return this.context.has(name);
    }

    public Object getVariable(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        return this.context.get(name);
    }

    public void setVariable(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        this.context.set(name, value);
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    protected Expression createExpression(String expression) throws Exception {
        Expression expr = this.engine.createExpression(expression);
        return expr;
    }

    public Object evaluate(String expression) throws Exception {
        if (expression == null) {
            throw new IllegalArgumentException("expression");
        }
        log.trace("Evaluating expression: {}", (Object)expression);
        Expression expr = this.createExpression(expression);
        Object obj = expr.evaluate(this.context);
        log.trace("Result: {}", obj);
        return obj;
    }

    public String parse(String input) {
        int prefixLoc;
        if (input == null) {
            throw new IllegalArgumentException("input");
        }
        log.trace("Parsing input: {}", (Object)input);
        StringBuilder buff = new StringBuilder();
        int cur = 0;
        while (cur < input.length() && (prefixLoc = input.indexOf("${", cur)) >= 0) {
            int suffixLoc = this.findBlockEnd(prefixLoc + 2, input);
            if (suffixLoc < 0) {
                throw new RuntimeException("Missing '}': " + input);
            }
            String expr = input.substring(prefixLoc + 2, suffixLoc);
            buff.append(input.substring(cur, prefixLoc));
            try {
                buff.append(this.evaluate(expr));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to evaluate: " + expr, e);
            }
            cur = suffixLoc + 1;
        }
        buff.append(input.substring(cur));
        log.trace("Parsed result: {}", (Object)buff);
        return buff.toString();
    }

    private int findBlockEnd(int pos, String input) {
        int nested = 0;
        while (pos < input.length()) {
            char ch = input.charAt(pos);
            if (ch == '{') {
                ++nested;
            } else if (ch == '}') {
                if (nested == 0) {
                    return pos;
                }
                --nested;
            }
            ++pos;
        }
        return -1;
    }

    public String parse(String input, boolean trim) {
        String output = this.parse(input);
        if (trim && output != null) {
            output = output.trim();
        }
        return output;
    }
}

