/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.geronimo.kernel.repository.Artifact;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="artifactType", propOrder={"groupId", "artifactId", "version", "type"})
public class ArtifactType
implements Serializable {
    private static final long serialVersionUID = 12343L;
    protected String groupId;
    @XmlElement(required=true)
    protected String artifactId;
    protected String version;
    protected String type;

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String value) {
        this.groupId = value;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String value) {
        this.artifactId = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactType that = (ArtifactType)o;
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public Artifact toArtifact() {
        return new Artifact(this.groupId, this.artifactId, this.version, this.type);
    }

    public static ArtifactType newArtifactType(Artifact artifact) {
        ArtifactType artifactType = new ArtifactType();
        artifactType.setGroupId(artifact.getGroupId());
        artifactType.setArtifactId(artifact.getArtifactId());
        if (artifact.getVersion() != null) {
            artifactType.setVersion(artifact.getVersion().toString());
        }
        artifactType.setType(artifact.getType());
        return artifactType;
    }
}

