/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.genesis.plugins.maven;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.codehaus.mojo.pluginsupport.ant.AntHelper;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Os;

public class InvokeMavenMojo
extends MojoSupport {
    private DirectoryScanner fileset = null;
    private String[] flags = null;
    private Map parameters = null;
    private String[] profiles = null;
    private String[] goals = null;
    protected AntHelper ant;
    protected MavenProject project = null;

    protected MavenProject getProject() {
        return this.project;
    }

    protected void init() throws MojoExecutionException, MojoFailureException {
        super.init();
        this.ant.setProject(this.getProject());
    }

    protected void doExecute() throws Exception {
        this.fileset.addDefaultExcludes();
        this.fileset.scan();
        String[] filenames = this.fileset.getIncludedFiles();
        if (filenames.length == 0) {
            throw new MojoExecutionException("At least one pom file must be included");
        }
        for (int i = 0; i < filenames.length; ++i) {
            this.invoke(new File(this.fileset.getBasedir(), filenames[i]));
        }
    }

    private void invoke(File pom) throws Exception {
        int i;
        if (!pom.exists()) {
            throw new MojoExecutionException("Missing pom file: " + pom);
        }
        this.log.info((CharSequence)("Invoking: " + pom));
        ExecTask exec = (ExecTask)this.ant.createTask("exec");
        exec.setExecutable(this.getMavenExecutable().getAbsolutePath());
        exec.setFailIfExecutionFails(true);
        exec.setFailonerror(true);
        if (this.flags != null) {
            for (i = 0; i < this.flags.length; ++i) {
                exec.createArg().setValue(this.flags[i]);
            }
        }
        if (this.parameters != null) {
            Iterator iter = this.parameters.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Object value = this.parameters.get(name);
                exec.createArg().setValue("-D" + name + "=" + value);
            }
        }
        if (this.profiles != null && this.profiles.length != 0) {
            StringBuffer buff = new StringBuffer("-P");
            for (int i2 = 0; i2 < this.profiles.length; ++i2) {
                buff.append(this.profiles[i2]);
                if (i2 + 1 >= this.profiles.length) continue;
                buff.append(",");
            }
            exec.createArg().setValue(buff.toString());
        }
        if (this.goals != null) {
            for (i = 0; i < this.goals.length; ++i) {
                exec.createArg().setValue(this.goals[i]);
            }
        }
        exec.createArg().setValue("-f");
        exec.createArg().setFile(pom);
        exec.createArg().setValue("--batch-mode");
        exec.createArg().setValue("--errors");
        exec.execute();
    }

    private File getMavenExecutable() throws MojoExecutionException, IOException {
        String path = System.getProperty("maven.home");
        if (path == null) {
            throw new MojoExecutionException("Missing maven.home system property");
        }
        File home = new File(path);
        File cmd = Os.isFamily((String)"windows") ? new File(home, "bin/mvn.bat") : new File(home, "bin/mvn");
        if (!(cmd = cmd.getCanonicalFile()).exists()) {
            throw new MojoExecutionException("Maven executable not found at: " + cmd);
        }
        return cmd;
    }
}

