/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.genesis.plugins.script;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyResourceLoader;
import groovy.lang.GroovyRuntimeException;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.genesis.MojoSupport;
import org.apache.geronimo.genesis.plugins.script.CodeSource;
import org.apache.geronimo.genesis.util.ArtifactItem;
import org.apache.geronimo.genesis.util.ExpressionParser;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class GroovyMojo
extends MojoSupport {
    private CodeSource source = null;
    private ArtifactItem[] classpath = null;
    private File[] scriptpath = null;
    private Map defaults;
    private Map properties;
    private MavenProject project = null;
    private ArtifactRepository artifactRepository = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected MavenProject getProject() {
        return this.project;
    }

    protected ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    protected void doExecute() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        Class type = this.loadGroovyClass(this.source);
        GroovyObject obj = (GroovyObject)type.newInstance();
        obj.setProperty("log", (Object)this.log);
        MavenProject delegate = new MavenProject(this.project){
            private Properties resolvedProperties;

            public Properties getProperties() {
                if (this.resolvedProperties == null) {
                    this.resolvedProperties = GroovyMojo.this.resolveProperties(GroovyMojo.this.project.getProperties());
                }
                return this.resolvedProperties;
            }
        };
        obj.setProperty("project", (Object)delegate);
        obj.setProperty("pom", (Object)delegate);
        if (debug) {
            this.log.debug((CharSequence)("Invoking run() on: " + obj));
        }
        try {
            obj.invokeMethod("run", (Object)new Object[0]);
        }
        catch (GroovyRuntimeException e) {
            Throwable cause;
            if (this.log.isDebugEnabled()) {
                this.log.error((CharSequence)"Groovy script execution failure", (Throwable)e);
            }
            if ((cause = e.getCause()) == null) {
                cause = e;
            }
            throw new MojoExecutionException(cause.getMessage(), cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadGroovyClass(CodeSource source) throws Exception {
        Class type;
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        boolean debug = this.log.isDebugEnabled();
        source.validate();
        GroovyClassLoader loader = this.createGroovyClassLoader();
        if (source.getBody() != null) {
            type = loader.parseClass(source.getBody());
        } else {
            URL url = source.getFile() != null ? source.getFile().toURL() : source.getUrl();
            if (debug) {
                this.log.debug((CharSequence)("Loading source from: " + url));
            }
            String fileName = new File(url.getFile()).getName();
            InputStream input = url.openConnection().getInputStream();
            try {
                type = loader.parseClass(input, fileName);
            }
            finally {
                input.close();
            }
        }
        return type;
    }

    private GroovyClassLoader createGroovyClassLoader() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        URL[] urls = this.getClasspath();
        URLClassLoader cl = new URLClassLoader(urls, parent);
        if (this.scriptpath != null) {
            this.log.debug((CharSequence)"Scriptpath:");
            for (int i = 0; i < this.scriptpath.length; ++i) {
                if (this.scriptpath[i] == null) {
                    throw new MojoExecutionException("Null element found in scriptpath at index: " + i);
                }
                if (!debug) continue;
                this.log.debug((CharSequence)("    " + this.scriptpath[i]));
            }
        }
        GroovyClassLoader loader = new GroovyClassLoader((ClassLoader)cl);
        loader.setResourceLoader(new GroovyResourceLoader(){

            public URL loadGroovySource(String classname) throws MalformedURLException {
                return GroovyMojo.this.resolveGroovyScript(classname);
            }
        });
        return loader;
    }

    private URL resolveGroovyScript(String classname) throws MalformedURLException {
        ClassLoader cl;
        URL url;
        String resource;
        if (!$assertionsDisabled && classname == null) {
            throw new AssertionError();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Resolving script for class: " + classname));
        }
        if (!(resource = classname.replace('.', '/')).startsWith("/")) {
            resource = "/" + resource;
        }
        resource = resource + ".groovy";
        if (this.scriptpath != null) {
            for (int i = 0; i < this.scriptpath.length; ++i) {
                if (!$assertionsDisabled && this.scriptpath[i] == null) {
                    throw new AssertionError();
                }
                File file = new File(this.scriptpath[i], resource);
                if (!file.exists()) continue;
                return file.toURL();
            }
        }
        if ((url = (cl = Thread.currentThread().getContextClassLoader()).getResource(resource)) == null) {
            File file;
            File script = this.source.getFile();
            if (script != null && (file = new File(script.getParentFile(), resource)).exists()) {
                return file.toURL();
            }
        } else {
            return url;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Unable to resolve script for class: " + classname));
        }
        return null;
    }

    private URL[] getClasspath() throws DependencyResolutionRequiredException, MalformedURLException, MojoExecutionException {
        int i;
        ArrayList<URL> list = new ArrayList<URL>();
        List classpathFiles = this.project.getCompileClasspathElements();
        for (i = 0; i < classpathFiles.size(); ++i) {
            list.add(new File((String)classpathFiles.get(i)).toURL());
        }
        if (this.classpath != null) {
            for (i = 0; i < this.classpath.length; ++i) {
                Artifact artifact = this.getArtifact(this.classpath[i]);
                list.add(artifact.getFile().toURL());
            }
        }
        URL[] urls = list.toArray(new URL[list.size()]);
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)"Classpath:");
            for (int i2 = 0; i2 < urls.length; ++i2) {
                this.log.debug((CharSequence)("    " + urls[i2]));
            }
        }
        return urls;
    }

    private Properties resolveProperties(Properties source) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        Properties dprops = new Properties();
        if (this.defaults != null) {
            dprops.putAll((Map<?, ?>)this.defaults);
        }
        Properties sprops = new Properties(dprops);
        sprops.putAll((Map<?, ?>)System.getProperties());
        Properties props = new Properties(sprops);
        if (this.properties != null) {
            props.putAll((Map<?, ?>)this.properties);
        }
        HashMap<String, MavenProject> vars = new HashMap<String, MavenProject>();
        vars.put("project", this.project);
        ExpressionParser parser = new ExpressionParser(vars);
        Iterator<Object> iter = source.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            props.put(name, parser.parse(source.getProperty(name)));
        }
        return props;
    }

    static {
        $assertionsDisabled = !GroovyMojo.class.desiredAssertionStatus();
    }
}

