/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.genesis.plugins.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.pluginsupport.MojoSupport;

public class VerifyLegalFilesMojo
extends MojoSupport {
    private static final String[] DEFAULT_REQUIRED_FILES;
    private boolean strict;
    private String[] requiredFiles = DEFAULT_REQUIRED_FILES;
    protected MavenProject project = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void doExecute() throws Exception {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        artifacts.add(this.project.getArtifact());
        artifacts.addAll(this.project.getAttachedArtifacts());
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            File file = artifact.getFile();
            if (file == null) {
                this.log.debug((CharSequence)("Skipping artifact; no attached file: " + artifact));
                continue;
            }
            try {
                ZipFile zfile = new ZipFile(file);
                this.log.info((CharSequence)("Checking legal files in: " + file.getName()));
                if (this.containsLegalFiles(zfile)) continue;
                String msg = "Artifact does not contain any legal files: " + file.getName();
                if (this.strict) {
                    throw new MojoExecutionException(msg);
                }
                this.log.warn((CharSequence)msg);
            }
            catch (ZipException e) {
                this.log.debug((CharSequence)("Failed to check file for legal muck; ignoring: " + file), (Throwable)e);
            }
        }
    }

    private boolean containsLegalFiles(ZipFile file) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        return this.containsLegalFiles(file, "META-INF") || this.containsLegalFiles(file, this.project.getArtifactId() + "-" + this.project.getVersion());
    }

    private boolean containsLegalFiles(ZipFile file, String basedir) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && basedir == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.requiredFiles.length; ++i) {
            String filename = basedir + "/" + this.requiredFiles[i];
            this.log.debug((CharSequence)("Checking for: " + filename));
            ZipEntry entry = file.getEntry(filename);
            if (entry != null) continue;
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !VerifyLegalFilesMojo.class.desiredAssertionStatus();
        DEFAULT_REQUIRED_FILES = new String[]{"LICENSE.txt", "NOTICE.txt"};
    }
}

