/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.jaxrs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.geronimo.microprofile.impl.jwtauth.config.GeronimoJwtAuthConfig;
import org.apache.geronimo.microprofile.impl.jwtauth.io.PropertiesLoader;

@ApplicationScoped
class GroupMapper {
    @Inject
    private GeronimoJwtAuthConfig config;
    private final Map<String, Collection<String>> mapping = new HashMap<String, Collection<String>>();

    GroupMapper() {
    }

    @PostConstruct
    private void init() {
        Optional.ofNullable(this.config.read("groups.mapping", null)).map(String::trim).filter(s -> !s.isEmpty()).map(PropertiesLoader::load).ifPresent(props -> props.stringPropertyNames().forEach(k -> {
            Collection cfr_ignored_0 = this.mapping.put((String)k, Stream.of(props.getProperty((String)k).split(",")).map(String::trim).collect(Collectors.toSet()));
        }));
    }

    Collection<String> map(String tokenName) {
        return Optional.ofNullable(this.mapping.get(tokenName)).orElse(Collections.singletonList(tokenName));
    }
}

