/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.jwt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.geronimo.microprofile.impl.jwtauth.config.GeronimoJwtAuthConfig;
import org.apache.geronimo.microprofile.impl.jwtauth.io.PropertiesLoader;

@ApplicationScoped
public class KidMapper {
    @Inject
    private GeronimoJwtAuthConfig config;
    private final ConcurrentMap<String, String> keyMapping = new ConcurrentHashMap<String, String>();
    private final Map<String, Collection<String>> issuerMapping = new HashMap<String, Collection<String>>();
    private String defaultKey;
    private Set<String> defaultIssuers;

    @PostConstruct
    private void init() {
        Optional.ofNullable(this.config.read("kids.key.mapping", null)).map(String::trim).filter(s -> !s.isEmpty()).map(PropertiesLoader::load).ifPresent(props -> props.stringPropertyNames().forEach(k -> this.keyMapping.put((String)k, this.loadKey(props.getProperty((String)k)))));
        Optional.ofNullable(this.config.read("kids.issuer.mapping", null)).map(String::trim).filter(s -> !s.isEmpty()).map(PropertiesLoader::load).ifPresent(props -> props.stringPropertyNames().forEach(k -> this.issuerMapping.put((String)k, Stream.of(props.getProperty((String)k).split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet()))));
        this.defaultIssuers = Optional.ofNullable(this.config.read("org.eclipse.microprofile.authentication.JWT.issuers", null)).map(s -> Stream.of(s.split(",")).map(String::trim).filter(it -> !it.isEmpty()).collect(Collectors.toSet())).orElseGet(HashSet::new);
        Optional.ofNullable(this.config.read("issuer.default", this.config.read("mp.jwt.verify.issuer", null))).ifPresent(this.defaultIssuers::add);
        this.defaultKey = this.config.read("public-key.default", this.config.read("mp.jwt.verify.publickey", null));
    }

    String loadKey(String property) {
        String value = (String)this.keyMapping.get(property);
        if (value == null) {
            value = this.tryLoad(property);
            if (value != null && !property.equals(value)) {
                this.keyMapping.putIfAbsent(property, value);
            } else if (this.defaultKey != null) {
                value = this.defaultKey;
            }
        }
        return value;
    }

    Collection<String> loadIssuers(String property) {
        return this.issuerMapping.getOrDefault(property, this.defaultIssuers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String tryLoad(String value) {
        File file = new File(value);
        if (file.exists()) {
            try {
                return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining("\n"));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(value);){
            if (stream == null) return value;
            String string = new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

