/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.common;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.json.bind.annotation.JsonbTransient;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Snapshot;

public class HistogramImpl
implements Histogram {
    private static final double ALPHA = Double.parseDouble(System.getProperty("geronimo.metrics.storage.alpha", "0.015"));
    private static final int BUCKET_SIZE = Integer.getInteger("geronimo.metrics.storage.size", 1024);
    private static final long REFRESH_INTERVAL = TimeUnit.HOURS.toNanos(1L);
    private static final Value[] EMPTY_ARRAY = new Value[0];
    private final String unit;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicLong count = new AtomicLong();
    private final ConcurrentSkipListMap<Double, Value> bucket = new ConcurrentSkipListMap();
    private final AtomicLong nextRefreshTime = new AtomicLong(System.nanoTime() + REFRESH_INTERVAL);
    private volatile long startTime = this.nowSec();

    public HistogramImpl(String unit) {
        this.unit = unit;
    }

    public void update(int value) {
        this.update((long)value);
    }

    public synchronized void update(long value) {
        this.add(value);
    }

    public long getCount() {
        return this.count.get();
    }

    @JsonbTransient
    public Snapshot getSnapshot() {
        return this.snapshot();
    }

    public String getUnit() {
        return this.unit;
    }

    public double getP50() {
        return this.getSnapshot().getMedian();
    }

    public double getP75() {
        return this.getSnapshot().get75thPercentile();
    }

    public double getP95() {
        return this.getSnapshot().get95thPercentile();
    }

    public double getP98() {
        return this.getSnapshot().get98thPercentile();
    }

    public double getP99() {
        return this.getSnapshot().get99thPercentile();
    }

    public double getP999() {
        return this.getSnapshot().get999thPercentile();
    }

    public long getMax() {
        return this.getSnapshot().getMax();
    }

    public double getMean() {
        return this.getSnapshot().getMean();
    }

    public long getMin() {
        return this.getSnapshot().getMin();
    }

    public double getStddev() {
        return this.getSnapshot().getStdDev();
    }

    private long nowSec() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long value) {
        this.ensureUpToDate();
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            Value sample = new Value(value, Math.exp(ALPHA * (double)(this.nowSec() - this.startTime)));
            double priority = sample.weight / Math.random();
            long size = this.count.incrementAndGet();
            if (size <= (long)BUCKET_SIZE) {
                this.bucket.put(priority, sample);
            } else {
                double first = this.bucket.firstKey();
                if (first < priority && this.bucket.putIfAbsent(priority, sample) == null) {
                    while (this.bucket.remove(first) == null) {
                        first = this.bucket.firstKey();
                    }
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureUpToDate() {
        long next = this.nextRefreshTime.get();
        long now = System.nanoTime();
        if (now < next) {
            return;
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            if (this.nextRefreshTime.compareAndSet(next, now + REFRESH_INTERVAL)) {
                long oldStartTime = this.startTime;
                this.startTime = this.nowSec();
                double updateFactor = Math.exp(-ALPHA * (double)(this.startTime - oldStartTime));
                if (updateFactor != 0.0) {
                    this.bucket.putAll(new ArrayList(this.bucket.keySet()).stream().collect(Collectors.toMap(k -> k * updateFactor, k -> {
                        Value previous = this.bucket.remove(k);
                        return new Value(previous.value, previous.weight * updateFactor);
                    })));
                    this.count.set(this.bucket.size());
                } else {
                    this.bucket.clear();
                    this.count.set(0L);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public Snapshot snapshot() {
        this.ensureUpToDate();
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            SnapshotImpl snapshotImpl = new SnapshotImpl(this.bucket.values().toArray(EMPTY_ARRAY));
            return snapshotImpl;
        }
        finally {
            lock.unlock();
        }
    }

    private static class SnapshotImpl
    extends Snapshot {
        private final Value[] values;
        private Value[] sorted;

        private SnapshotImpl(Value[] values) {
            this.values = values;
        }

        public int size() {
            return this.values.length;
        }

        public long[] getValues() {
            return this.values(this.sorted()).toArray();
        }

        public long getMax() {
            if (this.values.length == 0) {
                return 0L;
            }
            if (this.sorted != null) {
                return this.sorted[this.sorted.length - 1].value;
            }
            return this.values(this.values).max().orElse(0L);
        }

        public long getMin() {
            if (this.values.length == 0) {
                return 0L;
            }
            if (this.sorted != null) {
                return this.sorted[0].value;
            }
            return this.values(this.values).min().orElse(0L);
        }

        public double getMean() {
            if (this.values.length == 0) {
                return 0.0;
            }
            return (double)this.values(this.values).sum() * 1.0 / (double)this.values.length;
        }

        public double getStdDev() {
            if (this.values.length <= 1) {
                return 0.0;
            }
            double mean = this.getMean();
            double sumWeight = Stream.of(this.values).mapToDouble(i -> ((Value)i).weight).sum();
            return Math.sqrt(Stream.of(this.values).mapToDouble(v -> Math.pow((double)((Value)v).value - mean, 2.0) * (((Value)v).weight / sumWeight)).sum());
        }

        public void dump(OutputStream output) {
            this.values(this.sorted()).forEach(v -> {
                try {
                    output.write((v + "\n").getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }

        public double getValue(double quantile) {
            if (!(quantile >= 0.0) && !(quantile <= 1.0)) {
                throw new IllegalArgumentException("Quantile " + quantile + " is invalid");
            }
            if (this.values.length == 0) {
                return 0.0;
            }
            if (this.values.length == 1) {
                return this.values[0].value;
            }
            int idx = (int)Math.floor((double)(this.values.length - 1) * quantile);
            return this.sorted()[idx].value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Value[] sorted() {
            if (this.sorted == null) {
                SnapshotImpl snapshotImpl = this;
                synchronized (snapshotImpl) {
                    if (this.sorted == null) {
                        this.sorted = new Value[this.values.length];
                        System.arraycopy(this.values, 0, this.sorted, 0, this.values.length);
                        Arrays.sort(this.sorted, Comparator.comparing(i -> ((Value)i).value));
                    }
                }
            }
            return this.sorted;
        }

        private LongStream values(Value[] values) {
            return Stream.of(values).mapToLong(i -> ((Value)i).value);
        }
    }

    private static final class Value {
        private final long value;
        private final double weight;

        private Value(long value, double weight) {
            this.value = value;
            this.weight = weight;
        }
    }
}

