/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.common.expdecay;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class ExponentialMovingAverage {
    private static final double INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private static final double RATE_RATIO = TimeUnit.SECONDS.toNanos(1L);
    private final LongAdder accumulator = new LongAdder();
    private final double alpha;
    private volatile double rate = 0.0;

    private ExponentialMovingAverage(double alpha) {
        this.alpha = alpha;
    }

    public double rate() {
        return this.rate * RATE_RATIO;
    }

    public void add(long n) {
        this.accumulator.add(n);
    }

    public void refresh() {
        double newRate;
        long count = this.accumulator.sumThenReset();
        double instantRate = (double)count / INTERVAL;
        this.rate = newRate = this.rate == 0.0 ? instantRate : this.nextRate(instantRate);
    }

    private double nextRate(double instantRate) {
        return this.rate + this.alpha * (instantRate - this.rate);
    }

    public static ExponentialMovingAverage forMinutes(int minutes) {
        return new ExponentialMovingAverage(Math.exp(-0.08333333333333333 / (double)minutes));
    }
}

