/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.extension.tomcat;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import org.apache.geronimo.microprofile.metrics.extension.common.MicroprofileMetricsAdapter;
import org.apache.geronimo.microprofile.metrics.extension.common.RegistryTypeLiteral;
import org.apache.geronimo.microprofile.metrics.extension.tomcat.TomcatRegistrar;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class TomcatExtension
implements Extension {
    private TomcatRegistrar registrar;

    void afterValidation(@Observes AfterDeploymentValidation validation, BeanManager beanManager) {
        MetricRegistry.Type registryType = MetricRegistry.Type.valueOf((String)System.getProperty("geronimo.metrics.tomcat.registry.type", "BASE"));
        Set beans = beanManager.getBeans(MetricRegistry.class, new Annotation[]{new RegistryTypeLiteral(registryType)});
        MetricRegistry registry = (MetricRegistry)MetricRegistry.class.cast(beanManager.getReference(beanManager.resolve(beans), MetricRegistry.class, beanManager.createCreationalContext(null)));
        MicroprofileMetricsAdapter adapter = new MicroprofileMetricsAdapter(registry);
        this.registrar = new TomcatRegistrar(adapter.registrer(), adapter.unregistrer());
        this.registrar.start();
    }

    void beforeShutdown(@Observes BeforeShutdown beforeShutdown) {
        if (this.registrar != null) {
            this.registrar.stop();
        }
    }
}

