/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.extension.tomcat;

import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.AbstractProtocol;
import org.apache.geronimo.microprofile.metrics.extension.common.Definition;
import org.apache.geronimo.microprofile.metrics.extension.common.ThrowingSupplier;
import org.apache.geronimo.microprofile.metrics.extension.tomcat.ServerRegistration;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public class TomcatRegistrar {
    private final Consumer<Definition> onRegister;
    private final Consumer<Definition> onUnregister;

    public TomcatRegistrar(Consumer<Definition> onRegister, Consumer<Definition> onUnregister) {
        this.onRegister = onRegister;
        this.onUnregister = onUnregister;
    }

    public void start() {
        HashSet ports = new HashSet();
        Stream.concat(this.findServers(), StreamSupport.stream(ServiceLoader.load(ServerRegistration.class).spliterator(), false).map(Supplier::get)).filter(Objects::nonNull).distinct().map(Server::findServices).flatMap(Stream::of).map(Service::findConnectors).flatMap(Stream::of).map(Connector::getProtocolHandler).filter(AbstractProtocol.class::isInstance).map(AbstractProtocol.class::cast).forEach(protocol -> {
            java.util.concurrent.ThreadPoolExecutor pool;
            Executor executor = protocol.getExecutor();
            int port = protocol.getPort();
            if (!ports.add(port)) {
                return;
            }
            String prefix = "server.executor.port_" + port + ".";
            if (java.util.concurrent.ThreadPoolExecutor.class.isInstance(executor)) {
                pool = (java.util.concurrent.ThreadPoolExecutor)java.util.concurrent.ThreadPoolExecutor.class.cast(executor);
                this.addGauge(prefix + "queue.size", "Connector Queue Size", (ThrowingSupplier<Number>)((ThrowingSupplier)() -> pool.getQueue().size()));
                this.addGauge(prefix + "active", "Connector Active Count", (ThrowingSupplier<Number>)((ThrowingSupplier)pool::getActiveCount));
                this.addGauge(prefix + "tasks.completed", "Connector Completed Tasks", (ThrowingSupplier<Number>)((ThrowingSupplier)pool::getCompletedTaskCount));
                this.addGauge(prefix + "tasks.count", "Connector Tasks Count", (ThrowingSupplier<Number>)((ThrowingSupplier)pool::getTaskCount));
            }
            if (ThreadPoolExecutor.class.isInstance(executor)) {
                pool = (ThreadPoolExecutor)ThreadPoolExecutor.class.cast(executor);
                this.addGauge(prefix + "submitted", "Connector Submitted Tasks", (ThrowingSupplier<Number>)((ThrowingSupplier)() -> ((ThreadPoolExecutor)pool).getSubmittedCount()));
            }
        });
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.queryMBeans(new ObjectName("*:type=ThreadPool,*"), null).stream().map(ObjectInstance::getObjectName).filter(it -> ports.add(this.getPort((ObjectName)it))).forEach(name -> {
                String prefix = "server.executor.port_" + this.getPort((ObjectName)name) + ".";
                this.addGauge(prefix + "thread.count", "Connector Thread Count", (ThrowingSupplier<Number>)((ThrowingSupplier)() -> (Number)Number.class.cast(server.getAttribute((ObjectName)name, "currentThreadCount"))));
                this.addGauge(prefix + "active", "Connector Thread Busy", (ThrowingSupplier<Number>)((ThrowingSupplier)() -> (Number)Number.class.cast(server.getAttribute((ObjectName)name, "currentThreadsBusy"))));
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getPort(ObjectName it) {
        String name = it.getKeyPropertyList().get("name");
        int sep = name.lastIndexOf(45);
        String port = name.substring(sep + 1);
        return Integer.parseInt(port);
    }

    private void addGauge(String name, String descriptionAndDisplayName, ThrowingSupplier<Number> supplier) {
        this.onRegister.accept(new Definition(name, descriptionAndDisplayName, descriptionAndDisplayName, "count", supplier));
    }

    private Stream<Server> findServers() {
        return Stream.of(this.findMeecrowave(), this.findTomEE());
    }

    private Server findTomEE() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> tomcatHelper = loader.loadClass("org.apache.tomee.loader.TomcatHelper");
            return (Server)Server.class.cast(tomcatHelper.getMethod("", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Error | Exception e) {
            return null;
        }
    }

    private Server findMeecrowave() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> meecrowaveClass = loader.loadClass("org.apache.meecrowave.Meecrowave");
            Class<?> cdi = loader.loadClass("javax.enterprise.inject.spi.CDI");
            Object current = cdi.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            Object meecrowaveInstance = cdi.getMethod("select", Class.class, Annotation[].class).invoke(current, meecrowaveClass, new Annotation[0]);
            Object meecrowave = meecrowaveInstance.getClass().getMethod("get", new Class[0]).invoke(meecrowaveInstance, new Object[0]);
            Object tomcat = meecrowave.getClass().getMethod("getTomcat", new Class[0]).invoke(meecrowave, new Object[0]);
            return (Server)Server.class.cast(tomcat.getClass().getMethod("getServer", new Class[0]).invoke(tomcat, new Object[0]));
        }
        catch (Error | Exception e) {
            return null;
        }
    }

    public void stop() {
    }
}

