/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.geronimo.microprofile.openapi.impl.model;

import java.util.LinkedHashMap;
import java.util.Map;

import javax.enterprise.inject.Vetoed;
import javax.json.bind.annotation.JsonbTransient;

import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;

@Vetoed
public class CallbackImpl extends APIMap<String, PathItem> implements Callback {

    private Extensible _extensible = new ExtensibleImpl();

    private String _ref;

    @Override
    @JsonbTransient
    public Map<String, Object> getExtensions() {
        return _extensible.getExtensions();
    }

    @Override
    public void setExtensions(final Map<String, Object> extensions) {
        _extensible.setExtensions(extensions);
    }

    @Override
    public Callback addExtension(final String name, final Object value) {
        _extensible.addExtension(name, value);
        return this;
    }

    @Override
    public void removeExtension(final String name) {
        _extensible.removeExtension(name);
    }

    @Override
    public Callback addPathItem(final String name, final PathItem item) {
        if (item != null) {
            super.put(name, item);
        }
        return this;
    }

    @Override
    public void removePathItem(final String name) {
        remove(name);
    }

    @Override
    public Map<String, PathItem> getPathItems() {
        return new LinkedHashMap<>(this);
    }

    @Override
    public void setPathItems(final Map<String, PathItem> items) {
        clear();
        putAll(items);
    }

    @Override
    public String getRef() {
        return _ref;
    }

    @Override
    public void setRef(final String _ref) {
        this._ref = _ref.startsWith("#") ? _ref : ("#/components/callbacks/" + _ref);
    }

    @Override
    public Callback ref(final String _ref) {
        setRef(_ref);
        return this;
    }
}
