/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.impl.processor;

import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.Vetoed;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.geronimo.microprofile.openapi.config.GeronimoOpenAPIConfig;
import org.apache.geronimo.microprofile.openapi.impl.model.APIResponseImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.APIResponsesImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.CallbackImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.ComponentsImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.ContactImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.ContentImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.EncodingImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.ExampleImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.ExternalDocumentationImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.HeaderImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.InfoImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.LicenseImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.LinkImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.MediaTypeImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.OAuthFlowImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.OAuthFlowsImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.OperationImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.ParameterImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.PathItemImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.PathsImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.RequestBodyImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.ScopesImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.SecurityRequirementImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.SecuritySchemeImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.ServerImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.ServerVariableImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.ServerVariablesImpl;
import org.apache.geronimo.microprofile.openapi.impl.model.TagImpl;
import org.apache.geronimo.microprofile.openapi.impl.processor.AnnotatedMethodElement;
import org.apache.geronimo.microprofile.openapi.impl.processor.AnnotatedTypeElement;
import org.apache.geronimo.microprofile.openapi.impl.processor.SchemaProcessor;
import org.apache.geronimo.microprofile.openapi.impl.processor.reflect.FieldElement;
import org.apache.geronimo.microprofile.openapi.impl.processor.spi.NamingStrategy;
import org.eclipse.microprofile.openapi.annotations.Components;
import org.eclipse.microprofile.openapi.annotations.ExternalDocumentation;
import org.eclipse.microprofile.openapi.annotations.OpenAPIDefinition;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.callbacks.Callback;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterStyle;
import org.eclipse.microprofile.openapi.annotations.enums.SecuritySchemeIn;
import org.eclipse.microprofile.openapi.annotations.enums.SecuritySchemeType;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.info.Contact;
import org.eclipse.microprofile.openapi.annotations.info.License;
import org.eclipse.microprofile.openapi.annotations.links.Link;
import org.eclipse.microprofile.openapi.annotations.links.LinkParameter;
import org.eclipse.microprofile.openapi.annotations.media.Encoding;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameters;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.security.OAuthFlows;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.annotations.servers.ServerVariable;
import org.eclipse.microprofile.openapi.annotations.servers.Servers;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.eclipse.microprofile.openapi.annotations.tags.Tags;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.Scopes;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;

@Vetoed
public class AnnotationProcessor {
    private final GeronimoOpenAPIConfig config;
    private final SchemaProcessor schemaProcessor;
    private final NamingStrategy operationNamingStrategy;
    private final JsonReaderFactory jsonReaderFactory;
    private final Collection<String> operationId = new HashSet<String>();

    public AnnotationProcessor(GeronimoOpenAPIConfig config, NamingStrategy strategy, JsonReaderFactory factory) {
        this.config = config;
        this.schemaProcessor = new SchemaProcessor();
        this.operationNamingStrategy = strategy;
        this.jsonReaderFactory = factory != null ? factory : Json.createReaderFactory(Collections.emptyMap());
    }

    public void processClass(String basePath, OpenAPI api, AnnotatedElement annotatedType, Stream<AnnotatedMethodElement> methods) {
        Path path = annotatedType.getAnnotation(Path.class);
        if (api.getPaths() == null) {
            api.paths((Paths)new PathsImpl());
        }
        Stream.of(annotatedType.getAnnotationsByType(Tag.class)).map(t -> Optional.of(t.ref()).filter(it -> !it.isEmpty()).flatMap(ref -> api.getTags().stream().filter(it -> it.getName().equals(ref)).findFirst()).orElseGet(() -> this.mapTag((Tag)t))).forEach(arg_0 -> ((OpenAPI)api).addTag(arg_0));
        Stream.of(annotatedType.getAnnotationsByType(org.eclipse.microprofile.openapi.annotations.security.SecurityScheme.class)).forEach(s -> {
            if (api.getComponents() == null) {
                api.setComponents((org.eclipse.microprofile.openapi.models.Components)new ComponentsImpl());
            }
            api.getComponents().addSecurityScheme(s.securitySchemeName(), this.mapSecurityScheme((org.eclipse.microprofile.openapi.annotations.security.SecurityScheme)s));
        });
        methods.filter(m -> Stream.of(m.getAnnotations()).anyMatch(it -> it.annotationType().getName().startsWith("javax.ws.rs."))).forEach(m -> {
            Path nestedPath = m.getAnnotation(Path.class);
            String completePath = this.buildPath(basePath, path, nestedPath);
            if (m.isAnnotationPresent(GET.class)) {
                this.getPathItem(api, completePath).setGET(this.buildOperation(api, (AnnotatedMethodElement)m, annotatedType, "GET", completePath));
            } else if (m.isAnnotationPresent(PUT.class)) {
                this.getPathItem(api, completePath).setPUT(this.buildOperation(api, (AnnotatedMethodElement)m, annotatedType, "PUT", completePath));
            } else if (m.isAnnotationPresent(POST.class)) {
                this.getPathItem(api, completePath).setPOST(this.buildOperation(api, (AnnotatedMethodElement)m, annotatedType, "POST", completePath));
            } else if (m.isAnnotationPresent(HEAD.class)) {
                this.getPathItem(api, completePath).setHEAD(this.buildOperation(api, (AnnotatedMethodElement)m, annotatedType, "HEAD", completePath));
            } else if (m.isAnnotationPresent(OPTIONS.class)) {
                this.getPathItem(api, completePath).setOPTIONS(this.buildOperation(api, (AnnotatedMethodElement)m, annotatedType, "OPTIONS", completePath));
            } else if (m.isAnnotationPresent(DELETE.class)) {
                this.getPathItem(api, completePath).setDELETE(this.buildOperation(api, (AnnotatedMethodElement)m, annotatedType, "DELETE", completePath));
            } else {
                Stream.of(m.getAnnotations()).filter(it -> it.annotationType().isAnnotationPresent(HttpMethod.class)).findFirst().ifPresent(http -> {
                    String mtd = http.annotationType().getAnnotation(HttpMethod.class).value();
                    if ("TRACE".equals(mtd)) {
                        this.getPathItem(api, completePath).setTRACE(this.buildOperation(api, (AnnotatedMethodElement)m, annotatedType, mtd, completePath));
                    } else if ("PATCH".equals(mtd)) {
                        this.getPathItem(api, completePath).setPATCH(this.buildOperation(api, (AnnotatedMethodElement)m, annotatedType, mtd, completePath));
                    }
                });
            }
        });
    }

    public void processApplication(OpenAPI api, AnnotatedElement type) {
        Optional.ofNullable(type.getAnnotation(OpenAPIDefinition.class)).ifPresent(def -> this.processDefinition(api, (OpenAPIDefinition)def));
        Optional<String> servers = Optional.ofNullable(this.config.read("mp.openapi.servers", null));
        if (servers.isPresent()) {
            api.servers(this.mapConfiguredServers(servers.get()));
        } else {
            Stream.of(type.getAnnotationsByType(org.eclipse.microprofile.openapi.annotations.servers.Server.class)).forEach(server -> api.addServer(this.mapServer((org.eclipse.microprofile.openapi.annotations.servers.Server)server)));
        }
        Stream.of(type.getAnnotationsByType(Extension.class)).forEach(ext -> {
            OpenAPI cfr_ignored_0 = (OpenAPI)api.addExtension(ext.name(), (Object)ext.value());
        });
        Stream.of(type.getAnnotationsByType(ExternalDocumentation.class)).forEach(doc -> api.setExternalDocs(this.mapExternalDocumentation((ExternalDocumentation)doc)));
        Stream.of(type.getAnnotationsByType(Tag.class)).forEach(tag -> api.addTag(this.mapTag((Tag)tag)));
        Stream.of(type.getAnnotationsByType(SecurityRequirement.class)).forEach(security -> {
            if (api.getSecurity() == null) {
                api.setSecurity(new ArrayList(1));
            }
            api.addSecurityRequirement(this.mapSecurity((SecurityRequirement)security));
        });
        Stream.of(type.getAnnotationsByType(org.eclipse.microprofile.openapi.annotations.security.SecurityScheme.class)).forEach(scheme -> {
            if (api.getComponents().getSecuritySchemes() == null) {
                api.getComponents().setSecuritySchemes(new HashMap());
            }
            api.getComponents().addSecurityScheme(scheme.securitySchemeName(), this.mapSecurityScheme((org.eclipse.microprofile.openapi.annotations.security.SecurityScheme)scheme));
        });
    }

    private List<Server> mapConfiguredServers(String servers) {
        return Stream.of(servers.split(",")).map(String::trim).filter(v -> !v.isEmpty()).map(server -> new ServerImpl().url((String)server)).collect(Collectors.toList());
    }

    private org.eclipse.microprofile.openapi.models.Operation buildOperation(OpenAPI api, AnnotatedMethodElement m, AnnotatedElement declaring, String httpVerb, String path) {
        Optional<Operation> opOpt = Optional.ofNullable(m.getAnnotation(Operation.class));
        if (opOpt.map(Operation::hidden).orElse(false).booleanValue()) {
            return null;
        }
        Optional<List<String>> produces = this.findProduces(m);
        OperationImpl operation = new OperationImpl();
        if (opOpt.isPresent()) {
            Operation op = opOpt.get();
            if (!op.operationId().isEmpty()) {
                operation.operationId(op.operationId());
            } else {
                operation.operationId(this.createOperationId(m, httpVerb, path));
            }
            if (!op.summary().isEmpty()) {
                operation.summary(op.summary());
            }
            operation.deprecated(op.deprecated());
            if (!op.description().isEmpty()) {
                operation.description(op.description());
            }
        } else {
            operation.operationId(this.createOperationId(m, httpVerb, path));
        }
        Optional<String> servers = Optional.ofNullable(this.config.read("mp.openapi.servers.operation." + operation.getOperationId(), null));
        if (servers.isPresent()) {
            servers.ifPresent(s -> operation.servers(this.mapConfiguredServers((String)s)));
        } else {
            Optional.ofNullable(Optional.ofNullable(this.findServers(m)).orElseGet(() -> this.findServers(declaring))).ifPresent(it -> operation.servers(Stream.of(it).map(this::mapServer).collect(Collectors.toList())));
        }
        Optional.of(m.getAnnotationsByType(Callback.class)).filter(it -> ((Callback[])it).length > 0).ifPresent(cbs -> {
            Map<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> callbacks = Stream.of(cbs).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref()), it -> this.mapCallback(api, (Callback)it)));
            operation.callbacks(callbacks);
        });
        Optional.ofNullable(m.getAnnotation(org.eclipse.microprofile.openapi.annotations.security.SecurityScheme.class)).ifPresent(s -> {
            org.eclipse.microprofile.openapi.models.Components components = api.getComponents();
            if (components == null) {
                components = new ComponentsImpl();
                api.setComponents(components);
            }
            components.addSecurityScheme(s.ref(), this.mapSecurityScheme((org.eclipse.microprofile.openapi.annotations.security.SecurityScheme)s));
        });
        Optional.ofNullable(m.getAnnotationsByType(Extension.class)).map(this::mapExtensions).ifPresent(exts -> exts.forEach(operation::addExtension));
        operation.security(Optional.of(Stream.concat(Stream.of(m.getAnnotationsByType(SecurityRequirement.class)), Stream.of(m.getDeclaringClass().getAnnotationsByType(SecurityRequirement.class))).map(this::mapSecurity).collect(Collectors.toList())).filter(s -> !s.isEmpty()).orElse(null));
        Optional.ofNullable(this.findTags(m, declaring)).map(tags -> Stream.of(tags).map(it -> Optional.of(it.name()).filter(v -> !v.isEmpty()).map(tag -> {
            api.addTag(this.mapTag((Tag)it));
            return tag;
        }).filter(v -> !v.isEmpty()).orElseGet(() -> {
            String ref = it.ref();
            return Stream.of(declaring.getAnnotationsByType(Tag.class)).filter(t -> t.name().equals(ref)).findFirst().map(Tag::name).filter(v -> !v.isEmpty()).orElseGet(() -> api.getTags().stream().filter(t -> t.getName().equals(ref)).findFirst().map(org.eclipse.microprofile.openapi.models.tags.Tag::getName).orElse(ref));
        })).distinct().filter(v -> !v.isEmpty()).collect(Collectors.toList())).ifPresent(operation::tags);
        Optional.of(m.getAnnotationsByType(APIResponse.class)).filter(s -> ((APIResponse[])s).length > 0).ifPresent(items -> {
            APIResponsesImpl responses = new APIResponsesImpl();
            responses.putAll(Stream.of(items).collect(Collectors.toMap(it -> Optional.of(it.responseCode()).filter(c -> !c.isEmpty()).orElse("200"), it -> this.mapResponse(() -> this.getOrCreateComponents(api), (APIResponse)it, produces.orElse(null)), (a, b) -> b)));
            responses.values().stream().filter(it -> it.getContent() == null || it.getContent().isEmpty() || it.getContent().values().stream().anyMatch(c -> c.getSchema() == null)).forEach(v -> {
                ParameterizedType pt;
                Type returnType = m.getReturnType();
                if (returnType == Void.TYPE || returnType == Response.class) {
                    if (v.getContent() == null || v.getContent().isEmpty()) {
                        ContentImpl content = new ContentImpl();
                        produces.orElseGet(() -> Collections.singletonList("*/*")).forEach(mt -> content.addMediaType((String)mt, new MediaTypeImpl()));
                        v.content((Content)content);
                    }
                    return;
                }
                if (ParameterizedType.class.isInstance(returnType) && (pt = (ParameterizedType)ParameterizedType.class.cast(returnType)).getActualTypeArguments().length > 0 && pt.getRawType() == CompletionStage.class) {
                    returnType = pt.getActualTypeArguments()[0];
                }
                org.eclipse.microprofile.openapi.models.media.Schema schema = this.schemaProcessor.mapSchemaFromClass(() -> this.getOrCreateComponents(api), returnType);
                if (v.getContent() == null || v.getContent().isEmpty()) {
                    ContentImpl content = new ContentImpl();
                    MediaTypeImpl mediaType = new MediaTypeImpl();
                    mediaType.setSchema(schema);
                    content.addMediaType("", mediaType);
                    v.content((Content)content);
                } else {
                    v.getContent().values().stream().filter(it -> it.getSchema() == null).forEach(it -> it.schema(schema));
                }
            });
            responses.values().stream().filter(r -> r.getContent() != null).forEach(resp -> Optional.ofNullable(resp.getContent().remove((Object)"")).ifPresent(updated -> produces.ifPresent(mt -> mt.forEach(type -> resp.getContent().addMediaType(type, updated)))));
            operation.responses(responses);
        });
        operation.parameters(Stream.of(m.getParameters()).filter(it -> it.isAnnotationPresent(org.eclipse.microprofile.openapi.annotations.parameters.Parameter.class) || this.hasJaxRsParams((AnnotatedElement)it)).flatMap(it -> this.buildParameter((AnnotatedTypeElement)it, api).orElseGet(() -> {
            ParameterImpl parameter = new ParameterImpl();
            parameter.schema(this.schemaProcessor.mapSchemaFromClass(() -> this.getOrCreateComponents(api), it.getType()));
            return Stream.of(parameter);
        })).filter(Objects::nonNull).collect(Collectors.toList()));
        Stream.of(m.getParameters()).filter(it -> it.isAnnotationPresent(Parameters.class)).map(it -> it.getAnnotation(Parameters.class).value()).forEach(params -> operation.parameters(this.mapParameters(api, (org.eclipse.microprofile.openapi.annotations.parameters.Parameter[])params)));
        Stream.of(m.getParameters()).filter(p -> p.isAnnotationPresent(org.eclipse.microprofile.openapi.annotations.parameters.RequestBody.class) || !p.isAnnotationPresent(Suspended.class) && !p.isAnnotationPresent(Context.class) && !p.isAnnotationPresent(org.eclipse.microprofile.openapi.annotations.parameters.Parameter.class) && !this.hasJaxRsParams((AnnotatedElement)p)).findFirst().ifPresent(p -> operation.requestBody(this.mapRequestBody(produces.filter(it -> !it.isEmpty()).map(it -> (String)it.iterator().next()).orElse(null), (AnnotatedTypeElement)p, () -> this.getOrCreateComponents(api), Optional.ofNullable(p.getAnnotation(org.eclipse.microprofile.openapi.annotations.parameters.RequestBody.class)).orElseGet(() -> m.getAnnotation(org.eclipse.microprofile.openapi.annotations.parameters.RequestBody.class)))));
        operation.getParameters().stream().filter(it -> it.getSchema() == null).forEach(it -> Stream.of(m.getParameters()).filter(mp -> this.findAnnotatedParameterByName((Parameter)it, (AnnotatedTypeElement)mp)).findFirst().ifPresent(mp -> it.setSchema(this.schemaProcessor.mapSchemaFromClass(() -> this.getOrCreateComponents(api), mp.getType()))));
        operation.getParameters().stream().filter(it -> it.getContent() != null && it.getContent().values().stream().anyMatch(c -> c.getSchema() == null || c.getSchema().getType() == null)).forEach(it -> Stream.of(m.getParameters()).filter(mp -> this.findAnnotatedParameterByName((Parameter)it, (AnnotatedTypeElement)mp)).findFirst().ifPresent(mp -> it.getContent().values().stream().filter(c -> c.getSchema() == null || c.getSchema().getType() == null).forEach(mt -> {
            org.eclipse.microprofile.openapi.models.media.Schema schema = this.schemaProcessor.mapSchemaFromClass(() -> this.getOrCreateComponents(api), mp.getType());
            if (mt.getSchema() == null) {
                mt.setSchema(schema);
            } else {
                mt.getSchema().type(schema.getType());
            }
        })));
        if (operation.getResponses() == null) {
            APIResponsesImpl responses = new APIResponsesImpl();
            operation.responses(responses);
            boolean normalResponse = Stream.of(m.getParameters()).noneMatch(it -> it.isAnnotationPresent(Suspended.class));
            ContentImpl content = new ContentImpl();
            if (normalResponse) {
                MediaTypeImpl impl = new MediaTypeImpl();
                impl.setSchema(this.schemaProcessor.mapSchemaFromClass(() -> this.getOrCreateComponents(api), m.getReturnType()));
                produces.orElseGet(() -> Collections.singletonList("*/*")).forEach(key -> content.addMediaType((String)key, impl));
            }
            org.eclipse.microprofile.openapi.models.responses.APIResponse defaultResponse = new APIResponseImpl().description("default response").content((Content)content);
            responses.addApiResponse(m.getReturnType() == Void.TYPE || m.getReturnType() == Void.class && normalResponse ? "204" : "200", defaultResponse);
            responses.defaultValue(defaultResponse);
        }
        return operation;
    }

    private String createOperationId(AnnotatedMethodElement m, String httpVerb, String path) {
        String name = this.operationNamingStrategy.name(new NamingStrategy.Context(m, httpVerb, path));
        int idx = 1;
        while (!this.operationId.add(name)) {
            name = name + "_" + idx;
            ++idx;
        }
        return name;
    }

    private boolean findAnnotatedParameterByName(Parameter it, AnnotatedTypeElement mp) {
        String expected = Optional.ofNullable(it.getName()).orElse("");
        if (mp.isAnnotationPresent(PathParam.class)) {
            return expected.equals(mp.getAnnotation(PathParam.class).value());
        }
        if (mp.isAnnotationPresent(HeaderParam.class)) {
            return expected.equals(mp.getAnnotation(HeaderParam.class).value());
        }
        if (mp.isAnnotationPresent(CookieParam.class)) {
            return expected.equals(mp.getAnnotation(CookieParam.class).value());
        }
        if (mp.isAnnotationPresent(QueryParam.class)) {
            return expected.equals(mp.getAnnotation(QueryParam.class).value());
        }
        return false;
    }

    private org.eclipse.microprofile.openapi.annotations.servers.Server[] findServers(AnnotatedElement annotatedElement) {
        if (annotatedElement.getAnnotation(org.eclipse.microprofile.openapi.annotations.servers.Server.class) != null || annotatedElement.getAnnotation(Servers.class) != null) {
            return (org.eclipse.microprofile.openapi.annotations.servers.Server[])annotatedElement.getAnnotationsByType(org.eclipse.microprofile.openapi.annotations.servers.Server.class);
        }
        return null;
    }

    private Tag[] findTags(AnnotatedMethodElement m, AnnotatedElement declaring) {
        return Optional.ofNullable(this.findTags(m)).orElseGet(() -> this.findTags(declaring));
    }

    private Tag[] findTags(AnnotatedElement m) {
        Tag mTag = m.getAnnotation(Tag.class);
        Tags mTags = m.getAnnotation(Tags.class);
        if (mTag != null || mTags != null) {
            if (mTag == null) {
                return (Tag[])this.mapTagsAnnotationToTags(mTags).toArray(Tag[]::new);
            }
            return (Tag[])Stream.concat(Stream.of(mTag), Optional.ofNullable(mTags).map(t -> t.refs().length == 0 ? Stream.of(t.value()) : this.mapTagsAnnotationToTags((Tags)t)).orElseGet(Stream::empty)).filter(Objects::nonNull).toArray(Tag[]::new);
        }
        return null;
    }

    private Stream<Tag> mapTagsAnnotationToTags(Tags t) {
        return Stream.concat(Stream.of(t.value()), Stream.of(t.refs()).map(x$0 -> new TagAnnotation((String)x$0)));
    }

    private Optional<List<String>> findProduces(AnnotatedMethodElement m) {
        return Optional.ofNullable(Optional.ofNullable(m.getAnnotation(Produces.class)).orElseGet(() -> m.getDeclaringClass().getAnnotation(Produces.class))).map(p -> Stream.of(p.value()).collect(Collectors.toList()));
    }

    private boolean hasJaxRsParams(AnnotatedElement it) {
        return it.isAnnotationPresent(HeaderParam.class) || it.isAnnotationPresent(CookieParam.class) || it.isAnnotationPresent(PathParam.class) || it.isAnnotationPresent(QueryParam.class) || it.isAnnotationPresent(BeanParam.class);
    }

    private Optional<Stream<ParameterImpl>> buildParameter(AnnotatedTypeElement annotatedElement, OpenAPI openAPI) {
        return Optional.ofNullable(Optional.ofNullable(annotatedElement.getAnnotation(org.eclipse.microprofile.openapi.annotations.parameters.Parameter.class)).map(it -> this.mapParameter(annotatedElement, () -> this.getOrCreateComponents(openAPI), (org.eclipse.microprofile.openapi.annotations.parameters.Parameter)it)).map(Stream::of).orElseGet(() -> {
            if (this.hasJaxRsParams(annotatedElement)) {
                if (annotatedElement.isAnnotationPresent(BeanParam.class)) {
                    return this.fromBeanParam(annotatedElement, openAPI);
                }
                return Stream.of(this.bindParam(annotatedElement, openAPI));
            }
            return Stream.empty();
        }));
    }

    private Stream<ParameterImpl> fromBeanParam(AnnotatedTypeElement elt, OpenAPI openAPI) {
        Type type = elt.getType();
        if (type != null && type != Object.class) {
            Class clazz = (Class)Class.class.cast(type);
            return Stream.concat(this.fromBeanParamForType(clazz, openAPI), this.fromBeanParamForType(clazz.getSuperclass(), openAPI));
        }
        return null;
    }

    private Stream<ParameterImpl> fromBeanParamForType(Class<?> type, OpenAPI openAPI) {
        if (type == null || type == Object.class) {
            return Stream.empty();
        }
        return Stream.of(type.getDeclaredFields()).filter(this::hasJaxRsParams).map(FieldElement::new).map(it -> this.bindParam((AnnotatedTypeElement)it, openAPI));
    }

    private ParameterImpl bindParam(AnnotatedTypeElement annotatedElement, OpenAPI openAPI) {
        ParameterImpl parameter;
        org.eclipse.microprofile.openapi.annotations.parameters.Parameter param = annotatedElement.getAnnotation(org.eclipse.microprofile.openapi.annotations.parameters.Parameter.class);
        if (param != null) {
            parameter = this.mapParameter(annotatedElement, () -> this.getOrCreateComponents(openAPI), param);
        } else {
            parameter = new ParameterImpl();
            if (annotatedElement.isAnnotationPresent(HeaderParam.class)) {
                parameter.in(Parameter.In.HEADER).style(Parameter.Style.SIMPLE).name(annotatedElement.getAnnotation(HeaderParam.class).value());
            } else if (annotatedElement.isAnnotationPresent(CookieParam.class)) {
                parameter.in(Parameter.In.COOKIE).style(Parameter.Style.FORM).name(annotatedElement.getAnnotation(CookieParam.class).value());
            } else if (annotatedElement.isAnnotationPresent(PathParam.class)) {
                parameter.required(true).in(Parameter.In.PATH).style(Parameter.Style.SIMPLE).name(annotatedElement.getAnnotation(PathParam.class).value());
            } else if (annotatedElement.isAnnotationPresent(QueryParam.class)) {
                parameter.in(Parameter.In.QUERY).style(Parameter.Style.FORM).name(annotatedElement.getAnnotation(QueryParam.class).value());
            }
        }
        if (parameter.getSchema() == null) {
            parameter.schema(this.schemaProcessor.mapSchemaFromClass(() -> this.getOrCreateComponents(openAPI), annotatedElement.getType()));
        }
        return parameter;
    }

    private PathItem getPathItem(OpenAPI api, String path) {
        return (PathItem)api.getPaths().computeIfAbsent((Object)path, p -> {
            PathItemImpl item = new PathItemImpl();
            Optional.ofNullable(this.config.read("mp.openapi.servers.path." + path, null)).ifPresent(servers -> item.servers(this.mapConfiguredServers((String)servers)));
            return item;
        });
    }

    private String buildPath(String base, Path path, Path mtdPath) {
        return Stream.concat(Stream.of(base), Stream.of(path, mtdPath).filter(Objects::nonNull).map(Path::value)).map(v -> v.substring(v.startsWith("/") && !"/".equalsIgnoreCase((String)v) ? 1 : 0, v.endsWith("/") ? v.length() - 1 : v.length())).filter(it -> !it.isEmpty()).collect(Collectors.joining("/", "/", ""));
    }

    private void processComponents(OpenAPI api, Components components) {
        ComponentsImpl impl = new ComponentsImpl();
        api.components((org.eclipse.microprofile.openapi.models.Components)impl);
        this.processCallbacks(api, components.callbacks());
        if (components.schemas().length > 0) {
            Map<String, org.eclipse.microprofile.openapi.models.media.Schema> schemas = Stream.of(components.schemas()).map(it -> {
                String ref = Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref());
                return new SchemaWithRef(ref, this.mapSchema(api, (Schema)it, ref));
            }).collect(Collectors.toMap(it -> ((SchemaWithRef)it).ref, it -> ((SchemaWithRef)it).schema));
            schemas.forEach((key, value) -> impl.getSchemas().putIfAbsent(key, value));
        }
        if (components.links().length > 0) {
            impl.links(Stream.of(components.links()).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref()), this::mapLink)));
        }
        if (components.securitySchemes().length > 0) {
            impl.securitySchemes(Stream.of(components.securitySchemes()).collect(Collectors.toMap(it -> Optional.of(it.securitySchemeName()).filter(v -> !v.isEmpty()).orElseGet(() -> it.ref()), this::mapSecurityScheme)));
        }
        if (components.requestBodies().length > 0) {
            impl.requestBodies(Stream.of(components.requestBodies()).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref()), it -> this.mapRequestBody(null, null, () -> impl, (org.eclipse.microprofile.openapi.annotations.parameters.RequestBody)it))));
        }
        if (components.parameters().length > 0) {
            impl.parameters(Stream.of(components.parameters()).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref()), it -> this.mapParameter(null, () -> impl, (org.eclipse.microprofile.openapi.annotations.parameters.Parameter)it))));
        }
        if (components.headers().length > 0) {
            impl.headers(Stream.of(components.headers()).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref()), it -> this.mapHeader(() -> impl, (org.eclipse.microprofile.openapi.annotations.headers.Header)it))));
        }
        if (components.examples().length > 0) {
            impl.examples(Stream.of(components.examples()).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref()), this::mapExample)));
        }
        if (components.responses().length > 0) {
            APIResponsesImpl responses = new APIResponsesImpl();
            responses.putAll(Stream.of(components.responses()).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(c -> !c.isEmpty()).orElseGet(() -> it.ref()), it -> this.mapResponse(() -> impl, (APIResponse)it, null), (a, b) -> b)));
            impl.responses(responses);
        }
    }

    private org.eclipse.microprofile.openapi.models.media.Schema mapSchema(OpenAPI api, Schema schema, String ref) {
        return Optional.ofNullable(this.schemaProcessor.mapSchema(() -> this.getOrCreateComponents(api), schema, ref)).map(s -> s.externalDocs(this.mapExternalDocumentation(schema.externalDocs()))).orElse(null);
    }

    private SecurityScheme mapSecurityScheme(org.eclipse.microprofile.openapi.annotations.security.SecurityScheme securityScheme) {
        return this.updateSecurityScheme(securityScheme, new SecuritySchemeImpl());
    }

    private SecurityScheme updateSecurityScheme(org.eclipse.microprofile.openapi.annotations.security.SecurityScheme securityScheme, SecuritySchemeImpl scheme) {
        Optional.of(securityScheme.apiKeyName()).filter(v -> !v.isEmpty()).ifPresent(scheme::setName);
        Optional.of(securityScheme.bearerFormat()).filter(v -> !v.isEmpty()).ifPresent(scheme::bearerFormat);
        Optional.of(securityScheme.description()).filter(v -> !v.isEmpty()).ifPresent(scheme::description);
        Optional.of(securityScheme.openIdConnectUrl()).filter(v -> !v.isEmpty()).ifPresent(scheme::openIdConnectUrl);
        Optional.of(securityScheme.ref()).filter(v -> !v.isEmpty()).ifPresent(scheme::ref);
        Optional.of(securityScheme.scheme()).filter(v -> !v.isEmpty()).ifPresent(scheme::scheme);
        Optional.of(securityScheme.type()).filter(it -> it != SecuritySchemeType.DEFAULT).map(it -> SecurityScheme.Type.valueOf((String)it.name())).ifPresent(scheme::type);
        Optional.of(securityScheme.in()).filter(it -> it != SecuritySchemeIn.DEFAULT).map(it -> SecurityScheme.In.valueOf((String)it.name())).ifPresent(scheme::in);
        Optional.of(securityScheme.flows()).map(this::mapFlows).ifPresent(scheme::flows);
        return scheme;
    }

    private org.eclipse.microprofile.openapi.models.security.OAuthFlows mapFlows(OAuthFlows oAuthFlows) {
        org.eclipse.microprofile.openapi.annotations.security.OAuthFlow implicit;
        org.eclipse.microprofile.openapi.annotations.security.OAuthFlow password;
        org.eclipse.microprofile.openapi.annotations.security.OAuthFlow clientCredentials;
        OAuthFlowsImpl flows = new OAuthFlowsImpl();
        boolean empty = true;
        org.eclipse.microprofile.openapi.annotations.security.OAuthFlow authorizationCode = oAuthFlows.authorizationCode();
        if (this.isSet(authorizationCode)) {
            empty = false;
            flows.authorizationCode(this.mapFlow(authorizationCode));
        }
        if (this.isSet(clientCredentials = oAuthFlows.clientCredentials())) {
            empty = false;
            flows.clientCredentials(this.mapFlow(clientCredentials));
        }
        if (this.isSet(password = oAuthFlows.password())) {
            empty = false;
            flows.password(this.mapFlow(password));
        }
        if (this.isSet(implicit = oAuthFlows.implicit())) {
            empty = false;
            flows.implicit(this.mapFlow(implicit));
        }
        return empty ? null : flows;
    }

    private OAuthFlow mapFlow(org.eclipse.microprofile.openapi.annotations.security.OAuthFlow flow) {
        return new OAuthFlowImpl().refreshUrl(this.valueOrNull(flow.refreshUrl())).tokenUrl(this.valueOrNull(flow.tokenUrl())).authorizationUrl(this.valueOrNull(flow.authorizationUrl())).scopes(this.createScopes(flow));
    }

    private String valueOrNull(String s) {
        return s.isEmpty() ? null : s;
    }

    private Scopes createScopes(org.eclipse.microprofile.openapi.annotations.security.OAuthFlow authorizationCode) {
        ScopesImpl scopes = new ScopesImpl();
        Stream.of(authorizationCode.scopes()).forEach(s -> scopes.addScope(s.name(), s.description()));
        return scopes;
    }

    private boolean isSet(org.eclipse.microprofile.openapi.annotations.security.OAuthFlow oAuthFlow) {
        return !oAuthFlow.authorizationUrl().isEmpty() || !oAuthFlow.refreshUrl().isEmpty() || !oAuthFlow.tokenUrl().isEmpty();
    }

    private void processCallbacks(OpenAPI api, Callback[] callbacks) {
        if (callbacks.length > 0) {
            this.getOrCreateComponents(api).setCallbacks(Stream.of(callbacks).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref()), it -> this.mapCallback(api, (Callback)it))));
        }
    }

    private org.eclipse.microprofile.openapi.models.callbacks.Callback mapCallback(OpenAPI api, Callback callback) {
        CallbackImpl impl = new CallbackImpl();
        Optional.of(callback.ref()).filter(r -> !r.isEmpty()).ifPresent(impl::ref);
        PathItemImpl pathItem = new PathItemImpl();
        if (callback.operations().length > 0) {
            Stream.of(callback.operations()).forEach(co -> {
                OperationImpl operation = new OperationImpl();
                operation.summary(co.summary());
                operation.description(co.description());
                operation.externalDocs(this.mapExternalDocumentation(co.externalDocs()));
                if (co.extensions().length > 0) {
                    operation.setExtensions(this.mapExtensions(co.extensions()));
                }
                if (co.parameters().length > 0) {
                    operation.parameters(this.mapParameters(api, co.parameters()));
                }
                operation.requestBody(this.mapRequestBody(null, null, () -> this.getOrCreateComponents(api), co.requestBody()));
                if (co.security().length > 0) {
                    operation.security(Stream.of(co.security()).map(this::mapSecurity).collect(Collectors.toList()));
                }
                if (co.responses().length > 0) {
                    APIResponsesImpl responses = new APIResponsesImpl();
                    responses.putAll(Stream.of(co.responses()).collect(Collectors.toMap(it -> Optional.of(it.responseCode()).filter(c -> !c.isEmpty()).orElse("200"), it -> this.mapResponse(() -> this.getOrCreateComponents(api), (APIResponse)it, null))));
                    operation.responses(responses);
                }
                switch (co.method().toUpperCase(Locale.ROOT)) {
                    case "GET": {
                        pathItem.setGET(operation);
                        break;
                    }
                    case "PUT": {
                        pathItem.setPUT(operation);
                        break;
                    }
                    case "POST": {
                        pathItem.setPOST(operation);
                        break;
                    }
                    case "DELETE": {
                        pathItem.setDELETE(operation);
                        break;
                    }
                    case "OPTIONS": {
                        pathItem.setOPTIONS(operation);
                        break;
                    }
                    case "TRACE": {
                        pathItem.setTRACE(operation);
                        break;
                    }
                    case "HEAD": {
                        pathItem.setHEAD(operation);
                        break;
                    }
                    case "PATCH": {
                        pathItem.setPATCH(operation);
                        break;
                    }
                }
            });
        }
        impl.addPathItem(callback.callbackUrlExpression(), pathItem);
        return impl;
    }

    private org.eclipse.microprofile.openapi.models.responses.APIResponse mapResponse(Supplier<org.eclipse.microprofile.openapi.models.Components> components, APIResponse response, Collection<String> defaultMediaTypes) {
        APIResponseImpl impl = new APIResponseImpl();
        impl.description(response.description());
        Optional.of(response.ref()).filter(r -> !r.isEmpty()).ifPresent(impl::ref);
        if (response.headers().length > 0) {
            impl.headers(Stream.of(response.headers()).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref().replace("#/components/headers/", "")), it -> this.mapHeader(components, (org.eclipse.microprofile.openapi.annotations.headers.Header)it))));
        }
        if (response.content().length > 0) {
            ContentImpl content = new ContentImpl();
            content.putAll(Stream.of(response.content()).collect(Collectors.toMap(it -> Optional.of(it.mediaType()).filter(v -> !v.isEmpty()).orElse(""), it -> this.mapContent(components, (org.eclipse.microprofile.openapi.annotations.media.Content)it))));
            Optional.ofNullable(content.remove("")).ifPresent(c -> (defaultMediaTypes == null ? Collections.singletonList("*/*") : defaultMediaTypes).forEach(it -> content.addMediaType((String)it, (MediaType)c)));
            impl.content(content);
        }
        if (response.links().length > 0) {
            impl.links(Stream.of(response.links()).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref()), this::mapLink)));
        }
        return impl;
    }

    private org.eclipse.microprofile.openapi.models.links.Link mapLink(Link link) {
        LinkImpl impl = new LinkImpl();
        impl.description(link.description());
        impl.operationId(link.operationId());
        impl.operationRef(link.operationRef());
        impl.requestBody(link.requestBody());
        impl.server(this.mapServer(link.server()));
        if (link.parameters().length > 0) {
            impl.parameters(Stream.of(link.parameters()).collect(Collectors.toMap(LinkParameter::name, LinkParameter::expression)));
        }
        return impl;
    }

    private RequestBody mapRequestBody(String defaultContentType, AnnotatedTypeElement param, Supplier<org.eclipse.microprofile.openapi.models.Components> components, org.eclipse.microprofile.openapi.annotations.parameters.RequestBody requestBody) {
        RequestBody impl = new RequestBodyImpl().content(new ContentImpl());
        if (requestBody != null) {
            if (!requestBody.description().isEmpty()) {
                impl.description(requestBody.description());
            }
            if (!requestBody.ref().isEmpty()) {
                impl.ref(requestBody.ref());
            }
            impl.required(Boolean.valueOf(requestBody.required()));
            impl.getContent().putAll(Stream.of(requestBody.content()).collect(Collectors.toMap(it -> Optional.of(it.mediaType()).filter(v -> !v.isEmpty()).orElse("*/*"), it -> this.mapContent(components, (org.eclipse.microprofile.openapi.annotations.media.Content)it))));
        } else if (param != null && defaultContentType != null) {
            impl.required(Boolean.valueOf(true));
        }
        if (impl.getContent().isEmpty() && param != null && defaultContentType != null) {
            impl.getContent().addMediaType(defaultContentType, new MediaTypeImpl().schema(this.schemaProcessor.mapSchemaFromClass(components, param.getType())));
        }
        return impl;
    }

    private MediaType mapContent(Supplier<org.eclipse.microprofile.openapi.models.Components> components, org.eclipse.microprofile.openapi.annotations.media.Content content) {
        MediaTypeImpl impl = new MediaTypeImpl();
        if (content.encoding().length > 0) {
            Stream.of(content.encoding()).forEach(e -> impl.addEncoding(e.name(), this.mapEncoding(components, (Encoding)e)));
        }
        impl.setSchema(this.schemaProcessor.mapSchema(components, content.schema(), null));
        if (content.examples().length > 0) {
            impl.examples(Stream.of(content.examples()).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref()), this::mapExample)));
        }
        if (!content.example().isEmpty()) {
            impl.example(content.example());
        }
        return impl;
    }

    private org.eclipse.microprofile.openapi.models.media.Encoding mapEncoding(Supplier<org.eclipse.microprofile.openapi.models.Components> components, Encoding e) {
        EncodingImpl impl = new EncodingImpl();
        impl.allowReserved(e.allowReserved());
        impl.explode(e.explode());
        impl.contentType(Optional.of(e.contentType()).filter(v -> !v.isEmpty()).orElse("*/*"));
        Optional.of(e.style()).filter(it -> !it.isEmpty()).map(it -> it.toUpperCase(Locale.ROOT)).ifPresent(v -> impl.style(Encoding.Style.valueOf((String)v)));
        if (e.headers().length > 0) {
            impl.headers(Stream.of(e.headers()).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref().replace("#/components/headers/", "")), it -> this.mapHeader(components, (org.eclipse.microprofile.openapi.annotations.headers.Header)it))));
        }
        return impl;
    }

    private Header mapHeader(Supplier<org.eclipse.microprofile.openapi.models.Components> components, org.eclipse.microprofile.openapi.annotations.headers.Header header) {
        String ref = header.ref();
        if (!ref.isEmpty()) {
            Header headerRef = this.findHeaderByRef(components.get(), ref);
            HeaderImpl impl = new HeaderImpl();
            impl.deprecated(headerRef.getDeprecated());
            impl.description(headerRef.getDescription());
            impl.allowEmptyValue(headerRef.getAllowEmptyValue());
            impl.required(headerRef.getRequired());
            impl.schema(headerRef.getSchema());
            impl.style(headerRef.getStyle());
            impl.ref(ref.startsWith("#") ? ref : "#/components/headers/" + ref);
            return impl;
        }
        HeaderImpl impl = new HeaderImpl();
        impl.deprecated(header.deprecated());
        impl.description(header.description());
        impl.allowEmptyValue(header.allowEmptyValue());
        impl.required(header.required());
        impl.schema(this.schemaProcessor.mapSchema(components, header.schema(), null));
        impl.style(Header.Style.SIMPLE);
        return impl;
    }

    private Header findHeaderByRef(org.eclipse.microprofile.openapi.models.Components components, String ref) {
        if (ref.startsWith("#/components/headers/")) {
            return (Header)components.getHeaders().get(ref.substring("#/components/headers/".length()));
        }
        return Optional.ofNullable(components.getHeaders().get(ref)).orElseGet(HeaderImpl::new);
    }

    private List<Parameter> mapParameters(OpenAPI openAPI, org.eclipse.microprofile.openapi.annotations.parameters.Parameter[] parameters) {
        return Stream.of(parameters).map(it -> this.mapParameter(null, () -> this.getOrCreateComponents(openAPI), (org.eclipse.microprofile.openapi.annotations.parameters.Parameter)it)).collect(Collectors.toList());
    }

    private org.eclipse.microprofile.openapi.models.Components getOrCreateComponents(OpenAPI openAPI) {
        org.eclipse.microprofile.openapi.models.Components components = openAPI.getComponents();
        if (components == null) {
            components = new ComponentsImpl();
            openAPI.components(components);
        }
        return components;
    }

    private ParameterImpl mapParameter(AnnotatedTypeElement annotatedElement, Supplier<org.eclipse.microprofile.openapi.models.Components> components, org.eclipse.microprofile.openapi.annotations.parameters.Parameter parameter) {
        ParameterImpl impl = new ParameterImpl();
        impl.description(parameter.description());
        impl.required(parameter.required());
        impl.name(parameter.name());
        impl.in(Optional.of(parameter.in()).filter(s -> s != ParameterIn.DEFAULT).map(Enum::name).map(Parameter.In::valueOf).orElse(null));
        impl.style(Optional.of(parameter.style()).filter(s -> s != ParameterStyle.DEFAULT).map(Enum::name).map(Parameter.Style::valueOf).orElse(null));
        impl.allowEmptyValue(parameter.allowEmptyValue());
        impl.allowReserved(parameter.allowReserved());
        impl.schema(Optional.ofNullable(this.schemaProcessor.mapSchema(components, parameter.schema(), null)).map(s -> s.externalDocs(this.mapExternalDocumentation(parameter.schema().externalDocs()))).orElseGet(() -> {
            if (annotatedElement == null) {
                return null;
            }
            return this.schemaProcessor.mapSchemaFromClass(components, annotatedElement.getType());
        }));
        if (impl.getSchema() != null && impl.getSchema().getType() == null && annotatedElement != null) {
            this.schemaProcessor.fillSchema(components, annotatedElement.getType(), impl.getSchema(), null);
        }
        Optional.of(parameter.content()).filter(it -> ((org.eclipse.microprofile.openapi.annotations.media.Content[])it).length > 0).map(Stream::of).ifPresent(c -> {
            ContentImpl content = new ContentImpl();
            content.putAll(c.collect(Collectors.toMap(it -> Optional.of(it.mediaType()).filter(v -> !v.isEmpty()).orElse("*/*"), arg_0 -> this.lambda$null$207((Supplier)components, annotatedElement, arg_0))));
            impl.content(content);
        });
        Optional.of(parameter.example()).filter(v -> !v.isEmpty()).ifPresent(impl::example);
        if (parameter.examples().length > 0) {
            impl.examples(Stream.of(parameter.examples()).collect(Collectors.toMap(it -> Optional.of(it.name()).filter(n -> !n.isEmpty()).orElseGet(() -> it.ref()), this::mapExample)));
        }
        if (annotatedElement != null) {
            if (annotatedElement.isAnnotationPresent(HeaderParam.class)) {
                HeaderParam annotation = annotatedElement.getAnnotation(HeaderParam.class);
                impl.in(Parameter.In.HEADER);
                this.mapParameterName(impl, annotation.value());
            } else if (annotatedElement.isAnnotationPresent(CookieParam.class)) {
                CookieParam annotation = annotatedElement.getAnnotation(CookieParam.class);
                impl.in(Parameter.In.COOKIE);
                this.mapParameterName(impl, annotation.value());
            } else if (annotatedElement.isAnnotationPresent(PathParam.class)) {
                PathParam annotation = annotatedElement.getAnnotation(PathParam.class);
                impl.in(Parameter.In.PATH);
                this.mapParameterName(impl, annotation.value());
            } else if (annotatedElement.isAnnotationPresent(QueryParam.class)) {
                QueryParam annotation = annotatedElement.getAnnotation(QueryParam.class);
                impl.in(Parameter.In.QUERY);
                this.mapParameterName(impl, annotation.value());
            }
        }
        return impl;
    }

    private void mapParameterName(ParameterImpl impl, String name) {
        if (impl.getName() == null || impl.getName().isEmpty()) {
            impl.name(name);
        }
    }

    private Example mapExample(ExampleObject exampleObject) {
        ExampleImpl impl = new ExampleImpl();
        if (!exampleObject.description().isEmpty()) {
            impl.description(exampleObject.description());
        }
        if (!exampleObject.externalValue().isEmpty()) {
            impl.externalValue(exampleObject.externalValue());
        }
        if (!exampleObject.value().isEmpty()) {
            impl.value(exampleObject.value());
        }
        if (!exampleObject.summary().isEmpty()) {
            impl.summary(exampleObject.summary());
        }
        return impl;
    }

    private Map<String, Object> mapExtensions(Extension[] extensions) {
        return Stream.of(extensions).collect(Collectors.toMap(Extension::name, e -> {
            if (e.parseValue()) {
                return this.parse(e.value());
            }
            return e.value();
        }));
    }

    private Object parse(String value) {
        try (JsonReader reader = this.jsonReaderFactory.createReader((Reader)new StringReader(value));){
            JsonValue jsonValue = reader.readValue();
            switch (jsonValue.getValueType()) {
                case NULL: {
                    Object var5_6 = null;
                    return var5_6;
                }
                case TRUE: 
                case FALSE: {
                    Boolean bl = JsonValue.TRUE.equals(jsonValue);
                    return bl;
                }
                case NUMBER: {
                    JsonNumber number = (JsonNumber)JsonNumber.class.cast(jsonValue);
                    double doubleValue = number.doubleValue();
                    if (doubleValue == (double)number.intValue()) {
                        Integer n = number.intValue();
                        return n;
                    }
                    if (doubleValue == (double)number.longValue()) {
                        Long l = number.longValue();
                        return l;
                    }
                    Double d = doubleValue;
                    return d;
                }
            }
            JsonValue jsonValue2 = jsonValue;
            return jsonValue2;
        }
    }

    private void processDefinition(OpenAPI api, OpenAPIDefinition annotation) {
        this.processInfo(api, annotation.info());
        this.processTags(api, annotation.tags());
        api.externalDocs(this.mapExternalDocumentation(annotation.externalDocs()));
        this.processSecurity(api, annotation.security());
        api.servers(this.mapServers(annotation.servers()));
        this.processComponents(api, annotation.components());
    }

    private List<Server> mapServers(org.eclipse.microprofile.openapi.annotations.servers.Server[] servers) {
        return servers.length == 0 ? null : Stream.of(servers).map(this::mapServer).collect(Collectors.toList());
    }

    private Server mapServer(org.eclipse.microprofile.openapi.annotations.servers.Server server) {
        ServerImpl impl = new ServerImpl();
        impl.url(server.url());
        impl.description(server.description());
        ServerVariable[] variables = server.variables();
        if (variables.length != 0) {
            ServerVariablesImpl variablesImpl = new ServerVariablesImpl();
            variablesImpl.putAll(Stream.of(variables).collect(Collectors.toMap(ServerVariable::name, this::mapVariable)));
            impl.variables(variablesImpl);
        }
        return impl;
    }

    private org.eclipse.microprofile.openapi.models.servers.ServerVariable mapVariable(ServerVariable serverVariable) {
        ServerVariableImpl impl = new ServerVariableImpl();
        impl.defaultValue(serverVariable.defaultValue());
        impl.description(serverVariable.description());
        impl.enumeration(Arrays.asList(serverVariable.enumeration()));
        return impl;
    }

    private void processSecurity(OpenAPI api, SecurityRequirement[] security) {
        if (security.length == 0) {
            return;
        }
        api.security(Stream.of(security).map(this::mapSecurity).collect(Collectors.toList()));
    }

    private org.eclipse.microprofile.openapi.models.security.SecurityRequirement mapSecurity(SecurityRequirement securityRequirement) {
        SecurityRequirementImpl impl = new SecurityRequirementImpl();
        impl.addScheme(securityRequirement.name(), Arrays.asList(securityRequirement.scopes()));
        return impl;
    }

    private void processTags(OpenAPI api, Tag[] tags) {
        if (tags.length == 0) {
            return;
        }
        Stream.of(tags).map(this::mapTag).forEach(arg_0 -> ((OpenAPI)api).addTag(arg_0));
    }

    private org.eclipse.microprofile.openapi.models.tags.Tag mapTag(Tag tag) {
        TagImpl impl = new TagImpl();
        impl.name(tag.name());
        impl.description(tag.description());
        impl.externalDocs(Optional.ofNullable(tag.externalDocs()).map(this::mapExternalDocumentation).orElse(null));
        return impl;
    }

    private org.eclipse.microprofile.openapi.models.ExternalDocumentation mapExternalDocumentation(ExternalDocumentation externalDocumentation) {
        if (externalDocumentation.url().isEmpty() && externalDocumentation.description().isEmpty()) {
            return null;
        }
        ExternalDocumentationImpl impl = new ExternalDocumentationImpl();
        if (!externalDocumentation.url().isEmpty()) {
            impl.url(externalDocumentation.url());
        }
        if (!externalDocumentation.description().isEmpty()) {
            impl.description(externalDocumentation.description());
        }
        return impl;
    }

    private void processInfo(OpenAPI api, org.eclipse.microprofile.openapi.annotations.info.Info info) {
        Contact contact = info.contact();
        ContactImpl contactImpl = new ContactImpl();
        contactImpl.email(contact.email());
        contactImpl.name(contact.name());
        contactImpl.url(contact.url());
        License license = info.license();
        LicenseImpl licenseImpl = new LicenseImpl();
        licenseImpl.name(license.name());
        licenseImpl.url(license.url());
        InfoImpl impl = new InfoImpl();
        impl.description(info.description());
        impl.termsOfService(info.termsOfService());
        impl.title(info.title());
        impl.version(info.version());
        impl.contact(contactImpl);
        impl.license(licenseImpl);
        api.info((Info)impl);
    }

    public String getApplicationBinding(Class<?> application) {
        return Optional.ofNullable(application.getAnnotation(ApplicationPath.class)).map(ApplicationPath::value).filter(it -> !"/".equals(it)).map(it -> it.endsWith("*") ? it.substring(0, it.length() - 1) : it).orElse("");
    }

    public void beforeProcessing() {
        this.operationId.clear();
    }

    private /* synthetic */ MediaType lambda$null$207(Supplier components, AnnotatedTypeElement annotatedElement, org.eclipse.microprofile.openapi.annotations.media.Content it) {
        MediaType mediaType = this.mapContent(components, it);
        if (mediaType.getSchema() == null && annotatedElement != null) {
            mediaType.schema(this.schemaProcessor.mapSchemaFromClass(components, annotatedElement.getType()));
        }
        return mediaType;
    }

    private static class SchemaWithRef {
        private final String ref;
        private final org.eclipse.microprofile.openapi.models.media.Schema schema;

        private SchemaWithRef(String ref, org.eclipse.microprofile.openapi.models.media.Schema schema) {
            this.ref = ref;
            this.schema = schema;
        }
    }

    private static class TagAnnotation
    implements Tag {
        private final String ref;

        private TagAnnotation(String ref) {
            this.ref = ref;
        }

        public String name() {
            return "";
        }

        public String description() {
            return "";
        }

        public ExternalDocumentation externalDocs() {
            return null;
        }

        public String ref() {
            return this.ref;
        }

        public Class<? extends Annotation> annotationType() {
            return Tag.class;
        }
    }
}

