/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Vetoed;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Produces;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.geronimo.microprofile.openapi.impl.loader.yaml.Yaml;
import org.apache.geronimo.microprofile.openapi.jaxrs.BaseOpenAPIYamlBodyWriter;

@Provider
@Dependent
@ConstrainedTo(value=RuntimeType.SERVER)
@Produces(value={"text/vnd.yaml", "text/yaml", "text/x-yaml", "application/vnd.yaml", "application/yaml", "application/x-yaml"})
public class JacksonOpenAPIYamlBodyWriter<T>
extends BaseOpenAPIYamlBodyWriter<T> {
    public void writeTo(T entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Mapper.get().writeValue(entityStream, entity);
    }

    @Vetoed
    private static class Mapper {
        private static final AtomicReference<ObjectMapper> REF = new AtomicReference();

        private Mapper() {
        }

        public static ObjectMapper get() {
            ObjectMapper mapper = REF.get();
            if (mapper == null && !REF.compareAndSet(null, mapper = Yaml.getObjectMapper())) {
                mapper = REF.get();
            }
            return mapper;
        }
    }
}

