/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.builder;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis2.pojo.POJOWebServiceContainerFactoryGBean;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.JAXWSServiceBuilder;
import org.apache.geronimo.jaxws.builder.WARWebServiceFinder;
import org.apache.geronimo.jaxws.builder.WsdlGenerator;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.xbeans.javaee.PortComponentType;
import org.apache.geronimo.xbeans.javaee.WebservicesDocument;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2Builder
extends JAXWSServiceBuilder {
    private static final Log log = LogFactory.getLog(Axis2Builder.class);
    public static final GBeanInfo GBEAN_INFO;

    public Axis2Builder(Environment defaultEnviroment) {
        super(defaultEnviroment);
        this.webServiceFinder = new WARWebServiceFinder();
    }

    public Axis2Builder() {
        super(null);
    }

    protected GBeanInfo getContainerFactoryGBeanInfo() {
        return POJOWebServiceContainerFactoryGBean.GBEAN_INFO;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, PortInfo> parseWebServiceDescriptor(InputStream in, URL wsDDUrl, JarFile moduleFile, boolean isEJB, Map correctedPortLocations) throws DeploymentException {
        block29: {
            Axis2Builder.log.debug((Object)("Parsing descriptor " + wsDDUrl));
            map = null;
            cursor = null;
            try {
                xobj = XmlObject.Factory.parse((InputStream)in);
                cursor = xobj.newCursor();
                cursor.toStartDoc();
                cursor.toFirstChild();
                if ("http://java.sun.com/xml/ns/javaee".equals(cursor.getName().getNamespaceURI())) {
                    wd = (WebservicesDocument)xobj.changeType(WebservicesDocument.type);
                    wst = wd.getWebservices();
                    arr$ = wst.getWebserviceDescriptionArray();
                    len$ = arr$.length;
                    i$ = 0;
                    break block29;
                }
                Axis2Builder.log.debug((Object)"Descriptor ignored (not a Java EE 5 descriptor)");
                while (true) {
                    var9_12 = map;
                    return var9_12;
                }
            }
            catch (FileNotFoundException e) {
                var9_13 = Collections.emptyMap();
                return var9_13;
            }
            catch (IOException ex) {
                throw new DeploymentException("Unable to read " + wsDDUrl, (Throwable)ex);
                catch (Exception ex) {
                    throw new DeploymentException("Unknown deployment error", (Throwable)ex);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.dispose();
                }
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        while (true) {
            if (i$ >= len$) ** continue;
            desc = arr$[i$];
            wsdlFile = null;
            if (desc.getWsdlFile() != null) {
                wsdlFile = Axis2Builder.getString(desc.getWsdlFile().getStringValue());
            }
            serviceName = desc.getWebserviceDescriptionName().getStringValue();
            for (PortComponentType port : desc.getPortComponentArray()) {
                portInfo = new PortInfo();
                serviceLink = null;
                beanType = port.getServiceImplBean();
                if (beanType.getEjbLink() != null) {
                    serviceLink = beanType.getEjbLink().getStringValue();
                } else if (beanType.getServletLink().getStringValue() != null) {
                    serviceLink = beanType.getServletLink().getStringValue();
                }
                portInfo.setServiceLink(serviceLink);
                if (port.getServiceEndpointInterface() != null) {
                    sei = port.getServiceEndpointInterface().getStringValue();
                    portInfo.setServiceEndpointInterfaceName(sei);
                }
                portName = port.getPortComponentName().getStringValue();
                portInfo.setPortName(portName);
                portInfo.setProtocolBinding(port.getProtocolBinding());
                portInfo.setServiceName(serviceName);
                portInfo.setWsdlFile(wsdlFile);
                if (port.getEnableMtom() != null) {
                    portInfo.setEnableMTOM(port.getEnableMtom().getBooleanValue());
                }
                if (port.getHandlerChains() != null) {
                    chains = new StringBuffer("<handler-chains xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
                    chains.append(port.getHandlerChains().xmlText());
                    chains.append("</handler-chains>");
                    portInfo.setHandlersAsXML(chains.toString());
                }
                if (port.getWsdlPort() != null) {
                    portInfo.setWsdlPort(port.getWsdlPort().getQNameValue());
                }
                if (port.getWsdlService() != null) {
                    portInfo.setWsdlService(port.getWsdlService().getQNameValue());
                }
                location = (String)correctedPortLocations.get(serviceLink);
                portInfo.setLocation(location);
                if (map == null) {
                    map = new HashMap<String, PortInfo>();
                }
                map.put(serviceLink, portInfo);
            }
            ++i$;
        }
    }

    private static String getString(String in) {
        if (in != null && (in = in.trim()).length() == 0) {
            return null;
        }
        return in;
    }

    protected void initialize(GBeanData targetGBean, Class serviceClass, PortInfo portInfo, Module module) throws DeploymentException {
        if (this.isWsdlSet(portInfo, serviceClass)) {
            log.debug((Object)("Service " + portInfo.getServiceName() + " has WSDL."));
            return;
        }
        if (this.isHTTPBinding(portInfo, serviceClass)) {
            log.debug((Object)("Service " + portInfo.getServiceName() + " is HTTPBinding.  Only SOAP 1.1 or 1.2 is supported."));
            return;
        }
        log.debug((Object)("Service " + portInfo.getServiceName() + " does not have WSDL. Generating WSDL..."));
        WsdlGenerator generator = new WsdlGenerator();
        generator.setAxis2SAAJ();
        if (portInfo.getWsdlService() == null) {
            generator.setWsdlService(JAXWSUtils.getServiceQName((Class)serviceClass));
        } else {
            generator.setWsdlService(portInfo.getWsdlService());
        }
        if (portInfo.getWsdlPort() != null) {
            generator.setWsdlPort(portInfo.getWsdlPort());
        }
        String wsdlFile = generator.generateWsdl(module, serviceClass.getName(), (DeploymentContext)module.getEarContext(), portInfo);
        portInfo.setWsdlFile(wsdlFile);
        log.debug((Object)("Generated " + wsdlFile + " for service " + portInfo.getServiceName()));
    }

    private boolean isWsdlSet(PortInfo portInfo, Class serviceClass) {
        return portInfo.getWsdlFile() != null && !portInfo.getWsdlFile().trim().equals("") || JAXWSUtils.containsWsdlLocation((Class)serviceClass, (ClassLoader)serviceClass.getClassLoader());
    }

    private boolean isHTTPBinding(PortInfo portInfo, Class serviceClass) {
        String bindingURI = "";
        if (portInfo.getProtocolBinding() != null) {
            bindingURI = JAXWSUtils.getBindingURI((String)portInfo.getProtocolBinding());
        }
        String bindingURIFromAnnot = JAXWSUtils.getBindingURIFromAnnot((Class)serviceClass, (ClassLoader)serviceClass.getClassLoader());
        if (bindingURI != null && !bindingURI.trim().equals("")) {
            return bindingURI.equals("http://www.w3.org/2004/08/wsdl/http");
        }
        if (bindingURIFromAnnot != null && !bindingURIFromAnnot.trim().equals("")) {
            return bindingURIFromAnnot.equals("http://www.w3.org/2004/08/wsdl/http");
        }
        return false;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(Axis2Builder.class, (String)"ModuleBuilder");
        infoBuilder.addInterface(WebServiceBuilder.class);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

