/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.builder;

import java.util.Collection;
import java.util.Collections;
import org.apache.geronimo.axis2.osgi.Axis2ModuleRegistry;
import org.apache.geronimo.axis2.pojo.POJOWebServiceContainerFactoryGBean;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.annotation.AnnotationGBeanInfoBuilder;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.JAXWSBuilderUtils;
import org.apache.geronimo.jaxws.builder.JAXWSServiceBuilder;
import org.apache.geronimo.jaxws.builder.WARWebServiceFinder;
import org.apache.geronimo.jaxws.builder.wsdl.WsdlGenerator;
import org.apache.geronimo.jaxws.builder.wsdl.WsdlGeneratorOptions;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ModuleBuilder")
public class Axis2Builder
extends JAXWSServiceBuilder {
    private static final Logger log = LoggerFactory.getLogger(Axis2Builder.class);
    private static final boolean ignoreEmptyWebServiceProviderWSDL = Boolean.getBoolean("org.apache.geronimo.webservice.provider.wsdl.ignore");
    protected Collection<WsdlGenerator> wsdlGenerators;
    private GBeanInfo defaultContainerFactoryGBeanInfo;

    public Axis2Builder(@ParamAttribute(name="defaultEnvironment") Environment defaultEnviroment, @ParamReference(name="WsdlGenerator", namingType="GBean") Collection<WsdlGenerator> wsdlGenerators) {
        super(defaultEnviroment);
        this.wsdlGenerators = wsdlGenerators;
        this.webServiceFinder = new WARWebServiceFinder();
        AnnotationGBeanInfoBuilder annotationGBeanInfoBuilder = new AnnotationGBeanInfoBuilder(POJOWebServiceContainerFactoryGBean.class);
        this.defaultContainerFactoryGBeanInfo = annotationGBeanInfoBuilder.buildGBeanInfo();
    }

    public Axis2Builder() {
        super(null);
    }

    protected GBeanInfo getContainerFactoryGBeanInfo() {
        return this.defaultContainerFactoryGBeanInfo;
    }

    protected WsdlGenerator getWsdlGenerator() throws DeploymentException {
        if (this.wsdlGenerators == null || this.wsdlGenerators.isEmpty()) {
            throw new DeploymentException("Wsdl generator not found");
        }
        return this.wsdlGenerators.iterator().next();
    }

    protected void initialize(GBeanData targetGBean, Class serviceClass, PortInfo portInfo, Module module, Bundle bundle) throws DeploymentException {
        targetGBean.setReferencePattern("Axis2ModuleRegistry", new AbstractNameQuery(Artifact.create((String)"org.apache.geronimo.configs/axis2//car"), Collections.emptyMap(), Axis2ModuleRegistry.class.getName()));
        String serviceName = portInfo.getServiceName() == null ? serviceClass.getName() : portInfo.getServiceName();
        String wsdlFile = portInfo.getWsdlFile();
        if (wsdlFile != null && wsdlFile.trim().length() > 0) {
            portInfo.setWsdlFile(JAXWSBuilderUtils.normalizeWsdlPath((Module)module, (String)wsdlFile));
            if (log.isDebugEnabled()) {
                log.debug("Service " + serviceName + " has WSDL. " + portInfo.getWsdlFile());
            }
            return;
        }
        if (JAXWSUtils.containsWsdlLocation((Class)serviceClass, (Bundle)bundle)) {
            wsdlFile = JAXWSUtils.getServiceWsdlLocation((Class)serviceClass, (Bundle)bundle);
            portInfo.setWsdlFile(JAXWSBuilderUtils.normalizeWsdlPath((Module)module, (String)wsdlFile));
            if (log.isDebugEnabled()) {
                log.debug("Service " + serviceName + " has WSDL configured in annotation " + wsdlFile + " and is resolved as " + portInfo.getWsdlFile());
            }
            return;
        }
        if (this.isHTTPBinding(portInfo, serviceClass)) {
            if (log.isDebugEnabled()) {
                log.debug("Service " + serviceName + " has HTTPBinding.");
            }
            return;
        }
        if (JAXWSUtils.isWebServiceProvider((Class)serviceClass)) {
            if (ignoreEmptyWebServiceProviderWSDL) {
                log.warn("WSDL is not specified for @WebServiceProvider service " + serviceName);
                return;
            }
            throw new DeploymentException("WSDL must be specified for @WebServiceProvider service " + serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("Service " + serviceName + " does not have WSDL. Generating WSDL...");
        }
        WsdlGenerator wsdlGenerator = this.getWsdlGenerator();
        WsdlGeneratorOptions options = new WsdlGeneratorOptions();
        options.setSAAJ(WsdlGeneratorOptions.SAAJ.Axis2);
        if (portInfo.getWsdlService() == null) {
            options.setWsdlService(JAXWSUtils.getServiceQName((Class)serviceClass));
        } else {
            options.setWsdlService(portInfo.getWsdlService());
        }
        if (portInfo.getWsdlPort() != null) {
            options.setWsdlPort(portInfo.getWsdlPort());
        }
        wsdlFile = wsdlGenerator.generateWsdl(module, serviceClass.getName(), (DeploymentContext)module.getEarContext(), options);
        portInfo.setWsdlFile(wsdlFile);
        if (log.isDebugEnabled()) {
            log.debug("Generated " + wsdlFile + " for service " + serviceName);
        }
    }
}

