/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.builder;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.geronimo.axis2.client.Axis2ConfigGBean;
import org.apache.geronimo.axis2.client.Axis2ServiceReference;
import org.apache.geronimo.axis2.osgi.Axis2ModuleRegistry;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.builder.EndpointInfoBuilder;
import org.apache.geronimo.jaxws.builder.JAXWSBuilderUtils;
import org.apache.geronimo.jaxws.builder.JAXWSServiceRefBuilder;
import org.apache.geronimo.jaxws.info.HandlerChainsInfo;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.reference.JndiReference;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.openejb.jee.PortComponentRef;
import org.apache.openejb.jee.ServiceRef;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ModuleBuilder")
public class Axis2ServiceRefBuilder
extends JAXWSServiceRefBuilder {
    private static final Logger log = LoggerFactory.getLogger(Axis2ServiceRefBuilder.class);

    public Axis2ServiceRefBuilder(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamAttribute(name="eeNamespaces") String[] eeNamespaces) {
        super(defaultEnvironment, eeNamespaces);
    }

    protected Object createService(ServiceRef serviceRef, GerServiceRefType gerServiceRef, Module module, Bundle bundle, Class serviceInterfaceClass, QName serviceQName, URI wsdlURI, Class serviceReferenceType, Map<Class<?>, PortComponentRef> portComponentRefMap) throws DeploymentException {
        this.registerConfigGBean(module);
        if (serviceRef.getLookupName() != null && !serviceRef.getLookupName().isEmpty()) {
            return new JndiReference(serviceRef.getLookupName());
        }
        EndpointInfoBuilder builder = new EndpointInfoBuilder(serviceInterfaceClass, gerServiceRef, portComponentRefMap, module, bundle, wsdlURI, serviceQName);
        builder.build();
        wsdlURI = builder.getWsdlURI();
        wsdlURI = JAXWSBuilderUtils.normalizeWsdlPath((Module)module, (URI)wsdlURI);
        serviceQName = builder.getServiceQName();
        Map seiInfoMap = builder.getEndpointInfo();
        HandlerChainsInfo handlerChainsInfo = null;
        if (serviceRef.getHandlerChains() != null) {
            handlerChainsInfo = this.handlerChainsInfoBuilder.build(serviceRef.getHandlerChains());
        }
        String serviceReferenceName = serviceReferenceType == null ? null : serviceReferenceType.getName();
        return new Axis2ServiceReference(serviceInterfaceClass.getName(), serviceReferenceName, wsdlURI, serviceQName, module.getModuleName(), handlerChainsInfo, seiInfoMap);
    }

    private void registerConfigGBean(Module module) throws DeploymentException {
        EARContext context = module.getEarContext();
        AbstractName containerFactoryName = context.getNaming().createChildName(module.getModuleName(), "Axis2ConfigGBean", "GBean");
        try {
            context.getGBeanInstance(containerFactoryName);
        }
        catch (GBeanNotFoundException e1) {
            GBeanData configGBeanData = new GBeanData(containerFactoryName, Axis2ConfigGBean.class);
            configGBeanData.setAttribute("moduleName", (Object)module.getModuleName());
            configGBeanData.setReferencePattern("Axis2ModuleRegistry", new AbstractNameQuery(Artifact.create((String)"org.apache.geronimo.configs/axis2//car"), Collections.emptyMap(), Axis2ModuleRegistry.class.getName()));
            try {
                context.addGBean(configGBeanData);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Could not add config gbean", (Throwable)e);
            }
        }
    }
}

