/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.geronimo.clustering.Cluster;
import org.apache.geronimo.clustering.ClusterListener;
import org.apache.geronimo.clustering.Node;
import org.apache.geronimo.clustering.wadi.DispatcherHolder;
import org.apache.geronimo.clustering.wadi.NodeFactory;
import org.apache.geronimo.clustering.wadi.NodeProxyFactory;
import org.apache.geronimo.clustering.wadi.WADICluster;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.codehaus.wadi.group.Peer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicWADICluster
implements GBeanLifecycle,
WADICluster {
    private final Node node;
    private final DispatcherHolder dispatcherHolder;
    private final NodeFactory nodeFactory;
    private final IdentityHashMap<Peer, Node> peerToNode;
    private final IdentityHashMap<ClusterListener, org.codehaus.wadi.group.ClusterListener> listenerToWADIListener;
    private org.codehaus.wadi.group.Cluster cluster;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_REF_NODE = "Node";
    public static final String GBEAN_REF_DISPATCHER_HOLDER = "DispatcherHolder";

    public BasicWADICluster(Node node, DispatcherHolder dispatcherHolder) {
        this(node, dispatcherHolder, new NodeProxyFactory());
    }

    public BasicWADICluster(Node node, DispatcherHolder dispatcherHolder, NodeFactory nodeFactory) {
        if (null == node) {
            throw new IllegalArgumentException("node is required");
        }
        if (null == dispatcherHolder) {
            throw new IllegalArgumentException("dispatcherHolder is required");
        }
        this.node = node;
        this.dispatcherHolder = dispatcherHolder;
        this.nodeFactory = nodeFactory;
        this.peerToNode = new IdentityHashMap();
        this.listenerToWADIListener = new IdentityHashMap();
    }

    public void doStart() throws Exception {
        this.cluster = this.dispatcherHolder.getDispatcher().getCluster();
    }

    public void doStop() throws Exception {
        this.clearListeners();
    }

    public void doFail() {
        this.clearListeners();
    }

    @Override
    public org.codehaus.wadi.group.Cluster getCluster() {
        return this.cluster;
    }

    public String getName() {
        return this.cluster.getClusterName();
    }

    public Node getLocalNode() {
        return this.node;
    }

    public Set<Node> getRemoteNodes() {
        Collection<Peer> peers = this.cluster.getRemotePeers().values();
        Set<Node> nodes = this.wrapAsNode(peers, false);
        return nodes;
    }

    public void addClusterListener(ClusterListener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("listener is required");
        }
        GeronimoClusterListenerAdaptor wadiListener = new GeronimoClusterListenerAdaptor(listener);
        this.listenerToWADIListener.put(listener, wadiListener);
        this.cluster.addClusterListener((org.codehaus.wadi.group.ClusterListener)wadiListener);
    }

    public void removeClusterListener(ClusterListener listener) {
        org.codehaus.wadi.group.ClusterListener wadiListener = this.listenerToWADIListener.remove(listener);
        if (null == wadiListener) {
            throw new IllegalArgumentException(listener + " is not registered");
        }
        this.cluster.removeClusterListener(wadiListener);
    }

    protected void clearListeners() {
        for (org.codehaus.wadi.group.ClusterListener wadiListener : this.listenerToWADIListener.values()) {
            this.cluster.removeClusterListener(wadiListener);
        }
        this.listenerToWADIListener.clear();
    }

    protected Set<Node> wrapAsNode(Collection<Peer> peers, boolean remove) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (Peer peer : peers) {
            Node node = this.wrapAsNode(peer, remove);
            nodes.add(node);
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node wrapAsNode(Peer peer, boolean remove) {
        Node node;
        IdentityHashMap<Peer, Node> identityHashMap = this.peerToNode;
        synchronized (identityHashMap) {
            if (remove) {
                node = this.peerToNode.remove(peer);
                if (null == node) {
                    throw new AssertionError((Object)"no node mapped to peer");
                }
            } else {
                node = this.peerToNode.get(peer);
                if (null == node) {
                    node = this.newRemoteNode(peer);
                    this.peerToNode.put(peer, node);
                }
            }
        }
        return node;
    }

    protected Node newRemoteNode(Peer peer) {
        return this.nodeFactory.newNode(this.cluster, peer);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"WADI Cluster", BasicWADICluster.class, (String)"GBean");
        infoBuilder.addReference(GBEAN_REF_NODE, Node.class, "GBean");
        infoBuilder.addReference(GBEAN_REF_DISPATCHER_HOLDER, DispatcherHolder.class, "GBean");
        infoBuilder.addInterface(Cluster.class);
        infoBuilder.setConstructor(new String[]{GBEAN_REF_NODE, GBEAN_REF_DISPATCHER_HOLDER});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    protected class GeronimoClusterListenerAdaptor
    implements org.codehaus.wadi.group.ClusterListener {
        private final ClusterListener listener;

        public GeronimoClusterListenerAdaptor(ClusterListener listener) {
            this.listener = listener;
        }

        public void onListenerRegistration(org.codehaus.wadi.group.Cluster cluster, Set existing) {
            Set<Node> existingNodes = BasicWADICluster.this.wrapAsNode(existing, false);
            this.listener.onListenerRegistration((Cluster)BasicWADICluster.this, existingNodes);
        }

        public void onMembershipChanged(org.codehaus.wadi.group.Cluster cluster, Set joiners, Set leavers) {
            Set<Node> joinerNodes = BasicWADICluster.this.wrapAsNode(joiners, false);
            Set<Node> leaverNodes = BasicWADICluster.this.wrapAsNode(leavers, true);
            this.listener.onMembershipChanged((Cluster)BasicWADICluster.this, joinerNodes, leaverNodes);
        }
    }
}

