/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.clustering.LocalNode;
import org.apache.geronimo.clustering.Node;
import org.apache.geronimo.clustering.wadi.BasicNodeService;
import org.apache.geronimo.clustering.wadi.DispatcherHolder;
import org.apache.geronimo.clustering.wadi.NodeServiceHelper;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.codehaus.wadi.core.reflect.ClassIndexerRegistry;
import org.codehaus.wadi.core.reflect.base.DeclaredMemberFilter;
import org.codehaus.wadi.core.reflect.base.MemberFilter;
import org.codehaus.wadi.core.reflect.jdk.JDKClassIndexerRegistry;
import org.codehaus.wadi.group.Dispatcher;
import org.codehaus.wadi.group.DispatcherRegistry;
import org.codehaus.wadi.group.EndPoint;
import org.codehaus.wadi.group.MessageExchangeException;
import org.codehaus.wadi.group.StaticDispatcherRegistry;
import org.codehaus.wadi.servicespace.ServiceSpace;
import org.codehaus.wadi.servicespace.admin.AdminServiceSpace;
import org.codehaus.wadi.tribes.TribesDispatcher;
import org.codehaus.wadi.web.impl.URIEndPoint;

public class TribesDispatcherHolder
implements GBeanLifecycle,
DispatcherHolder {
    private static final Log log = LogFactory.getLog(TribesDispatcherHolder.class);
    private final URI endPointURI;
    private final String clusterName;
    private final LocalNode node;
    private final DispatcherRegistry dispatcherRegistry;
    private TribesDispatcher dispatcher;
    private AdminServiceSpace adminServiceSpace;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_ATTR_END_POINT_URI = "endPointURI";
    public static final String GBEAN_ATTR_CLUSTER_NAME = "clusterName";
    public static final String GBEAN_ATTR_CLUSTER_URI = "clusterUri";
    public static final String GBEAN_REF_NODE = "Node";

    public TribesDispatcherHolder(URI endPointURI, String clusterName, LocalNode node) {
        if (null == endPointURI) {
            throw new IllegalArgumentException("endPointURI is required");
        }
        if (null == clusterName) {
            throw new IllegalArgumentException("clusterName is required");
        }
        if (null == node) {
            throw new IllegalArgumentException("node is required");
        }
        this.endPointURI = endPointURI;
        this.clusterName = clusterName;
        this.node = node;
        this.dispatcherRegistry = new StaticDispatcherRegistry();
    }

    public void doStart() throws Exception {
        this.dispatcher = new TribesDispatcher(this.clusterName, this.node.getName(), (EndPoint)new URIEndPoint(this.endPointURI), (Collection)Collections.EMPTY_SET);
        this.dispatcher.start();
        this.adminServiceSpace = new AdminServiceSpace((Dispatcher)this.dispatcher, (ClassIndexerRegistry)new JDKClassIndexerRegistry((MemberFilter)new DeclaredMemberFilter()));
        this.registerCustomAdminServices();
        this.adminServiceSpace.start();
        this.dispatcherRegistry.register((Dispatcher)this.dispatcher);
    }

    public void doStop() throws Exception {
        this.adminServiceSpace.stop();
        this.dispatcherRegistry.unregister((Dispatcher)this.dispatcher);
        this.dispatcher.stop();
    }

    public void doFail() {
        if (null != this.adminServiceSpace) {
            try {
                this.adminServiceSpace.stop();
            }
            catch (Exception e) {
                log.error((Object)"see nested", (Throwable)e);
            }
        }
        if (null != this.dispatcher) {
            this.dispatcherRegistry.unregister((Dispatcher)this.dispatcher);
            try {
                this.dispatcher.stop();
            }
            catch (MessageExchangeException e) {
                log.error((Object)"see nested", (Throwable)e);
            }
        }
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Node getNode() {
        return this.node;
    }

    protected void registerCustomAdminServices() {
        NodeServiceHelper nodeServiceHelper = new NodeServiceHelper((ServiceSpace)this.adminServiceSpace);
        nodeServiceHelper.registerNodeService(new BasicNodeService(this.node));
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(TribesDispatcherHolder.class, (String)"GBean");
        infoBuilder.addAttribute(GBEAN_ATTR_END_POINT_URI, URI.class, true);
        infoBuilder.addAttribute(GBEAN_ATTR_CLUSTER_NAME, String.class, true);
        infoBuilder.addReference(GBEAN_REF_NODE, LocalNode.class, "GBean");
        infoBuilder.addInterface(DispatcherHolder.class);
        infoBuilder.setConstructor(new String[]{GBEAN_ATTR_END_POINT_URI, GBEAN_ATTR_CLUSTER_NAME, GBEAN_REF_NODE});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

