/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.geronimo.clustering.Cluster;
import org.apache.geronimo.clustering.ClusterListener;
import org.apache.geronimo.clustering.Node;
import org.apache.geronimo.clustering.wadi.DispatcherHolder;
import org.apache.geronimo.clustering.wadi.NodeFactory;
import org.apache.geronimo.clustering.wadi.NodeProxyFactory;
import org.apache.geronimo.clustering.wadi.RemoteNode;
import org.apache.geronimo.clustering.wadi.WADICluster;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.codehaus.wadi.group.Peer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicWADICluster
implements GBeanLifecycle,
WADICluster {
    private final Node node;
    private final DispatcherHolder dispatcherHolder;
    private final NodeFactory nodeFactory;
    private final IdentityHashMap<ClusterListener, org.codehaus.wadi.group.ClusterListener> listenerToWADIListener;
    private final org.codehaus.wadi.group.ClusterListener wrapNodeAsPeerListener;
    private org.codehaus.wadi.group.Cluster cluster;
    public static final String GBEAN_REF_NODE = "Node";
    public static final String GBEAN_REF_DISPATCHER_HOLDER = "DispatcherHolder";

    public BasicWADICluster(@ParamReference(name="Node") Node node, @ParamReference(name="DispatcherHolder") DispatcherHolder dispatcherHolder) {
        this(node, dispatcherHolder, new NodeProxyFactory());
    }

    public BasicWADICluster(Node node, DispatcherHolder dispatcherHolder, NodeFactory nodeFactory) {
        if (null == node) {
            throw new IllegalArgumentException("node is required");
        }
        if (null == dispatcherHolder) {
            throw new IllegalArgumentException("dispatcherHolder is required");
        }
        this.node = node;
        this.dispatcherHolder = dispatcherHolder;
        this.nodeFactory = nodeFactory;
        this.listenerToWADIListener = new IdentityHashMap();
        this.wrapNodeAsPeerListener = new org.codehaus.wadi.group.ClusterListener(){

            public void onListenerRegistration(org.codehaus.wadi.group.Cluster cluster, Set existing) {
                BasicWADICluster.this.wrapAsNode(existing);
            }

            public void onMembershipChanged(org.codehaus.wadi.group.Cluster cluster, Set joiners, Set leavers) {
                BasicWADICluster.this.wrapAsNode(joiners);
            }
        };
    }

    public void doStart() throws Exception {
        this.cluster = this.dispatcherHolder.getDispatcher().getCluster();
        this.cluster.addClusterListener(this.wrapNodeAsPeerListener);
    }

    public void doStop() throws Exception {
        this.cluster.removeClusterListener(this.wrapNodeAsPeerListener);
        this.clearListeners();
    }

    public void doFail() {
        this.cluster.removeClusterListener(this.wrapNodeAsPeerListener);
        this.clearListeners();
    }

    @Override
    public org.codehaus.wadi.group.Cluster getCluster() {
        return this.cluster;
    }

    public String getName() {
        return this.cluster.getClusterName();
    }

    public Node getLocalNode() {
        return this.node;
    }

    public Set<Node> getRemoteNodes() {
        Collection<Peer> peers = this.cluster.getRemotePeers().values();
        Set<Node> nodes = this.wrapAsNode(peers);
        return nodes;
    }

    public void addClusterListener(ClusterListener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("listener is required");
        }
        GeronimoClusterListenerAdaptor wadiListener = new GeronimoClusterListenerAdaptor(listener);
        this.listenerToWADIListener.put(listener, wadiListener);
        this.cluster.addClusterListener((org.codehaus.wadi.group.ClusterListener)wadiListener);
    }

    public void removeClusterListener(ClusterListener listener) {
        org.codehaus.wadi.group.ClusterListener wadiListener = this.listenerToWADIListener.remove(listener);
        if (null == wadiListener) {
            throw new IllegalArgumentException(listener + " is not registered");
        }
        this.cluster.removeClusterListener(wadiListener);
    }

    protected void clearListeners() {
        for (org.codehaus.wadi.group.ClusterListener wadiListener : this.listenerToWADIListener.values()) {
            this.cluster.removeClusterListener(wadiListener);
        }
        this.listenerToWADIListener.clear();
    }

    protected Set<Node> wrapAsNode(Collection<Peer> peers) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (Peer peer : peers) {
            Node node = this.wrapAsNode(peer);
            nodes.add(node);
        }
        return nodes;
    }

    protected Node wrapAsNode(Peer peer) {
        RemoteNode node = RemoteNode.retrieveOptionalAdaptor(peer);
        if (null == node) {
            node = this.newRemoteNode(peer);
        }
        return node;
    }

    protected Node newRemoteNode(Peer peer) {
        return this.nodeFactory.newNode(this.cluster, peer);
    }

    protected class GeronimoClusterListenerAdaptor
    implements org.codehaus.wadi.group.ClusterListener {
        private final ClusterListener listener;

        public GeronimoClusterListenerAdaptor(ClusterListener listener) {
            this.listener = listener;
        }

        public void onListenerRegistration(org.codehaus.wadi.group.Cluster cluster, Set existing) {
            Set<Node> existingNodes = BasicWADICluster.this.wrapAsNode(existing);
            this.listener.onListenerRegistration((Cluster)BasicWADICluster.this, existingNodes);
        }

        public void onMembershipChanged(org.codehaus.wadi.group.Cluster cluster, Set joiners, Set leavers) {
            Set<Node> joinerNodes = BasicWADICluster.this.wrapAsNode(joiners);
            Set<Node> leaverNodes = BasicWADICluster.this.wrapAsNode(leavers);
            this.listener.onMembershipChanged((Cluster)BasicWADICluster.this, joinerNodes, leaverNodes);
        }
    }
}

